/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.PageObject;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.util.RelativeContextUtils;

public class SpliceRelativeContext
extends RelativeContext {
    private List<AbstractPrintWidget> designWidgetToPage = new ArrayList<AbstractPrintWidget>(10);
    private List<AbstractPrintWidget> runningWidgetToPage = new ArrayList<AbstractPrintWidget>(10);
    private double lastRemainHeight = 0.0;
    private PWPage newPage;
    private PageObject pageObject;
    private List<AbstractPrintWidget> splicePagingWidget = new ArrayList<AbstractPrintWidget>(10);
    private Map<String, PdIterator> gridDataMap = new HashMap<String, PdIterator>(16);
    private boolean skipGrid = false;
    private Object group;
    private boolean startNewPage;
    private double prePageWidgetMargin;
    private PWPage calPage;
    private boolean startSplicePrint = false;

    public double getPrePageWidgetMargin() {
        return this.prePageWidgetMargin;
    }

    public void setPrePageWidgetMargin(double prePageWidgetMargin) {
        this.prePageWidgetMargin = prePageWidgetMargin;
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }

    public Object getGroup() {
        return this.group;
    }

    public void setGroup(Object group) {
        this.group = group;
    }

    public PWPage getCalPage() {
        return this.calPage;
    }

    public void setCalPage(PWPage calPage) {
        this.calPage = calPage;
    }

    public Map<String, PdIterator> getGridDataMap() {
        return this.gridDataMap;
    }

    public void setGridDataMap(String id, PdIterator pdIterator) {
        this.gridDataMap.put(id, pdIterator);
    }

    public boolean isSkipGrid() {
        return this.skipGrid;
    }

    public void setSkipGrid(boolean skipGrid) {
        this.skipGrid = skipGrid;
    }

    public List<AbstractPrintWidget> getSplicePagingWidget() {
        return this.splicePagingWidget;
    }

    public void setSplicePagingWidget(List<AbstractPrintWidget> splicePagingWidget) {
        this.splicePagingWidget = splicePagingWidget;
    }

    public void addWidgetToSplicePagingWidget(AbstractPrintWidget widget) {
        this.splicePagingWidget.add(widget);
    }

    public PageObject getPageObject() {
        return this.pageObject;
    }

    public void setPageObject(PageObject pageObject) {
        this.pageObject = pageObject;
    }

    public boolean isStartSplicePrint() {
        return this.startSplicePrint;
    }

    public void setStartSplicePrint(boolean startSplicePrint) {
        this.startSplicePrint = startSplicePrint;
    }

    public PWPage getNewPage() {
        return this.newPage;
    }

    public void addWidgetToNewPage(AbstractPrintWidget widget) {
        this.newPage.getChildren().add(widget);
    }

    public void initNewPage(PWPage rawPage) {
        this.newPage = (PWPage)rawPage.copy();
        List rawChildren = rawPage.getChildren();
        if (rawChildren != null && !rawChildren.isEmpty()) {
            ArrayList<AbstractPrintWidget> children = new ArrayList<AbstractPrintWidget>(10);
            for (AbstractPrintWidget child : rawChildren) {
                if (RelativeContextUtils.isWidgetSplicePrint(this, child)) continue;
                children.add(child);
            }
            this.newPage.setChildren(children);
        }
    }

    public double getLastRemainHeight() {
        return this.lastRemainHeight;
    }

    public void setLastRemainHeight(double lastRemainHeight) {
        this.lastRemainHeight = lastRemainHeight;
    }

    public List<AbstractPrintWidget> getDesignWidgetToPage() {
        return this.designWidgetToPage;
    }

    public List<AbstractPrintWidget> getRunningWidgetToPage() {
        return this.runningWidgetToPage;
    }

    public void setEmptyPage(PWPage emptyPage) {
        this.emptyPage = emptyPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public void addWidgetToDesignPageQ(AbstractPrintWidget widget) {
        this.designWidgetToPage.add(widget);
    }

    public void addWidgetToRunningPageQ(AbstractPrintWidget widget) {
        this.runningWidgetToPage.add(widget);
    }

    public SpliceRelativeContext(PWPage emptyPage, int startPage) {
        super(emptyPage, startPage);
    }

    public SpliceRelativeContext(PWPage emptyPage, PageObject pageObject) {
        this(emptyPage, pageObject.getStartPage());
        this.pageObject = pageObject;
    }

    public double calLastPageRemainHeight(int pageFooterH) {
        Integer lastPageIndex = (Integer)((TreeMap)this.getPagePool()).lastKey();
        double remainHeight = 0.0;
        for (RelativeContext.RelativePosition relativePosition : this.positions) {
            if (relativePosition.getPageIndex() != lastPageIndex.intValue()) continue;
            remainHeight = Math.max(remainHeight, relativePosition.getrY2());
        }
        if (remainHeight == 0.0 && this.checkPageContainFixGrid() && !this.positions.isEmpty()) {
            remainHeight = this.reCalLastPageRemainHeight();
        }
        double pageHeight = this.emptyPage.getRectangle().getHeight() - (double)pageFooterH;
        remainHeight = pageHeight - remainHeight;
        return remainHeight;
    }

    public void clear() {
        this.designWidgetToPage.clear();
        this.runningWidgetToPage.clear();
        if (this.widgetPool != null) {
            this.widgetPool.clear();
        }
        if (this.positions != null) {
            this.positions.clear();
        }
        if (this.positionMap != null) {
            this.positionMap.clear();
        }
        if (this.pagePools != null) {
            this.pagePools.clear();
        }
    }

    public void release() {
        this.clear();
        super.release();
    }

    public void finishDesignPage() {
        this.designWidgetToPage.clear();
        this.runningWidgetToPage.clear();
        this.splicePagingWidget.clear();
        this.gridDataMap.clear();
        if (this.newPage != null) {
            this.newPage.getChildren().clear();
        }
    }

    public boolean isRemainPageUseUp(AbstractPrintWidget widget) {
        double pageHeight;
        double curY2;
        RelativeContext.RelativePosition curPosition = this.findPosition(widget);
        RelativeContext.RelativePosition targetPosition = this.scanRelativePosi(curPosition);
        RelativeContext.RelativePosition absolutePosition = this.scanAbsolutePosi(curPosition);
        if (targetPosition == null) {
            return false;
        }
        double relativeY = curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true);
        double curY1 = relativeY + targetPosition.getrY2();
        if (relativeY < 0.0) {
            relativeY = curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true);
            curY1 = relativeY + targetPosition.getrY2();
        }
        int yFromEvery = -1;
        if (absolutePosition != null) {
            yFromEvery = this.calYByAbsolutePosi(curPosition, absolutePosition);
            if (absolutePosition.getrY2() > targetPosition.getrY2()) {
                curY1 = yFromEvery;
            }
        }
        return (curY2 = curY1 + widget.getRectangle().getHeight()) > (pageHeight = this.emptyPage.getRectangle().getHeight() - (double)this.getFooterHeight());
    }

    private double reCalLastPageRemainHeight() {
        Integer lastPageIndex = (Integer)((TreeMap)this.getPagePool()).lastKey();
        PWPage lastPage = (PWPage)((TreeMap)this.getPagePool()).get(lastPageIndex);
        List children = lastPage.getChildren();
        double maxHeight = 0.0;
        for (AbstractPrintWidget child : children) {
            if (!(child instanceof PWDataGrid) || !((PWDataGrid)child).isFixedRowAtPage()) continue;
            Rectangle rect = child.getRectangle();
            int y = rect.y;
            List outputRows = ((AbstractPWGrid)child).getOutputRows();
            double gridHeight = 0.0;
            for (AbstractPWGridRow row : outputRows) {
                AbstractPWGridCell cell = row.getCell(0);
                if (cell == null) continue;
                gridHeight += cell.getRectangle().getHeight();
            }
            double height = (double)y + gridHeight;
            maxHeight = Math.max(maxHeight, height);
        }
        this.resetFixGridPosition();
        return maxHeight;
    }

    private boolean checkPageContainFixGrid() {
        Integer lastPageIndex = (Integer)((TreeMap)this.getPagePool()).lastKey();
        PWPage lastPage = (PWPage)((TreeMap)this.getPagePool()).get(lastPageIndex);
        List children = lastPage.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (AbstractPrintWidget child : children) {
                if (!(child instanceof PWDataGrid) || !((PWDataGrid)child).isFixedRowAtPage()) continue;
                return true;
            }
        }
        return false;
    }

    private void resetFixGridPosition() {
        HashMap<String, Double> gridHeightMap = new HashMap<String, Double>(16);
        Integer lastPageIndex = (Integer)((TreeMap)this.getPagePool()).lastKey();
        PWPage lastPage = (PWPage)((TreeMap)this.getPagePool()).get(lastPageIndex);
        List children = lastPage.getChildren();
        for (AbstractPrintWidget child : children) {
            if (!(child instanceof PWDataGrid) || !((PWDataGrid)child).isFixedRowAtPage()) continue;
            Rectangle rect = child.getRectangle();
            int y = rect.y;
            List outputRows = ((AbstractPWGrid)child).getOutputRows();
            double gridHeight = 0.0;
            for (AbstractPWGridRow row : outputRows) {
                AbstractPWGridCell cell = row.getCell(0);
                if (cell == null) continue;
                gridHeight += cell.getRectangle().getHeight();
            }
            double height = (double)y + gridHeight;
            gridHeightMap.put(child.getId(), height);
        }
        for (RelativeContext.RelativePosition relativePosition : this.positions) {
            String id = relativePosition.getId();
            if (!gridHeightMap.containsKey(id)) continue;
            relativePosition.setPageIndex(lastPageIndex.intValue());
            relativePosition.setrY2(((Double)gridHeightMap.get(id)).doubleValue());
        }
    }
}

