/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.cardgrid.PWCardGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.headfooter.PWHeadFooter;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.SpliceRelativeContext;
import kd.bos.print.core.utils.PTuple;

@Deprecated
public class RelativeContextUtils {
    private RelativeContextUtils() {
    }

    public static boolean isWidgetSplicePrint(SpliceRelativeContext relativeContext, AbstractPrintWidget widget) {
        List<AbstractPrintWidget> designWidgetToPage = relativeContext.getDesignWidgetToPage();
        for (AbstractPrintWidget temp : designWidgetToPage) {
            if (!temp.getId().equals(widget.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean spliceLastPageIsEmpty(SpliceRelativeContext relativeContext) {
        TreeMap pagePool = (TreeMap)relativeContext.getPagePool();
        PWPage pwPage = (PWPage)pagePool.lastEntry().getValue();
        List children = pwPage.getChildren();
        boolean flag = true;
        for (AbstractPrintWidget widget : children) {
            if (widget instanceof PWHeadFooter || widget.getPrintAtPage() != PrintAtPage.Nature) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean isRemainPageUseUp(SpliceRelativeContext relativeContext, AbstractPrintWidget widget) {
        return relativeContext.isRemainPageUseUp(widget);
    }

    public static List<AbstractPrintWidget> sort(List<AbstractPrintWidget> widgets, PWPage pwPage) {
        double containerHeight = pwPage.getRectangle().getHeight();
        widgets = widgets.stream().sorted((a, b) -> {
            double bNum;
            double aNum = RelativeContextUtils.getSortNum(a, containerHeight);
            if (aNum > (bNum = RelativeContextUtils.getSortNum(b, containerHeight))) {
                return 1;
            }
            if (aNum < bNum) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        return widgets;
    }

    private static double getSortNum(AbstractPrintWidget widget, double containerHeight) {
        if (widget instanceof PWFooter) {
            return -(containerHeight + 10.0);
        }
        return widget.getRectangle().getY();
    }

    public static boolean splicePrint(RuntimeModel runtimeModel, List<PWPage> pwPages) {
        if (CollectionUtils.isEmpty(pwPages) || pwPages.size() == 1 || runtimeModel.getReportModel().getR1PrintInfo().isDynamicPaper()) {
            return false;
        }
        boolean hasUnSuportContol = false;
        block0: for (PWPage page : pwPages) {
            List children = page.getChildren();
            for (AbstractPrintWidget temp : children) {
                if (temp instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)((PWDataGrid)temp).getSubDataGrids())) {
                    hasUnSuportContol = true;
                    continue block0;
                }
                if (!(temp instanceof PWCardGrid) || !((PWCardGrid)temp).isPagePrint()) continue;
                hasUnSuportContol = true;
                continue block0;
            }
        }
        if (hasUnSuportContol) {
            return false;
        }
        return runtimeModel.isSplicePrint();
    }

    public static double lastDesignPageDisY(PWPage pwPage, RelativeContext relativeContext) {
        if (pwPage == null) {
            return 0.0;
        }
        double lastPageMaxY = RelativeContextUtils.lastDesignPageMaxY(pwPage);
        int footerHeight = 0;
        List children = pwPage.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (AbstractPrintWidget widget : children) {
                if (!(widget instanceof PWFooter) || "Header".equals(widget.getType())) continue;
                footerHeight = widget.getRectangle().height;
                break;
            }
        }
        lastPageMaxY = pwPage.getRectangle().getHeight() - (double)footerHeight - lastPageMaxY;
        return lastPageMaxY;
    }

    public static double lastDesignPageMaxY(PWPage pwPage) {
        if (pwPage == null) {
            return 0.0;
        }
        List children = pwPage.getChildren();
        if (children == null || children.isEmpty()) {
            return 0.0;
        }
        double lastPageMaxY = 0.0;
        for (AbstractPrintWidget temp : children) {
            if (temp instanceof PWFooter) continue;
            lastPageMaxY = Math.max(lastPageMaxY, (double)(temp.getRectangle().y + temp.getRectangle().height));
        }
        return lastPageMaxY;
    }

    public static AbstractPrintWidget getDesignWidget(String id, SpliceRelativeContext relativeContext) {
        List<AbstractPrintWidget> designWidgetToPage = relativeContext.getDesignWidgetToPage();
        for (AbstractPrintWidget temp : designWidgetToPage) {
            if (!id.equals(temp.getId())) continue;
            return temp;
        }
        return null;
    }

    public static List<AbstractPrintWidget> getWidgetNeedAddToNewPage(SpliceRelativeContext relativeContext) {
        ArrayList<AbstractPrintWidget> widgetToNewPage = new ArrayList<AbstractPrintWidget>(10);
        List<AbstractPrintWidget> designWidgetToPage = relativeContext.getDesignWidgetToPage();
        for (AbstractPrintWidget temp : designWidgetToPage) {
            if (RelativeContextUtils.isWidgetSplicePrinted(relativeContext, temp)) continue;
            widgetToNewPage.add(temp);
        }
        return widgetToNewPage;
    }

    private static boolean isWidgetSplicePrinted(SpliceRelativeContext relativeContext, AbstractPrintWidget widget) {
        List<AbstractPrintWidget> runningWidgetToPage = relativeContext.getRunningWidgetToPage();
        for (AbstractPrintWidget temp : runningWidgetToPage) {
            if (!temp.getId().equals(widget.getId())) continue;
            return true;
        }
        return false;
    }

    public static double getRelativePositionActualDY2(SpliceRelativeContext relativeContext, AbstractPrintWidget widget, double rawDY2) {
        List<AbstractPrintWidget> splicePagingWidget = relativeContext.getSplicePagingWidget();
        AbstractPrintWidget rawWidget = null;
        for (AbstractPrintWidget temp : splicePagingWidget) {
            if (!temp.getId().equals(widget.getId())) continue;
            rawWidget = temp;
            break;
        }
        double actualDY2 = rawDY2;
        if (rawWidget != null) {
            actualDY2 = actualDY2 + (double)rawWidget.getRectangle().y - (double)RelativeContextUtils.getPageHeaderOrFooterHeight(relativeContext.getCalPage(), true);
        }
        return actualDY2;
    }

    public static int getPageHeaderOrFooterHeight(PWPage pwPage, boolean isHeader) {
        PTuple headerFooterHeight = PWidgetUtil.getHeaderFooterHeight((PWPage)pwPage);
        if (isHeader) {
            return (Integer)headerFooterHeight.item1;
        }
        return (Integer)headerFooterHeight.item2;
    }

    public static boolean checkCanCalNewPage(RelativeContext context) {
        if (!(context instanceof SpliceRelativeContext)) {
            return false;
        }
        if (((SpliceRelativeContext)context).getNewPage() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty((Collection)((SpliceRelativeContext)context).getNewPage().getChildren());
    }

    public static void modifyChildrenYPos(PWPage pwPage) {
        int minY;
        int headHeight = RelativeContextUtils.getPageHeaderOrFooterHeight(pwPage, true);
        List children = pwPage.getChildren();
        int fixMinY = minY = Integer.MAX_VALUE;
        for (AbstractPrintWidget child : children) {
            Rectangle rect;
            if (child instanceof PWFooter || (rect = child.getRectangle()) == null) continue;
            minY = Math.min(minY, rect.y);
            if (child.getPrintAtPage() != PrintAtPage.All) continue;
            fixMinY = Math.min(fixMinY, rect.y + rect.height);
        }
        if (minY != headHeight) {
            int moveY = minY - headHeight;
            for (AbstractPrintWidget child : children) {
                Rectangle rect;
                if (child instanceof PWFooter || child.getPrintAtPage() == PrintAtPage.All || (rect = child.getRectangle()) == null || rect.y > fixMinY) continue;
                rect.setLocation(rect.x, rect.y - moveY);
            }
        }
    }
}

