/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.utils;

import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.exporter.html.render.RowCols;
import kd.bos.print.core.execute.exporter.html.render.TableMergeRender;
import kd.bos.print.core.execute.exporter.html.render.TextRender;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.runner.util.RichTextUtil;
import kd.bos.print.core.utils.HtmlContext;
import kd.bos.print.core.utils.HtmlExportUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class HTMLUtils {
    private static final Log logger = LogFactory.getLog(HTMLUtils.class);
    private static final String RE_TOP_DOMAIN = "(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)";
    private static final String RE_TOP_1 = "(\\w*\\.?){1}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)";
    private static final String RE_TOP_2 = "(\\w*\\.?){2}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)";
    private static final String RE_TOP_3 = "(\\w*\\.?){3}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)";
    private static final Pattern PATTEN_IP = Pattern.compile("((http://)|(https://))?((\\d+\\.){3}(\\d+))");
    private static final Pattern PATTEN_TOP1 = Pattern.compile("(\\w*\\.?){1}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)");
    private static final Pattern PATTEN_TOP2 = Pattern.compile("(\\w*\\.?){2}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)");
    private static final Pattern PATTEN_TOP3 = Pattern.compile("(\\w*\\.?){3}\\.(com\\.cn|net\\.cn|gov\\.cn|org\\.nz|org\\.cn|com|net|org|gov|cc|biz|info|cn|co|me)");

    public static String getDomain(String url, int level) {
        Matcher matcher = PATTEN_IP.matcher(url);
        if (matcher.find()) {
            return matcher.group(4);
        }
        switch (level) {
            case 1: {
                matcher = PATTEN_TOP1.matcher(url);
                break;
            }
            case 2: {
                matcher = PATTEN_TOP2.matcher(url);
                break;
            }
            case 3: {
                matcher = PATTEN_TOP3.matcher(url);
                break;
            }
            default: {
                return "";
            }
        }
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public static Map<String, String> convertRectange(java.awt.Rectangle rectangle, boolean isRelative, boolean overflow, boolean isRoot) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (rectangle != null) {
            returnMap.put("width", HTMLUtils.getHtmlConvertValue(rectangle.width));
            returnMap.put("height", HTMLUtils.getHtmlConvertValue(rectangle.height));
            returnMap.put("left", HTMLUtils.getHtmlConvertValue(rectangle.x));
            if (!isRelative) {
                returnMap.put("position", "absolute");
                if (isRoot) {
                    double lastPageTop = HtmlContext.get().getLastPageTop();
                    if (lastPageTop > 0.0) {
                        returnMap.put("top", lastPageTop + HTMLUtils.lomToPrintPoint(rectangle.y) + HTMLUtils.appendPX());
                    } else {
                        returnMap.put("top", HTMLUtils.getHtmlConvertValue(rectangle.y));
                    }
                    HtmlContext.get().setLastPageTop(lastPageTop += HTMLUtils.lomToPrintPoint(rectangle.height));
                } else {
                    returnMap.put("top", HTMLUtils.getHtmlConvertValue(rectangle.y));
                }
            } else {
                if (!isRoot) {
                    returnMap.put("position", "absolute");
                }
                returnMap.put("top", HTMLUtils.getHtmlConvertValue((int)((double)rectangle.y - HtmlContext.get().getFirstY() + HtmlContext.get().getCurrentHeight() + HtmlContext.get().getCurrentYValue() - HtmlContext.get().getOrginalHeight())));
            }
            if (overflow) {
                returnMap.put("overflow", "hidden");
            }
        }
        return returnMap;
    }

    public static String getHtmlConvertValue(int value) {
        return String.valueOf(HTMLUtils.lomToPrintPoint(value)) + HTMLUtils.appendPX();
    }

    private static double lomToPrintPoint(int value) {
        return KPrintUtil.lomToPrintPoint((double)value);
    }

    public static String appendPX() {
        return "px";
    }

    public static Map<String, String> convertStypleAcess(Style wStyle) {
        return null;
    }

    public static String getHtmlHeader(int width, int height) {
        int realWidth = width;
        int realHeight = height;
        if (height < 26) {
            realHeight = 26;
        }
        if (width < 26) {
            realWidth = 26;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>");
        sb.append("<style> @page { size:").append(realWidth).append("mm ").append(realHeight).append("mm;}\t</style>");
        sb.append("</head>");
        sb.append("<body style=\"font-family:SimSun\">");
        return sb.toString();
    }

    public static String getHtmlTail() {
        return "</body></html>";
    }

    public static int getHeight(String htmlString, int width, int height) {
        int returnHeight = 0;
        if (StringUtils.isNotEmpty((CharSequence)htmlString)) {
            try {
                ITextRenderer render = HtmlExportUtils.getHtmlRender();
                String html = HTMLUtils.replaceBlank(htmlString);
                html = html.replace("&", "");
                render.setDocumentFromString(HTMLUtils.getHtmlHeader(width, height) + "<div>" + html + "</div>" + HTMLUtils.getHtmlTail());
                Dimension dimension = render.getPaintingDimension();
                if (dimension != null) {
                    returnHeight = (int)(dimension.getHeight() / 8.406929146854596);
                }
            }
            catch (DocumentException documentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return returnHeight;
    }

    private static String replaceBlank(String returnString) {
        returnString = returnString.replaceAll("&nbsp;", "\u00a0");
        returnString = returnString.replaceAll("&emsp;", "\u00a0");
        returnString = returnString.replaceAll("&ensp;", "\u00a0");
        returnString = returnString.replaceAll("&thinsp;", "\u00a0");
        return returnString;
    }

    public static String getTextByStyle(Style wStyle, String outputValue) {
        TextRender textRender = new TextRender();
        return textRender.getTextByStyle(wStyle, outputValue);
    }

    public static String getBoderTextByStyle(Style wStyle) {
        StringBuilder borderBuilder = new StringBuilder(" ");
        StyleAttributes sa = wStyle.getNewAttribute();
        borderBuilder.append(HTMLUtils.getLineStyleString(sa, Styles.Position.LEFT));
        borderBuilder.append(HTMLUtils.getLineStyleString(sa, Styles.Position.RIGHT));
        borderBuilder.append(HTMLUtils.getLineStyleString(sa, Styles.Position.TOP));
        borderBuilder.append(HTMLUtils.getLineStyleString(sa, Styles.Position.BOTTOM));
        return borderBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String getLineStyleString(StyleAttributes sa, Styles.Position position) {
        lineStyle = sa.getBorderLineStyle(position);
        borderBuilder = new StringBuilder();
        if (lineStyle == null) ** GOTO lbl-1000
        if (LineStyle.NULL_LINE.equals(lineStyle)) {
            borderBuilder.append(HTMLUtils.getBoderNullByPosition(position));
        } else if (lineStyle != null) {
            if (LineStyle.DOUBLE_LINE_A.equals(lineStyle)) {
                borderBuilder.append(HTMLUtils.getLineStyelAByPostion(position));
            } else if (LineStyle.DOUBLE_LINE_B.equals(lineStyle)) {
                borderBuilder.append(HTMLUtils.getLineStyelBByPostion(position));
            } else {
                borderBuilder.append(HTMLUtils.getLineStyelNormalByPostion(position));
            }
        }
        fontColor = sa.getBorderColor(position);
        if (fontColor != null) {
            borderBuilder.append("border-").append(HTMLUtils.getPStringByPosition(position)).append("-color:").append(StyleAccess.color2string((Color)fontColor)).append(";");
        }
        return borderBuilder.toString();
    }

    private static Object getLineStyelNormalByPostion(Styles.Position position) {
        String width = "border-" + HTMLUtils.getPStringByPosition(position);
        if (StringUtils.isNotEmpty((CharSequence)width)) {
            width = width + "-width:1px;";
        }
        return width;
    }

    private static Object getLineStyelAByPostion(Styles.Position position) {
        String width = "border-" + HTMLUtils.getPStringByPosition(position);
        if (StringUtils.isNotEmpty((CharSequence)width)) {
            width = width + "-width:2px;";
        }
        return width;
    }

    private static String getPStringByPosition(Styles.Position position) {
        String pString = "";
        if (Styles.Position.LEFT.equals(position)) {
            pString = "left";
        } else if (Styles.Position.RIGHT.equals(position)) {
            pString = "right";
        } else if (Styles.Position.TOP.equals(position)) {
            pString = "top";
        } else if (Styles.Position.BOTTOM.equals(position)) {
            pString = "bottom";
        }
        return pString;
    }

    private static String getLineStyelBByPostion(Styles.Position position) {
        String width = "border-" + HTMLUtils.getPStringByPosition(position);
        if (StringUtils.isNotEmpty((CharSequence)width)) {
            width = width + "-width:3px;";
        }
        return width;
    }

    private static String getBoderNullByPosition(Styles.Position position) {
        String border = "border-" + HTMLUtils.getPStringByPosition(position);
        if (StringUtils.isNotEmpty((CharSequence)border)) {
            border = border + ":0;";
        }
        return border;
    }

    public static RowCols getMergedRowColObj(AbstractPWGrid grid, int row, int col) {
        TableMergeRender render = new TableMergeRender(grid);
        return render.getRowsObject(row, col);
    }

    public static int getWidthOfColumn(AbstractPWGrid grid, int row, int col) {
        TableMergeRender render = new TableMergeRender(grid);
        int width = render.getWidthOfColumn(row, col);
        if (-1 == width) {
            AbstractPWGridColumn column = grid.getColumn(col);
            width = column.getWidth();
        }
        return width;
    }

    public static String addDoubleQuotationMark(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return "\"" + value + "\"";
        }
        return "\"\"";
    }

    public static String getAlignStyle(Style wStyle) {
        return wStyle.getHorizontalAlign().toString();
    }

    public static String getCellMergeString(AbstractPWGrid layoutGrid, int r, int c) {
        StringBuilder mergeString = new StringBuilder();
        RowCols cellRowCols = HTMLUtils.getMergedRowColObj(layoutGrid, r, c);
        if (cellRowCols != null) {
            if (cellRowCols.getCol() == -1 || cellRowCols.getRow() == -1) {
                return "NEED_INGORE";
            }
            if (cellRowCols.getCol() != 1) {
                mergeString.append(" colspan=").append(HTMLUtils.addDoubleQuotationMark(String.valueOf(cellRowCols.getCol()))).append(" ");
            }
            if (cellRowCols.getRow() != 1) {
                mergeString.append(" rowspan=").append(HTMLUtils.addDoubleQuotationMark(String.valueOf(cellRowCols.getRow()))).append(" ");
            }
        }
        return mergeString.toString();
    }

    public static String getBackground(Style wStyle) {
        String color = "";
        if (wStyle.getBackground() != null) {
            color = "background-color:" + StyleAccess.color2string((Color)wStyle.getBackground()) + ";";
        }
        return color;
    }

    public static void setContextCurrentHeigh(java.awt.Rectangle rectangle) {
        HtmlContext.get().setCurrentHeight(rectangle.getHeight());
    }

    public static void setContextCurrentYValue(java.awt.Rectangle rectangle, double oldMaxHeight, double oldMaxY) {
        HtmlContext.get().setFirstY(rectangle.y);
        HtmlContext.get().setMaxY(rectangle.y);
        if (HtmlContext.get().getCurrentYValue() > 0.0) {
            HtmlContext.get().setCurrentYValue(HtmlContext.get().getMaxHeight() - rectangle.getHeight());
        } else {
            HtmlContext.get().setCurrentYValue(rectangle.y);
        }
    }

    public static Rectangle getPageSize(R1PrintInfo info) {
        Rectangle returnValue = PageSize.A4;
        if (info != null) {
            boolean needCalcluate = false;
            switch (info.getPaperName()) {
                case "B4": {
                    returnValue = PageSize.B4;
                    break;
                }
                case "B5": {
                    returnValue = PageSize.B5;
                    break;
                }
                case "A3": {
                    returnValue = PageSize.A3;
                    break;
                }
                case "A4": {
                    returnValue = PageSize.A4;
                    break;
                }
                case "A5": {
                    returnValue = PageSize.A5;
                    break;
                }
                default: {
                    Dimension dim = info.getPrintableAreaSize();
                    returnValue = new Rectangle(HTMLUtils.getConvertValue(dim.getWidth()), HTMLUtils.getConvertValue(dim.getHeight()));
                }
            }
        }
        return returnValue;
    }

    private static float getConvertValue(double value) {
        return (float)(value / 3.64);
    }

    public static String getPageHtmlString(R1PrintInfo printInfo) {
        String paperName = printInfo.getPaperName();
        String landscape = printInfo.getOrientation();
        int width = HTMLUtils.getRealMM(printInfo.getCustomWidth());
        int height = HTMLUtils.getRealMM(printInfo.getCustomHeight());
        StringBuilder sb = new StringBuilder("<style> @page {");
        if (StringUtils.isNotEmpty((CharSequence)paperName) && !HTMLUtils.isCustom(paperName)) {
            sb.append(" size:").append(paperName);
            if (StringUtils.isNotEmpty((CharSequence)landscape)) {
                sb.append(" ").append(landscape);
            }
            sb.append(" ;");
        }
        if (HTMLUtils.isCustom(paperName)) {
            sb.append(" size:").append(width).append("mm ").append(height).append("mm;");
        }
        sb.append("margin-top:").append(HTMLUtils.getRealMM(printInfo.getMarginTop())).append("mm;");
        sb.append("margin-bottom:").append(HTMLUtils.getRealMM(printInfo.getMarginBottom())).append("mm;");
        sb.append("margin-left:").append(HTMLUtils.getRealMM(printInfo.getMarginLeft())).append("mm;");
        sb.append("margin-right:").append(HTMLUtils.getRealMM(printInfo.getMarginRight())).append("mm;");
        sb.append("} </style>");
        return sb.toString();
    }

    public static StringBuilder getPageHtmlStringBuilder(R1PrintInfo printInfo) {
        return HTMLUtils.getPageHtmlStringBuilder(printInfo, false);
    }

    public static StringBuilder initPageHtmlString() {
        return RichTextUtil.initPageHtmlString();
    }

    public static StringBuilder getPageHtmlStringBuilder(R1PrintInfo printInfo, boolean isFirst) {
        return RichTextUtil.getPageHtmlStringBuilder((R1PrintInfo)printInfo, (boolean)isFirst);
    }

    public static int getRealMM(double mmValue) {
        return (int)(mmValue / 10.0);
    }

    private static boolean isCustom(String paperName) {
        return "Custom".equals(paperName);
    }

    private static java.awt.Rectangle getByPaperName(String paperName) {
        java.awt.Rectangle returnValue = new java.awt.Rectangle();
        switch (paperName) {
            case "B3": {
                returnValue = new java.awt.Rectangle(0, 0, 176, 250);
                break;
            }
            case "B4": {
                returnValue = new java.awt.Rectangle(0, 0, 250, 353);
                break;
            }
            case "B5": {
                returnValue = new java.awt.Rectangle(0, 0, 182, 257);
                break;
            }
            case "A3": {
                returnValue = new java.awt.Rectangle(0, 0, 297, 420);
                break;
            }
            case "A4": {
                returnValue = new java.awt.Rectangle(0, 0, 210, 297);
                break;
            }
            case "A5": {
                returnValue = new java.awt.Rectangle(0, 0, 148, 210);
                break;
            }
        }
        return returnValue;
    }

    public static int getPapaerHeight(R1PrintInfo printInfo) {
        String paperName = printInfo.getPaperName();
        java.awt.Rectangle last = HTMLUtils.getByPaperName(paperName);
        return (int)last.getHeight();
    }

    public static void setOrginalHeight(double orginalHeight) {
        HtmlContext.get().setOrginalHeight(orginalHeight);
    }

    public static String parseHtmlImgSrc(String prtHtml, List<String> srcList) {
        return RichTextUtil.parseHtmlImgSrc((String)prtHtml, srcList);
    }

    public static String parseHtmlFontSrc(String prtHtml) {
        Document doc = Jsoup.parse((String)prtHtml, (String)"", (Parser)Parser.xmlParser());
        Elements imgList = doc.select("img[src]");
        int i = 0;
        for (Element element : imgList) {
            String src = element.attr("src");
            ++i;
        }
        return doc.toString();
    }

    public static List<String> getSrcList(String prtHtml) {
        return RichTextUtil.getSrcList((String)prtHtml);
    }
}

