/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.utils;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfPageEventHelper;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.print.io.WatermarkPageEvent;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.html.page.CusPdfPageEventHelper;
import kd.bos.print.core.html.page.FlyingSaucerPDFCreationListener;
import kd.bos.print.core.html.page.RichTextUserAgent;
import kd.bos.print.core.html.page.WaterMarkPDFCreationListener;
import kd.bos.print.core.model.widget.runner.util.RichTextUtil;
import kd.bos.print.core.service.IFontService;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.pdf.PDFCreationListener;

public class HtmlExportUtils {
    private static final String UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getLog(HtmlExportUtils.class);
    private static Map<String, List<Font>> ALL_FONTS = new HashMap<String, List<Font>>();

    public static String getFontsConverted(String html, String tenantId) {
        String returnString = html;
        returnString = HtmlExportUtils.replaceBlank(returnString);
        List<Font> fList = ALL_FONTS.get(tenantId);
        if (fList == null || fList.size() < 1) {
            fList = new ArrayList<Font>(10);
            String[] fontPaths = HtmlExportUtils.getFontsList();
            if (fontPaths != null) {
                for (int i = 0; i < fontPaths.length; ++i) {
                    Font font = null;
                    try {
                        font = Font.createFont(0, new File(fontPaths[i]));
                    }
                    catch (FontFormatException | IOException exception) {
                        // empty catch block
                    }
                    fList.add(font);
                }
            }
            ALL_FONTS.put(tenantId, fList);
        }
        if (fList != null && fList.size() > 0) {
            for (Font font : fList) {
                String rex = "font-family:(\\s*)" + font.getName();
                String replaceString = "font-family: " + font.getName() + "," + font.getFamily(Locale.ENGLISH);
                returnString = returnString.replaceAll(rex, replaceString);
                rex = "font-family:(\\s*)'" + font.getName() + "'";
                returnString = returnString.replaceAll(rex, replaceString);
            }
        }
        return returnString;
    }

    private static String replaceBlank(String returnString) {
        returnString = returnString.replaceAll("&nbsp;", "\u00a0");
        returnString = returnString.replaceAll("&emsp;", "\u00a0");
        returnString = returnString.replaceAll("&ensp;", "\u00a0");
        returnString = returnString.replaceAll("&thinsp;", "\u00a0");
        return returnString;
    }

    public static String convertToXhtml(String html) throws UnsupportedEncodingException {
        Tidy tidy = new Tidy();
        tidy.setInputEncoding(UTF_8);
        tidy.setOutputEncoding(UTF_8);
        tidy.setXHTML(true);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(html.getBytes(UTF_8));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        tidy.parseDOM((InputStream)inputStream, (OutputStream)outputStream);
        return outputStream.toString(UTF_8);
    }

    public static void saveXhtml2PDF(RuntimeModel runtimeModel, String htmlStr, String path, String fileName) throws IOException, DocumentException {
        ITextRenderer renderer = HtmlExportUtils.getHtmlRender();
        FileOutputStream outputStream = new FileOutputStream(fileName);
        renderer.setDocumentFromString(htmlStr);
        renderer.layout();
        renderer.createPDF((OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    public static void saveXhtml2PDF(RuntimeModel runtimeModel, String htmlStr, OutputStream outputStream) throws IOException, DocumentException {
        ITextRenderer renderer = HtmlExportUtils.getHtmlRender();
        if (runtimeModel.getWaterMark() != null) {
            WatermarkPageEvent watermarkEvent = new WatermarkPageEvent();
            watermarkEvent.setWaterMark(runtimeModel.getWaterMark());
            WaterMarkPDFCreationListener listener = new WaterMarkPDFCreationListener((PdfPageEventHelper)watermarkEvent);
            renderer.setListener((PDFCreationListener)listener);
        }
        renderer.setDocumentFromString(htmlStr);
        renderer.layout();
        renderer.createPDF(outputStream);
        outputStream.close();
    }

    public static ITextRenderer getHtmlRender() throws DocumentException, IOException {
        String[] fontPaths = new String[]{"Alibaba PuHuiTi R.ttf", "simsun.ttc", "FZLanTingHeiS-R-GB.ttf", "FZXiYuan-M01S.ttf", "SimHei.ttf"};
        IFontService fontService = ExecuteService.getFontService();
        String[] deFaultfontPaths = new String[]{fontService.getFontFilesDir() + File.separator + fontService.getDefaultFont().getFontFileName()};
        try {
            fontPaths = HtmlExportUtils.getFontsList();
            return HtmlExportUtils.getHtmlRender(fontPaths);
        }
        catch (Exception exception) {
            return HtmlExportUtils.getHtmlRender(deFaultfontPaths);
        }
    }

    public static String[] getFontsList() {
        return RichTextUtil.getFontsList();
    }

    private static ITextRenderer getHtmlRender(String[] fontPaths) throws DocumentException, IOException {
        float DEFAULT_DOTS_PER_POINT = 26.666666f;
        int DEFAULT_DOTS_PER_PIXEL = 20;
        ITextOutputDevice iTextOutputDevice = new ITextOutputDevice(DEFAULT_DOTS_PER_POINT);
        ITextRenderer renderer = new ITextRenderer(DEFAULT_DOTS_PER_POINT, DEFAULT_DOTS_PER_PIXEL, iTextOutputDevice, (ITextUserAgent)new RichTextUserAgent(iTextOutputDevice));
        ITextFontResolver fontResolver = renderer.getFontResolver();
        for (String fontPath : fontPaths) {
            if (fontPath == null) continue;
            fontResolver.addFont(fontPath, "Identity-H", false);
        }
        CusPdfPageEventHelper cusPageEvent = new CusPdfPageEventHelper();
        FlyingSaucerPDFCreationListener listener = new FlyingSaucerPDFCreationListener(cusPageEvent);
        renderer.setListener((PDFCreationListener)listener);
        return renderer;
    }

    public static void convertInputStream2OutputStream(InputStream input, OutputStream ouput) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, UTF_8));){
            int n;
            byte[] buffer = new byte[1024];
            while ((n = input.read(buffer)) != -1) {
                ouput.write(buffer, 0, n);
            }
        }
    }
}

