/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.utils;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PDFUtils {
    private static final Log log = LogFactory.getLog(PDFUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeMultiPdf(String pdfName, List<byte[]> pdfPages, OutputStream outputStream) {
        Document document = new Document();
        PdfReader reader = null;
        try {
            PdfCopy copy = new PdfCopy(document, outputStream);
            document.addTitle(pdfName + ".pdf");
            document.open();
            for (byte[] bytes : pdfPages) {
                reader = new PdfReader(bytes);
                int page = 0;
                while (page < reader.getNumberOfPages()) {
                    copy.addPage(copy.getImportedPage(reader, ++page));
                }
            }
            copy.freeReader(reader);
        }
        catch (Exception exception) {
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            if (reader != null) {
                reader.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static ByteArrayInputStream parse(OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
        return swapStream;
    }

    public static void mergePdfStreams(List<InputStream> inputPdfList, OutputStream outputStream) throws Exception {
        Document document = new Document();
        ArrayList<PdfReader> readers = new ArrayList<PdfReader>(10);
        int totalPages = 0;
        for (InputStream pdf : inputPdfList) {
            PdfReader pdfReader = new PdfReader(pdf);
            readers.add(pdfReader);
            totalPages += pdfReader.getNumberOfPages();
        }
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PdfContentByte pageContentByte = writer.getDirectContent();
        int currentPdfReaderPage = 1;
        for (PdfReader pdfReader : readers) {
            while (currentPdfReaderPage <= pdfReader.getNumberOfPages()) {
                document.newPage();
                PdfImportedPage pdfImportedPage = writer.getImportedPage(pdfReader, currentPdfReaderPage);
                pageContentByte.addTemplate((PdfTemplate)pdfImportedPage, 0.0f, 0.0f);
                ++currentPdfReaderPage;
            }
            currentPdfReaderPage = 1;
        }
        document.close();
    }
}

