/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.print;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.print.QueryDataEventArgs;
import kd.bos.entity.print.ScriptPrintServicePluginProxy;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ScriptPrintService {
    public static final String CLASS_NAME = "className";
    public static final String CONFIG_KEY = "configKey";
    public static final String CONFIGKEY = "configkey";
    private static Log log = LogFactory.getLog(ScriptPrintService.class);
    private static final String PACKAGE_NAME_KEY = "bos-servicehelper";

    public boolean createPrintJob(String configKey, String cacheId, String filepath, LocaleString jobName, Object printerId, String printType) {
        return this.createPrintJob(configKey, cacheId, filepath, jobName, printerId, printType, new Date());
    }

    public boolean createPrintJob(String configKey, String cacheId, String filepath, LocaleString jobName, Object printerId, String printType, Date dateTime) {
        DynamicObject serviceObj;
        boolean isSuccess = false;
        if (StringUtils.isEmpty((CharSequence)configKey) && StringUtils.isEmpty((CharSequence)cacheId) && StringUtils.isEmpty((CharSequence)filepath)) {
            return isSuccess;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(printerId)))};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_cloudprinter", (QFilter[])filters);
        String printerAddress = "";
        if (obj != null && obj.get("printeraddress") != null) {
            printerAddress = obj.get("printeraddress").toString();
        }
        DynamicObject dynamicObject = serviceObj = null == obj ? null : (DynamicObject)obj.get("serviceid");
        if (null == serviceObj) {
            return isSuccess;
        }
        if (StringUtils.isNotBlank((CharSequence)printerAddress)) {
            Object serviceId = serviceObj.getPkValue();
            ORM orm = ORM.create();
            DynamicObject dynamicObject2 = orm.newDynamicObject("bos_printtask");
            dynamicObject2.set("id", (Object)orm.genLongId("bos_printtask"));
            dynamicObject2.set("name", (Object)jobName);
            dynamicObject2.set("number", (Object)UUID.randomUUID());
            dynamicObject2.set("accountid", (Object)RequestContext.get().getAccountId());
            dynamicObject2.set("serviceId", serviceId);
            dynamicObject2.set("bsdprinter", (Object)obj);
            dynamicObject2.set("printeraddress", (Object)printerAddress);
            dynamicObject2.set(CONFIGKEY, (Object)configKey);
            dynamicObject2.set("cacheid", (Object)cacheId);
            dynamicObject2.set("printstatus", (Object)1);
            dynamicObject2.set("filepath", (Object)filepath);
            dynamicObject2.set("modifytime", (Object)dateTime);
            dynamicObject2.set("createtime", (Object)dateTime);
            dynamicObject2.set("enable", (Object)1);
            dynamicObject2.set("printtype", (Object)printType);
            dynamicObject2.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject2.set("createtimestamp", (Object)System.currentTimeMillis());
            Object[] insertObj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject2});
            if (!ObjectUtils.isEmpty((Object[])insertObj)) {
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    public boolean createEasyScriptPrintJob(String formId, Object templatePkId, Object printerPkId, Map<String, String> values) {
        HashMap<String, Object> convertMap = new HashMap<String, Object>(values);
        String ptScript = this.buildOnePrintScript(templatePkId, convertMap);
        String fileName = String.valueOf(System.currentTimeMillis()) + "_script.txt";
        ByteArrayInputStream input = new ByteArrayInputStream(ptScript.getBytes());
        Map mp = CacheFactory.getCommonCacheFactory().getTempFileCache().save(fileName, (InputStream)input, 600);
        String configKey = (String)mp.get(CONFIG_KEY);
        if (StringUtils.isBlank((CharSequence)configKey)) {
            configKey = (String)mp.get(CONFIGKEY);
        }
        String cacheId = (String)mp.get("id");
        ByteArrayInputStream input2 = new ByteArrayInputStream(ptScript.getBytes());
        String path = this.getFilePath(fileName);
        LocaleString taskName = new LocaleString(formId + "_" + templatePkId.toString());
        String fileUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, path, (InputStream)input2));
        return this.createPrintJob(configKey, cacheId, fileUrl, taskName, printerPkId, "zpl");
    }

    private String getFilePath(String fileName) {
        String format = "/%s/%s/%s/%s/%s/%s";
        String path = String.format(format, RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), "printtpl", this.getDateStr(), RequestContext.get().getUserId(), fileName);
        return path;
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    public boolean createScriptPrintJob(String formId, Object billPkId, Object templatePkId, Object printerPkId, String separator, Boolean isShowLastSep) {
        return this.createScriptPrintJob(formId, billPkId, templatePkId, printerPkId, separator, isShowLastSep, false);
    }

    public boolean createScriptPrintJob(String formId, Object billPkId, Object templatePkId, Object printerPkId, String separator, Boolean isShowLastSep, boolean isSplitEntry) {
        if (isSplitEntry) {
            List<String> scripts = this.buildSeparatePrintScript(formId, templatePkId, billPkId, separator, isShowLastSep);
            int i = 1;
            for (String script : scripts) {
                Date now = new Date();
                long time = i * 60 * 1000;
                Date afterDate = new Date(now.getTime() + time);
                this.createScriptPrintJob(printerPkId, script, afterDate);
                ++i;
            }
            return true;
        }
        String ptScript = this.buildOnePrintScript(formId, templatePkId, billPkId, separator, isShowLastSep);
        return this.createScriptPrintJob(printerPkId, ptScript);
    }

    public boolean createScriptPrintJob(Object printerPkId, String ptScript) {
        String fileName = String.valueOf(System.currentTimeMillis()) + "_script.txt";
        ByteArrayInputStream input = new ByteArrayInputStream(ptScript.getBytes());
        Map mp = CacheFactory.getCommonCacheFactory().getTempFileCache().save(fileName, (InputStream)input, 600);
        String configKey = (String)mp.get(CONFIG_KEY);
        if (StringUtils.isBlank((CharSequence)configKey)) {
            configKey = (String)mp.get(CONFIGKEY);
        }
        String cacheId = (String)mp.get("id");
        ByteArrayInputStream input2 = new ByteArrayInputStream(ptScript.getBytes());
        LocaleString taskName = new LocaleString(fileName);
        String fileUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, this.getFilePath(fileName), (InputStream)input2));
        return this.createPrintJob(configKey, cacheId, fileUrl, taskName, printerPkId, "zpl");
    }

    public boolean createScriptPrintJob(Object printerPkId, String ptScript, Date dateTime) {
        String fileName = String.valueOf(System.currentTimeMillis()) + "_script.txt";
        ByteArrayInputStream input = new ByteArrayInputStream(ptScript.getBytes());
        Map mp = CacheFactory.getCommonCacheFactory().getTempFileCache().save(fileName, (InputStream)input, 600);
        String configKey = (String)mp.get(CONFIG_KEY);
        if (StringUtils.isBlank((CharSequence)configKey)) {
            configKey = (String)mp.get(CONFIGKEY);
        }
        String cacheId = (String)mp.get("id");
        ByteArrayInputStream input2 = new ByteArrayInputStream(ptScript.getBytes());
        LocaleString taskName = new LocaleString(fileName);
        String fileUrl = FileServiceFactory.getAttachmentFileService().upload(new FileItem(fileName, this.getFilePath(fileName), (InputStream)input2));
        return this.createPrintJob(configKey, cacheId, fileUrl, taskName, printerPkId, "zpl", dateTime);
    }

    private String buildOnePrintScript(Object templatePkId, Map<String, Object> varAndValues) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(templatePkId)))};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_scripttemplate", (QFilter[])filters);
        if (template == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6a21\u677f\u662f\u5426\u5b58\u5728\u6216\u6a21\u677f\u7684\u72b6\u6001\u662f\u5426\u6b63\u786e\u3002", (String)"ScriptPrintService_0", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        String scriptContent = template.getString("scriptcontent_tag");
        if (StringUtils.isEmpty((CharSequence)scriptContent)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u811a\u672c\u4e3a\u7a7a\u3002", (String)"ScriptPrintService_1", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        for (Map.Entry<String, Object> entry : varAndValues.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (StringUtils.isBlank((Object)value)) {
                value = "!del!";
            }
            String kk = "(?i)" + key.replace("$", "\\$");
            scriptContent = scriptContent.replaceAll(kk, value.toString());
        }
        String clNormalLabel = this.clearNormalLabelLine(scriptContent);
        return this.clearTotalLabel(clNormalLabel);
    }

    private String buildOnePrintScript(String formId, Object templatePkId, Object billPkId, String separator, Boolean isShowLastSep) {
        String keyPattern;
        String value;
        String key;
        HashMap<String, String> usedNormalVar = new HashMap<String, String>();
        HashMap<String, String> usedSummaryVar = new HashMap<String, String>();
        HashMap<String, String> fieldMapping = new HashMap<String, String>();
        HashMap<String, String> splitSymbolMapping = new HashMap<String, String>();
        HashMap<String, Integer> varNewlineIndex = new HashMap<String, Integer>();
        QFilter[] templateFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(templatePkId)))};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_scripttemplate", (QFilter[])templateFilters);
        if (template == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6a21\u677f\u662f\u5426\u5b58\u5728\u6216\u6a21\u677f\u7684\u72b6\u6001\u662f\u5426\u6b63\u786e\u3002", (String)"ScriptPrintService_0", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        String scriptContent = template.getString("scriptcontent_tag");
        if (!StringUtils.isEmpty((CharSequence)scriptContent)) {
            String pattern = "\\$(.+?)\\$";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(scriptContent);
            while (m.find()) {
                String key2 = m.group();
                if (key2.contains("_List") || key2.contains("_LIST")) {
                    usedSummaryVar.put(key2.toLowerCase(), "");
                    continue;
                }
                usedNormalVar.put(key2.toLowerCase(), "");
            }
        } else {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u811a\u672c\u4e3a\u7a7a\u3002", (String)"ScriptPrintService_1", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        QFilter[] filters = new QFilter[]{new QFilter("busibill", "=", (Object)formId), new QFilter("enable", "=", (Object)"1")};
        DynamicObject mappingObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_variablemapping", (QFilter[])filters);
        if (mappingObj == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        DynamicObjectCollection mappings = mappingObj.getDynamicObjectCollection("mappinfield");
        if (mappings == null || mappings.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        HashSet<String> filterFields = new HashSet<String>(mappings.size());
        for (DynamicObject o : mappings) {
            int nlIndex;
            String mpField = (String)o.get("varfield");
            if (StringUtils.isBlank((CharSequence)mpField)) continue;
            DynamicObject varbsd = (DynamicObject)o.get("variable");
            String varName = (String)varbsd.get("number");
            Object splitSymbol = o.get("splitsymbol");
            Object rtIdxValue = o.get("newlineidx");
            filterFields.add(mpField);
            fieldMapping.put(varName.toLowerCase(), mpField);
            if (rtIdxValue != null && (nlIndex = Integer.parseInt(rtIdxValue.toString())) > 0) {
                varNewlineIndex.put(varName.toLowerCase(), nlIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)separator)) {
                splitSymbolMapping.put(varName.toLowerCase(), separator);
                continue;
            }
            if (StringUtils.isNotBlank((Object)splitSymbol)) {
                splitSymbolMapping.put(varName.toLowerCase(), splitSymbol.toString());
                continue;
            }
            splitSymbolMapping.put(varName.toLowerCase(), "");
        }
        if (filterFields.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        filterFields.add("id");
        Set totalVars = Stream.concat(usedNormalVar.keySet().stream(), usedSummaryVar.keySet().stream()).collect(Collectors.toSet());
        Object plugin = mappingObj.get("scriptplugin");
        ScriptPrintServicePluginProxy proxy = this.getPluginProxy(plugin);
        QueryDataEventArgs args = new QueryDataEventArgs((Object)this, formId, billPkId, templatePkId, fieldMapping, totalVars);
        if (proxy != null) {
            proxy.fireDoQueryData(args);
        }
        if (args.getRecords() != null && !args.getRecords().isEmpty()) {
            log.debug("\u811a\u672c\u6253\u5370\uff1a\u63d2\u4ef6\u63d0\u4f9b\u4e86\u6570\u636e\uff0c \u63d2\u4ef6\u540d\u79f0-" + plugin);
            List records = args.getRecords();
            return this.buildOnePrintScript(templatePkId, (Map)records.get(0));
        }
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", billPkId)};
        int idx = 0;
        String selectFields = filterFields.stream().collect(Collectors.joining(","));
        Throwable throwable = null;
        try (DataSet queryDataSet = orm.queryDataSet("ScriptPrintService.query", formId, selectFields, qFilters);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                for (Map.Entry entry : usedNormalVar.entrySet()) {
                    String key3 = (String)entry.getKey();
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)usedNormalVar.get(key3))) && !"!del!".equalsIgnoreCase((String)usedNormalVar.get(key3))) continue;
                    Object value2 = "";
                    if (fieldMapping.containsKey(key3)) {
                        String mapFieldName = (String)fieldMapping.get(key3);
                        value2 = r.get(mapFieldName);
                        if (StringUtils.isNotBlank((Object)value2) && varNewlineIndex.containsKey(key3)) {
                            int returnIdx = (Integer)varNewlineIndex.get(key3);
                            if (value2.toString().length() > returnIdx) {
                                StringBuilder sb = new StringBuilder(value2.toString());
                                sb.insert(returnIdx, "_0D_0A");
                                value2 = sb.toString();
                            }
                        }
                    } else {
                        String pat = "#[\\d]+";
                        Pattern p2 = Pattern.compile(pat);
                        Matcher m2 = p2.matcher(key3);
                        if (m2.find()) {
                            String nv = m2.group();
                            int index = Integer.parseInt(nv.substring(1, nv.length()));
                            if (index == idx) {
                                String realVar = key3.replace(nv, "");
                                if (fieldMapping.containsKey(realVar)) {
                                    String mapFieldName = (String)fieldMapping.get(realVar);
                                    value2 = r.get(mapFieldName);
                                    if (StringUtils.isNotBlank((Object)value2)) {
                                        if (varNewlineIndex.containsKey(realVar)) {
                                            int returnIdx = (Integer)varNewlineIndex.get(realVar);
                                            if (value2.toString().length() > returnIdx) {
                                                StringBuilder sb = new StringBuilder(value2.toString());
                                                sb.insert(returnIdx, "_0D_0A");
                                                value2 = sb.toString();
                                            }
                                        }
                                    } else {
                                        value2 = "!del!";
                                    }
                                } else {
                                    value2 = "!del!";
                                }
                            } else {
                                value2 = "!del!";
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((Object)value2)) {
                        usedNormalVar.put(key3.toLowerCase(), value2.toString());
                        continue;
                    }
                    usedNormalVar.put(key3.toLowerCase(), "");
                }
                for (Map.Entry entry : usedSummaryVar.entrySet()) {
                    String key2 = (String)entry.getKey();
                    String summaryValue = (String)usedSummaryVar.get(key2);
                    if (!fieldMapping.containsKey(key2)) continue;
                    StringBuilder sb = new StringBuilder(summaryValue);
                    String mapFieldName = (String)fieldMapping.get(key2);
                    String splitSymbol = (String)splitSymbolMapping.get(key2);
                    Object value3 = r.get(mapFieldName);
                    if (value3 != null) {
                        if (summaryValue.length() > 0 && StringUtils.isNotBlank((CharSequence)splitSymbol)) {
                            if (splitSymbol.startsWith("\\")) {
                                sb.append("\\").append(splitSymbol);
                            } else {
                                sb.append(splitSymbol);
                            }
                        }
                        sb.append(value3);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)sb.toString())) continue;
                    usedSummaryVar.put(key2.toLowerCase(), sb.toString());
                }
                ++idx;
            }
        }
        catch (Throwable iterator) {
            Throwable throwable2 = iterator;
            throw iterator;
        }
        for (Map.Entry entry : usedNormalVar.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            keyPattern = "(?i)" + key;
            keyPattern = keyPattern.replace("$", "\\$");
            scriptContent = scriptContent.replaceAll(keyPattern, value);
        }
        for (Map.Entry entry : usedSummaryVar.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if (isShowLastSep.booleanValue()) {
                value = value + separator;
            }
            keyPattern = "(?i)" + key;
            keyPattern = keyPattern.replace("$", "\\$");
            scriptContent = scriptContent.replaceAll(keyPattern, value);
        }
        String rLabel = this.clearNormalLabelLine(scriptContent);
        return this.clearTotalLabel(rLabel);
    }

    private List<String> buildSeparatePrintScript(String formId, Object templatePkId, Object billPkId, String separator, Boolean isShowLastSep) {
        ArrayList<String> scripts = new ArrayList<String>(10);
        HashMap<String, String> usedNormalVar = new HashMap<String, String>();
        HashMap<String, String> usedSummaryVar = new HashMap<String, String>();
        HashMap<String, String> fieldMapping = new HashMap<String, String>();
        HashMap<String, String> splitSymbolMapping = new HashMap<String, String>();
        HashMap<String, Integer> varNewlineIndex = new HashMap<String, Integer>();
        QFilter[] templateFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(templatePkId)))};
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_scripttemplate", (QFilter[])templateFilters);
        if (template == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6a21\u677f\u662f\u5426\u5b58\u5728\u6216\u6a21\u677f\u7684\u72b6\u6001\u662f\u5426\u6b63\u786e\u3002", (String)"ScriptPrintService_0", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        String scriptContent = template.getString("scriptcontent_tag");
        if (!StringUtils.isEmpty((CharSequence)scriptContent)) {
            String pattern = "\\$(.+?)\\$";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(scriptContent);
            while (m.find()) {
                String key = m.group();
                if (key.contains("_List") || key.contains("_LIST")) {
                    usedSummaryVar.put(key.toLowerCase(), "");
                    continue;
                }
                usedNormalVar.put(key.toLowerCase(), "");
            }
        } else {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u811a\u672c\u4e3a\u7a7a\u3002", (String)"ScriptPrintService_1", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        QFilter[] filters = new QFilter[]{new QFilter("busibill", "=", (Object)formId), new QFilter("enable", "=", (Object)"1")};
        DynamicObject mappingObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_variablemapping", (QFilter[])filters);
        if (mappingObj == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        DynamicObjectCollection mappingItems = mappingObj.getDynamicObjectCollection("mappinfield");
        if (mappingItems == null || mappingItems.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        HashSet<String> filterFields = new HashSet<String>(mappingItems.size());
        for (DynamicObject o : mappingItems) {
            int nlIndex;
            String mpField = (String)o.get("varfield");
            if (StringUtils.isBlank((CharSequence)mpField)) continue;
            DynamicObject varbsd = (DynamicObject)o.get("variable");
            String varName = (String)varbsd.get("number");
            Object splitSymbol = o.get("splitsymbol");
            Object object = o.get("newlineidx");
            filterFields.add(mpField);
            fieldMapping.put(varName.toLowerCase(), mpField);
            if (object != null && (nlIndex = Integer.parseInt(object.toString())) > 0) {
                varNewlineIndex.put(varName.toLowerCase(), nlIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)separator)) {
                splitSymbolMapping.put(varName.toLowerCase(), separator);
                continue;
            }
            if (StringUtils.isNotBlank((Object)splitSymbol)) {
                splitSymbolMapping.put(varName.toLowerCase(), splitSymbol.toString());
                continue;
            }
            splitSymbolMapping.put(varName.toLowerCase(), "");
        }
        if (filterFields.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u53d8\u91cf\u6620\u5c04, \u8bf7\u914d\u7f6e\u540e\u518d\u6253\u5370\u3002", (String)"ScriptPrintService_2", (String)PACKAGE_NAME_KEY, (Object[])new Object[0])});
        }
        filterFields.add("id");
        Set<String> totalVars = Stream.concat(usedNormalVar.keySet().stream(), usedSummaryVar.keySet().stream()).collect(Collectors.toSet());
        Object plugin = mappingObj.get("scriptplugin");
        ScriptPrintServicePluginProxy proxy = this.getPluginProxy(plugin);
        QueryDataEventArgs args = new QueryDataEventArgs((Object)this, formId, billPkId, templatePkId, fieldMapping, totalVars);
        if (proxy != null) {
            proxy.fireDoQueryData(args);
        }
        List<Object> records = new ArrayList(10);
        if (args.getRecords() != null && !args.getRecords().isEmpty()) {
            records = args.getRecords();
            log.debug("\u811a\u672c\u6253\u5370\uff1a\u63d2\u4ef6\u63d0\u4f9b\u6570\u636e\uff0c \u63d2\u4ef6\u540d\u79f0-" + plugin + ", \u6570\u636e\u884c\u6570" + records.size());
        } else {
            log.debug("\u811a\u672c\u6253\u5370\uff1a\u5f00\u59cb\u67e5\u8be2\u6570\u636e\uff0c \u5355\u636e\u4e3b\u952e\uff1a" + billPkId);
            records = this.getRecords(formId, billPkId, fieldMapping, totalVars);
            log.debug("\u811a\u672c\u6253\u5370\uff1a\u67e5\u8be2\u5230" + records.size() + "\u6761\u6570\u636e");
        }
        for (Map map : records) {
            scripts.add(this.buildOnePrintScript(templatePkId, map));
        }
        return scripts;
    }

    private List<Map<String, Object>> getRecords(String formId, Object pk, Map<String, String> varMapping, Set<String> totalVars) {
        ArrayList<Map<String, Object>> recordResults = new ArrayList<Map<String, Object>>();
        HashSet<String> filterFields = new HashSet<String>(varMapping.values());
        String orderByStr = this.getOrderBy(formId, filterFields);
        String selectFields = filterFields.stream().collect(Collectors.joining(","));
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", pk)};
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"ScriptPrint.query", (String)formId, (String)selectFields, (QFilter[])qFilters, (String)orderByStr);){
            RowMeta meta = queryDataSet.getRowMeta();
            for (Row r : queryDataSet) {
                HashMap<String, Object> rowMp = new HashMap<String, Object>();
                for (String vr : totalVars) {
                    if (varMapping.containsKey(vr)) {
                        rowMp.put(vr, r.get(varMapping.get(vr)));
                        continue;
                    }
                    rowMp.put(vr, "");
                }
                recordResults.add(rowMp);
            }
        }
        return recordResults;
    }

    private String getOrderBy(String formId, Set<String> filterFields) {
        DynamicProperty seqProp;
        String orderByStr = "";
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        Map allEntities = dt.getAllEntities();
        EntityType curEntryTpye = null;
        for (String ff : filterFields) {
            String[] names;
            if (!ff.contains(".") || !allEntities.containsKey((names = ff.split("\\."))[0])) continue;
            curEntryTpye = (EntityType)allEntities.get(names[0]);
            break;
        }
        if (curEntryTpye != null && (seqProp = curEntryTpye.getProperty("seq")) != null) {
            String seqField = curEntryTpye.getName() + ".seq";
            orderByStr = seqField + " asc";
        }
        return orderByStr;
    }

    private String clearNormalLabelLine(String content) {
        String bLinePattern = "\\^B.*?\\^FS";
        String bVarPattern = "\\^FD\\!del\\!";
        String aLabel = this.removeLabelLine(content, bLinePattern, bVarPattern);
        String aLinePattern = "\\^A.*?\\^FS";
        String aVarPattern = "\\!del\\!";
        return this.removeLabelLine(aLabel, aLinePattern, aVarPattern);
    }

    private String clearTotalLabel(String content) {
        String linePattern = "\\^B.*?\\!del\\!.*?\\^FS";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(linePattern);
        Matcher m = p.matcher(content);
        while (m.find()) {
            String nv = m.group();
            String sep = this.getLastSeperater(nv);
            String tt = nv.replaceAll("\\!.*?(?=\\^FS)", "");
            if (StringUtils.isBlank((CharSequence)sep)) {
                StringBuilder tempSb = new StringBuilder(tt);
                int idx = tt.lastIndexOf(94) - 1;
                if (nv.contains("_0D") || nv.contains("_0d")) {
                    idx = tt.lastIndexOf(94) - 3;
                    tempSb.replace(idx, idx + 3, "");
                } else if (nv.contains("&")) {
                    idx = tt.lastIndexOf(94) - 2;
                    tempSb.replace(idx, idx + 2, "");
                } else {
                    tempSb.replace(idx, idx + 1, "");
                }
                tt = tempSb.toString();
            }
            m.appendReplacement(sb, tt);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String removeLabelLine(String content, String linePattern, String varPattern) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(linePattern);
        Matcher m = p.matcher(content);
        while (m.find()) {
            String nv = m.group();
            Pattern p2 = Pattern.compile(varPattern);
            Matcher m2 = p2.matcher(nv);
            if (!m2.find()) continue;
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String getLastSeperater(String nv) {
        String patternStr = "\\!(?=((?!\\!).)*$).?\\^FS";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher mm = pattern.matcher(nv);
        if (mm.find()) {
            String maValue = mm.group();
            maValue = maValue.replace("!", "");
            maValue = maValue.replace("^FS", "");
            return maValue;
        }
        return "";
    }

    private ScriptPrintServicePluginProxy getPluginProxy(Object value) {
        ScriptPrintServicePluginProxy proxy = null;
        if (StringUtils.isNotBlank((Object)value)) {
            List plugins = (List)SerializationUtils.fromJsonString((String)((String)value), List.class);
            proxy = new ScriptPrintServicePluginProxy(plugins);
        }
        return proxy;
    }
}

