/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class TemplateDesignerPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(TemplateDesignerPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isPrintModel() && !this.checkPrintTemplateCanSave()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"save"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5957\u6253\u6a21\u7248\u521b\u5efa\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"TemplateDesignerPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if ("save".equals(control.getKey()) && this.isPrintModel() && !this.checkPrintTemplateCanSave()) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5957\u6253\u6a21\u7248\u521b\u5efa\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"TemplateDesignerPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    private boolean isPrintModel() {
        try {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String id = (String)showParameter.getCustomParam("id");
            Map content = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
            if (content != null && content.get("modelType") != null) {
                return "PrintModel".equals(content.get("modelType").toString());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkPrintTemplateCanSave() {
        try {
            if (!ParamUtils.isTemplateOrgIsolated()) {
                return true;
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String tplId = (String)showParameter.getCustomParam("id");
            if (StringUtils.isNotBlank((CharSequence)tplId)) {
                String selectSql = "select fcreateorg,fctrlstrategy from t_bas_printtplinfo where fprinttplid =?";
                ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
                params.add(new SqlParameter("fprinttplid", 12, (Object)tplId));
                Map data = (Map)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                    public Map<String, Object> handle(ResultSet resultSet) throws Exception {
                        if (resultSet.next()) {
                            long createOrg = resultSet.getLong("fcreateorg");
                            String ctrlStrategy = resultSet.getString("fctrlstrategy");
                            HashMap<String, Object> result = new HashMap<String, Object>(4);
                            result.put("createOrg", createOrg);
                            result.put("ctrlStrategy", ctrlStrategy);
                            return result;
                        }
                        return Collections.emptyMap();
                    }
                });
                if (!data.isEmpty()) {
                    long currentUserOrg;
                    String ctrlStrategy = data.get("ctrlStrategy").toString();
                    if ("5".equals(ctrlStrategy)) {
                        return true;
                    }
                    Object org = data.get("createOrg");
                    if (org == null) {
                        return true;
                    }
                    long createOrg = Long.parseLong(org.toString());
                    return createOrg == (currentUserOrg = RequestContext.get().getOrgId());
                }
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }
}

