/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.FileStorageType;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.MetadataUtil;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.utils.PrintModelTypeUtil;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.print.service.provider.ClientScptServiceProvider;
import kd.bos.print.service.provider.PrintWorkExt;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.sdk.annotation.SdkService;

@SdkService(name="\u65b0\u6253\u5370\u670d\u52a1")
public class BosPrintServiceHelper {
    private static final String PROJECT_NAME = "bos-print-service";
    private static final String CONFIG_COMMON_SUFFIX = "_printsetting";
    private static final Log log = LogFactory.getLog(BosPrintServiceHelper.class);
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");

    public static PrtAttach getPrtAttach(String taskId) {
        return AttachmentServiceProvider.getProvider().getPrtAttach(taskId);
    }

    public static PrtAttach getPrtAttach(String taskId, String expType) {
        if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(expType)) {
            Map scptMap = distributeCache.getAll(ClientScptServiceProvider.getTaskKey(taskId));
            PrtAttach prtAttach = new PrtAttach();
            prtAttach.setTaskId(taskId);
            prtAttach.setExtType(expType);
            prtAttach.setDiskType(FileStorageType.TEMP_FILE.getCode());
            for (Map.Entry entry : scptMap.entrySet()) {
                PrtAttach.AttachDetail detail = new PrtAttach.AttachDetail();
                detail.setSeq(Integer.parseInt((String)entry.getKey()));
                detail.setAttachId(taskId + "_" + detail.getSeq());
                detail.setFilePath((String)entry.getValue());
                detail.setSource("B");
                prtAttach.addAttachDetail(detail);
            }
            return prtAttach;
        }
        return AttachmentServiceProvider.getProvider().getPrtAttach(taskId);
    }

    public static String getTplIdByNum(String tplNum) {
        String sql = "select fid from t_svc_printmeta where fnumber=?";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("fnumber", 12, (Object)tplNum)};
        String tplId = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParams, dSet -> {
            if (dSet.next()) {
                return dSet.getString("fid");
            }
            return null;
        });
        return tplId;
    }

    public static Map<String, String> getTplIdByNum(List<String> tplNums) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fnumber from t_svc_printmeta where", new Object[0]);
        sqlBuilder.appendIn("fnumber", tplNums.toArray());
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, dSet -> {
            HashMap<String, String> tplMap = new HashMap<String, String>(tplNums.size());
            while (dSet.next()) {
                tplMap.put(dSet.getString("fnumber"), dSet.getString("fid"));
            }
            return tplMap;
        });
        return result;
    }

    public static Map<String, TplInfo> getTplByNum(List<String> tplNums) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fnumber,ftype from t_svc_printmeta where", new Object[0]);
        sqlBuilder.appendIn("fnumber", tplNums.toArray());
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, dSet -> {
            HashMap<String, TplInfo> tplMap = new HashMap<String, TplInfo>(tplNums.size());
            while (dSet.next()) {
                String tplId = dSet.getString("fid");
                String tplNum = dSet.getString("fnumber");
                String tplType = dSet.getString("ftype");
                tplMap.put(tplNum, new TplInfo(tplId, tplNum, tplType));
            }
            return tplMap;
        });
        return result;
    }

    public static Boolean isNewTpl(String tplNum) {
        Map<String, TplInfo> tplByNum = BosPrintServiceHelper.getTplByNum(Collections.singletonList(tplNum));
        if (tplByNum == null || tplByNum.isEmpty()) {
            return null;
        }
        TplInfo tplInfo = tplByNum.get(tplNum);
        if ("B".equals(tplInfo.getTplType())) {
            return true;
        }
        return false;
    }

    public static PrtAttach execPrint(PrintWork work) {
        work.setFileStorageType(FileStorageType.TEMP_FILE);
        if (PrintWork.EXP_TYPE.EXP_CLIENT.getCode().equals(work.getExpType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u652f\u6301\u901a\u8fc7\u5ba2\u6237\u7aef\u8fdb\u884c\u6253\u5370\u3002", (String)"BosPrintServiceHelper_2", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        return BosPrintServiceHelper.runPrint(work);
    }

    @Deprecated
    public static PrtAttach doPrint(PrintWork work) {
        FileStorageType fileStorageType = work.getFileStorageType();
        if (fileStorageType == null) {
            log.warn("\u8be5\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u518d\u7ef4\u62a4\uff0c\u8bf7\u6539\u8c03\u7528execPrint\u65b9\u6cd5\u3002");
            work.setFileStorageType(FileStorageType.ATTACHMENT_FILE);
        }
        if (PrintWork.EXP_TYPE.EXP_CLIENT.getCode().equals(work.getExpType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u652f\u6301\u901a\u8fc7\u5ba2\u6237\u7aef\u8fdb\u884c\u6253\u5370\u3002", (String)"BosPrintServiceHelper_2", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        return BosPrintServiceHelper.runPrint(work);
    }

    private static PrtAttach runPrint(PrintWork work) {
        String printLang = work.getPrintLang();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)printLang)) {
            printLang = Lang.zh_CN.toString();
        }
        List printTasks = work.getTaskList();
        for (PrintTask task : printTasks) {
            if (task.getMetadata() == null) {
                PrintMetadata metadata = MetadataUtil.getMetadata((String)task.getTplId(), (String)printLang);
                if (metadata == null) {
                    throw new PrintException("4", ResManager.loadKDString((String)"\u6a21\u7248\u4e0d\u5b58\u5728\u3002", (String)"BosPrintServiceHelper_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                }
                task.setMetadata(metadata);
            }
            String formId = task.getMetadata().getFormId();
            task.setFormId(formId);
            if (!StringUtils.isEmpty((CharSequence)task.getPageId())) continue;
            task.setPageId(work.getPageId());
        }
        BosPrintServiceHelper.fillModelType(work);
        try {
            String appId = "svc-print";
            if (!AclAdapter.getAclServiceLookup().hasDeployedAppId(appId)) {
                String formId = ((PrintTask)printTasks.get(0)).getFormId();
                appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
                if (StringUtils.isBlank((CharSequence)appId)) {
                    appId = "bos";
                }
            }
            String taskId = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintService", (String)"doPrint", (Object[])new Object[]{null, work});
            return BosPrintServiceHelper.getPrtAttach(taskId, work.getExpType());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    public static InputStream getFileInputStream(String filePath, String diskType) {
        return PrintFileUtil.getFileInputStream((String)filePath, (String)diskType);
    }

    public static InputStream getFileInputStream(String filePath) {
        return PrintFileUtil.getFileInputStream((String)filePath, (String)FileStorageType.TEMP_FILE.getCode());
    }

    static void fillModelType(PrintWork work) {
        List taskList = work.getTaskList();
        List formIds = taskList.stream().map(item -> item.getFormId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(formIds)) {
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Print.QueryModelType", (String)"bos_formmeta", (String)"number,modeltype", (QFilter[])new QFilter[]{new QFilter("number", "in", formIds)}, null);){
            HashMap<String, String> modelTypeMap = new HashMap<String, String>(taskList.size());
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String modelType = row.getString("modeltype");
                modelType = PrintModelTypeUtil.bosModelType2Print((String)modelType);
                modelTypeMap.put(row.getString("number"), modelType);
            }
            for (PrintTask task : taskList) {
                task.setPrintType(modelTypeMap.getOrDefault(task.getFormId(), "dynamic"));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static PrtAttach doPrintDirect(String printerId, PrintWork printWork) {
        printWork.setFileStorageType(FileStorageType.TEMP_FILE);
        LicenseCheckResult licenseCheckResult = PrintClientUtil.checkCloudPrintLicense();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            throw new KDBizException(licenseCheckResult.getMsg());
        }
        printWork.setPrinterId(printerId);
        PrintWorkExt work = BosPrintServiceHelper.handPrintWork(printWork);
        PrtAttach prtAttach = BosPrintServiceHelper.runPrint(work);
        if (PrintWork.EXP_TYPE.EXP_CLIENT.getCode().equals(work.getExpType())) {
            return prtAttach;
        }
        String printerAddress = work.getPrinterName();
        String serviceN = work.getServiceN();
        List attachDetails = prtAttach.getAttachDetail();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(attachDetails.size());
        ORM orm = ORM.create();
        for (PrtAttach.AttachDetail detail : attachDetails) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_printtask");
            Date date = new Date();
            dynamicObject.set("id", (Object)orm.genLongId("bos_printtask"));
            dynamicObject.set("name", (Object)detail.getFileName());
            dynamicObject.set("number", (Object)UUID.randomUUID());
            dynamicObject.set("accountid", (Object)String.valueOf(RequestContext.get().getAccountId()));
            dynamicObject.set("serviceId", (Object)Long.parseLong(serviceN));
            dynamicObject.set("bsdprinter", (Object)work.getPrinterId());
            dynamicObject.set("printeraddress", (Object)printerAddress);
            dynamicObject.set("configkey", (Object)" ");
            dynamicObject.set("cacheid", (Object)" ");
            dynamicObject.set("printstatus", (Object)Character.valueOf('1'));
            dynamicObject.set("filepath", (Object)detail.getFilePath());
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("enable", (Object)Character.valueOf('1'));
            dynamicObject.set("printtype", (Object)"pdf");
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject.set("createtimestamp", (Object)System.currentTimeMillis());
            dynamicObjects.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        String key = "PrintServiceId:" + serviceN;
        if (distributeCache.get(key) != "true") {
            distributeCache.put(key, (Object)"true", 7200);
        }
        return prtAttach;
    }

    public static Long getPrinterId(Long userId, String formId) {
        if (null == userId || null == formId) {
            return null;
        }
        Object printerId = BosPrintServiceHelper.getCusConfig(userId, formId, "printerid");
        if (null != printerId) {
            return Long.valueOf(printerId.toString());
        }
        return null;
    }

    public static String getPrintLang(Long userId, String formId) {
        if (null == userId || null == formId) {
            return null;
        }
        Object printerLan = BosPrintServiceHelper.getCusConfig(userId, formId, "printlang");
        if (null != printerLan) {
            return String.valueOf(printerLan);
        }
        return null;
    }

    private static Object getCusConfig(Long userId, String formId, String type) {
        Map jsonData;
        if (null == userId || null == formId) {
            return null;
        }
        String key = formId + CONFIG_COMMON_SUFFIX;
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData) && !CollectionUtils.isEmpty((Map)(jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class)))) {
            return jsonData.get(type);
        }
        return null;
    }

    private static PrintWorkExt handPrintWork(PrintWork printWork) {
        String printerId = printWork.getPrinterId();
        if (printerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5printerId\u3002", (String)"BosPrintServiceHelper_1", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        PrintClientUtil.CloudPrinter cloudPrint = PrintClientUtil.getCloudPrinter(Long.parseLong(printerId));
        if (cloudPrint == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5printerId\u3002", (String)"BosPrintServiceHelper_1", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        String serviceN = cloudPrint.getServiceN();
        long serviceId = cloudPrint.getServiceId();
        String serviceType = cloudPrint.getServiceType();
        String printerName = cloudPrint.getPrinterName();
        boolean isNewPrinter = "B".equals(serviceType);
        PrintClientUtil.PrinterStatus printerStatus = PrintClientUtil.printerStatus(cloudPrint.getServiceN(), cloudPrint.getPrinterName(), cloudPrint.getServiceType());
        if (printerStatus == PrintClientUtil.PrinterStatus.offline) {
            throw new PrintException("5", ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\u3002", (String)"ClientPreview_3", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        if (printerStatus == PrintClientUtil.PrinterStatus.busy) {
            throw new PrintException("5", ResManager.loadKDString((String)"\u5f53\u524d\u6253\u5370\u673a\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ClientPreview_9", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        PrintWorkExt workProxy = new PrintWorkExt(printWork);
        workProxy.setPrinterName(printerName);
        if (isNewPrinter) {
            workProxy.setExpType(PrintWork.EXP_TYPE.EXP_CLIENT.getCode());
            workProxy.setServiceN(serviceN);
        } else {
            workProxy.setServiceN(String.valueOf(serviceId));
            if (PrintWork.EXP_TYPE.EXP_CLIENT.getCode().equals(printWork.getExpType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u6253\u5370\u673a\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u65b0\u5ba2\u6237\u7aef\u8fdb\u884c\u6253\u5370\u3002", (String)"BosPrintServiceHelper_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
        }
        return workProxy;
    }

    public static class TplInfo {
        private String tplId;
        private String tplKey;
        private String tplType;

        public TplInfo(String tplId, String tplKey, String tplType) {
            this.tplId = tplId;
            this.tplKey = tplKey;
            this.tplType = tplType;
        }

        public String getTplId() {
            return this.tplId;
        }

        public void setTplId(String tplId) {
            this.tplId = tplId;
        }

        public String getTplKey() {
            return this.tplKey;
        }

        public void setTplKey(String tplKey) {
            this.tplKey = tplKey;
        }

        public String getTplType() {
            return this.tplType;
        }

        public void setTplType(String tplType) {
            this.tplType = tplType;
        }
    }
}

