/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.datasource.FormDataSource;

public class AttachDataProvider {
    public static Map<String, Map<String, List<String>>> getAttachPanelObjs(FormDataSource dataSource, List<String> ids, Set<String> attachKeys) {
        Map map;
        String formId = dataSource.getFormId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        HashMap<String, AttachmentPanelAp> attachmentPanelAps = new HashMap<String, AttachmentPanelAp>();
        for (ControlAp element : formMetadata.getItems()) {
            if (!(element instanceof AttachmentPanelAp)) continue;
            attachmentPanelAps.put(element.getKey(), (AttachmentPanelAp)element);
        }
        QFilter[] attachFilters = new QFilter[]{new QFilter("FBillType", "=", (Object)formId), new QFilter("FInterID", "in", ids), new QFilter("fattachmentpanel", "in", attachKeys)};
        HashMap dataMap = new HashMap(16);
        ORM orm = ORM.create();
        DynamicObjectCollection datas = orm.query("bos_attachment", "id,finterid,fattachmentpanel,fattachmentname,fcreatetime,fattachmentsize,dragseq", attachFilters);
        for (DynamicObject data : datas) {
            String interId = data.getString("finterid");
            String attachPanel = data.getString("fattachmentpanel");
            if (dataMap.containsKey(interId)) {
                map = (Map)dataMap.get(interId);
                if (!map.containsKey(attachPanel)) {
                    map.put(attachPanel, new ArrayList());
                }
                ((List)map.get(attachPanel)).add(data);
                dataMap.put(interId, map);
                continue;
            }
            map = new HashMap();
            map.put(attachPanel, new ArrayList());
            ((List)map.get(attachPanel)).add(data);
            dataMap.put(interId, map);
        }
        HashMap<String, Map<String, List<String>>> dataMapAfterSort = new HashMap<String, Map<String, List<String>>>(16);
        for (Map.Entry it : dataMap.entrySet()) {
            String interId = (String)it.getKey();
            map = (Map)it.getValue();
            HashMap newMap = new HashMap(16);
            for (String attachKey : attachKeys) {
                if (!map.containsKey(attachKey)) continue;
                List attactments = (List)map.get(attachKey);
                AttachmentPanelAp attach = (AttachmentPanelAp)attachmentPanelAps.get(attachKey);
                final String sortField = attach.getSortField();
                final String sortType = attach.getSortType();
                final boolean dragAtm = attach.getDragAtm();
                Collections.sort(attactments, new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        Comparable<Date> sortField2;
                        Comparable<Date> sortField1;
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        if (dragAtm) {
                            int sortField12 = o1.getInt("dragseq");
                            int sortField22 = o2.getInt("dragseq");
                            return Integer.compare(sortField12, sortField22);
                        }
                        if ("fileName".equals(sortField)) {
                            Collator collator = Collator.getInstance(Locale.CHINA);
                            String sortField13 = o1.getString("fattachmentname");
                            String sortField23 = o2.getString("fattachmentname");
                            if (sortField13 != null && sortField23 != null) {
                                if ("ASC".equals(sortType)) {
                                    return collator.compare(sortField13, sortField23);
                                }
                                return collator.compare(sortField23, sortField13);
                            }
                        }
                        if ("uploadTime".equals(sortField)) {
                            sortField1 = o1.getDate("fcreatetime");
                            sortField2 = o2.getDate("fcreatetime");
                            if (sortField1 != null && sortField2 != null) {
                                if ("ASC".equals(sortType)) {
                                    return ((Date)sortField1).compareTo((Date)sortField2);
                                }
                                return ((Date)sortField2).compareTo((Date)sortField1);
                            }
                        }
                        if ("fileSize".equals(sortField)) {
                            sortField1 = o1.getBigDecimal("fattachmentsize");
                            sortField2 = o2.getBigDecimal("fattachmentsize");
                            if (sortField1 != null && sortField2 != null) {
                                if ("ASC".equals(sortType)) {
                                    return ((BigDecimal)sortField1).compareTo((BigDecimal)sortField2);
                                }
                                return ((BigDecimal)sortField2).compareTo((BigDecimal)sortField1);
                            }
                        }
                        return 0;
                    }
                });
                for (DynamicObject dynamicObject : attactments) {
                    if (!newMap.containsKey(attachKey)) {
                        newMap.put(attachKey, new ArrayList());
                        ((List)newMap.get(attachKey)).add(dynamicObject.getString("fattachmentname"));
                        continue;
                    }
                    ((List)newMap.get(attachKey)).add(dynamicObject.getString("fattachmentname"));
                }
            }
            dataMapAfterSort.put(interId, newMap);
        }
        return dataMapAfterSort;
    }
}

