/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.service.provider.AttachmentServiceProvider;

public abstract class BaseDataProvider
implements IPrintDataProvider {
    private Log log = LogFactory.getLog(BaseDataProvider.class);
    private MainEntityType mainEntityType;
    private PrintPluginProxy proxy;
    private Long inteFormatId;
    protected static final String PRINTRESOURCE_TABLENAME = "t_svc_printresource";

    public MainEntityType getMainEntityType() {
        return this.mainEntityType;
    }

    public void setMainEntityType(MainEntityType mainEntityType) {
        this.mainEntityType = mainEntityType;
    }

    public MainEntityType getMainEntityType(String number) {
        List allPrtDataSourceFacades = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (allPrtDataSourceFacades != null && !allPrtDataSourceFacades.isEmpty()) {
            return ((IPrtDataSourceFacade)allPrtDataSourceFacades.get(0)).getDataEntityType(number);
        }
        return EntityMetadataCache.getDataEntityType((String)number);
    }

    public void setInteFormatId(Long inteFormatId) {
        this.inteFormatId = inteFormatId;
    }

    public Long getInteFormatId() {
        return this.inteFormatId;
    }

    public byte[] getImageByte(String imageKey) {
        return AttachmentServiceProvider.getProvider().getImage(imageKey);
    }

    public void setPluginProxy(PrintPluginProxy proxy) {
        this.proxy = proxy;
    }

    public PrintPluginProxy getPluginProxy() {
        return this.proxy;
    }

    protected String getDsName(IDataEntityProperty property) {
        StringBuilder builder = new StringBuilder();
        this.getDsName(property.getParent(), builder);
        return builder.toString();
    }

    private void getDsName(IDataEntityType parent, StringBuilder builder) {
        if (parent == null) {
            return;
        }
        if (builder.length() == 0) {
            builder.append(parent.getName());
        } else {
            builder.insert(0, ".").insert(0, parent.getName());
        }
        this.getDsName(parent.getParent(), builder);
    }

    public List getData(PrtDataSource dataSource) {
        PrintPluginProxy pluginProxy = this.getPluginProxy();
        if (pluginProxy != null) {
            BeforeLoadDataEvent evt = new BeforeLoadDataEvent(dataSource, new ArrayList(0));
            pluginProxy.fireBeforeLoadData(evt);
            if (evt.isCancleLoadData()) {
                return evt.getDataRowSets();
            }
        }
        List rowSetList = this.queryDateRowSets(dataSource);
        if (pluginProxy != null) {
            AfterLoadDataEvent evt = new AfterLoadDataEvent(dataSource, rowSetList);
            pluginProxy.fireAfterLoadData(evt);
            rowSetList = evt.getDataRowSets();
        }
        return rowSetList;
    }

    protected List<DataRowSet> queryDateRowSets(PrtDataSource dataSource) {
        return new ArrayList<DataRowSet>(0);
    }
}

