/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.RefDataSource;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.importer.impl.R1PDataGrid_D2W;
import kd.bos.print.service.dataprovider.AttachDataProvider;
import kd.bos.print.service.dataprovider.BaseDataProvider;
import kd.bos.print.service.dataprovider.CustomDataProvider;
import kd.bos.print.service.dataprovider.WorkflowDataProvider;
import kd.bos.print.service.dataprovider.utils.DataRowSetHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.acl.AclAdapter;

public class PrintDataProvider
extends BaseDataProvider {
    private Log log = LogFactory.getLog(PrintDataProvider.class);
    private DataRowSetHelper dataHelper = new DataRowSetHelper();
    private int refQueryCount = ConfigConstUtil.getRefQueryCount();

    @Override
    protected List<DataRowSet> queryDateRowSets(PrtDataSource dataSource) {
        DsType dsType = dataSource.getDsType();
        if (dsType == DsType.MAIN || dsType == DsType.REF) {
            FormDataSource formDataSource = (FormDataSource)dataSource;
            MainEntityType mainEntityType = formDataSource.getMainEntityType();
            if (mainEntityType instanceof BillEntityType || mainEntityType instanceof BasedataEntityType) {
                return this.queryData(formDataSource);
            }
        } else {
            if (dsType == DsType.CUSTOM) {
                CustomDataProvider dataProvider = new CustomDataProvider();
                dataProvider.setPluginProxy(this.getPluginProxy());
                return dataProvider.getData(dataSource);
            }
            if (dsType == DsType.APPROVELINE) {
                return WorkflowDataProvider.getWorkflowApproveLine((WorkflowDataSource)dataSource);
            }
            if (dsType == DsType.APPROVEACTIVITY) {
                return WorkflowDataProvider.getWorkflowApproveActivity((WorkflowDataSource)dataSource);
            }
        }
        return Collections.emptyList();
    }

    private EntityType getEntityType(String dsName) {
        Map allEntities = this.getMainEntityType().getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    private List<DataRowSet> queryData(FormDataSource dataSource) {
        MainEntityType mainEntityType = dataSource.getMainEntityType();
        this.setMainEntityType(mainEntityType);
        this.dataHelper.init(mainEntityType);
        List queryField = dataSource.getQueryField();
        HashSet<String> querySetField = new HashSet<String>();
        querySetField.addAll(queryField);
        querySetField.add("id");
        List childrenDs = dataSource.getChildrenDs();
        HashSet<String> attachKeys = new HashSet<String>(16);
        for (PrtDataSource childDs : childrenDs) {
            if (DsType.ATTACH == childDs.getDsType()) {
                attachKeys.addAll(childDs.getQueryField());
                continue;
            }
            EntityType entityType = this.getEntityType(childDs.getDsName());
            if (!(entityType instanceof EntryType)) continue;
            List entryField = childDs.getQueryField();
            entryField.remove("id");
            entryField.remove("seq");
            querySetField.addAll(entryField);
            querySetField.add(entityType.getName() + ".id");
            entryField.add("id");
            if (entityType.getProperty("seq") == null) continue;
            querySetField.add(entityType.getName() + ".seq");
            entryField.add("seq");
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = dataSource.getQFilter();
        if (qFilter == null) {
            return Collections.EMPTY_LIST;
        }
        qFilters.add(qFilter);
        FilterCondition filterCondition = dataSource.getFilterCondition();
        if (filterCondition != null) {
            FilterBuilder filterBuilder = new FilterBuilder(this.getMainEntityType(), filterCondition, true);
            filterBuilder.buildFilter(true);
            QFilter filter = filterBuilder.getQFilter();
            if (filter != null) {
                qFilters.add(filter);
            }
        }
        QFilter[] filters = qFilters.toArray(new QFilter[0]);
        StringBuilder orderBy = new StringBuilder();
        if (dataSource instanceof RefDataSource) {
            ORM orm = ORM.create();
            int count = orm.count("printQueryData", this.getMainEntityType().getName(), filters);
            if (count > this.refQueryCount) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u5df2\u8d85\u8fc7%s\u6761\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5173\u8054\u6761\u4ef6\u3002", (String)"PrintDataProvider_0", (String)"bos-print-service", (Object[])new Object[0]), this.refQueryCount));
            }
            String idName = this.getMainEntityType().getPrimaryKey().getName();
            orderBy.append(idName).append(" desc");
        }
        Set<String> searchKeys = this.extendFields(querySetField, this.getMainEntityType(), dataSource);
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)this.getMainEntityType().getName(), (String)searchKeys.stream().collect(Collectors.joining(",")), (QFilter[])filters, (String)orderBy.toString());
        List<String> ids = dyMap.entrySet().stream().map(item -> String.valueOf(item.getKey())).collect(Collectors.toList());
        Map<Object, Object> dataMap = new HashMap();
        if (!attachKeys.isEmpty()) {
            dataMap = AttachDataProvider.getAttachPanelObjs(dataSource, ids, attachKeys);
        }
        ArrayList<DataRowSet> rowSetList = new ArrayList<DataRowSet>(dyMap.size());
        for (DynamicObject obj : dyMap.values()) {
            String pk;
            Map data;
            DataRowSet rowSet = this.dataHelper.toDataRowSet(obj, dataSource);
            if (!dataMap.isEmpty() && (data = (Map)dataMap.get(pk = String.valueOf(obj.getPkValue()))) != null && !data.isEmpty()) {
                for (String attachKey : attachKeys) {
                    if (!data.containsKey(attachKey)) continue;
                    String attachName = StringUtils.join((Object[])((List)data.get(attachKey)).toArray(), (String)"\n");
                    rowSet.put(attachKey, (Field)new TextField(attachName));
                }
            }
            rowSetList.add(rowSet);
        }
        if (dataSource instanceof MainDataSource) {
            this.sortRowSet(rowSetList, ((MainDataSource)dataSource).getSortPKIds());
        }
        this.mergePrint(dataSource, rowSetList);
        return rowSetList;
    }

    private void mergePrint(FormDataSource dataSource, List<DataRowSet> rowSetList) {
        Set dsSet = ExecuteContext.get().getHasMergePrintDsMap().getOrDefault(ExecuteContext.get().getTplKey(), new HashSet(0));
        if (dsSet.isEmpty()) {
            return;
        }
        if (rowSetList.size() == 0) {
            return;
        }
        if (!(dataSource instanceof MainDataSource)) {
            return;
        }
        List queryField = dataSource.getQueryField();
        HashSet<String> querySetField = new HashSet<String>();
        querySetField.addAll(queryField);
        DataRowSet dataRowSet = rowSetList.get(0);
        List childrenDs = dataSource.getChildrenDs();
        for (int i = 0; i < rowSetList.size(); ++i) {
            DataRowSet mergeData = rowSetList.get(i);
            for (PrtDataSource childDs : childrenDs) {
                String dsName = childDs.getDsName();
                EntityType entityType = this.getEntityType(dsName);
                if (entityType == null || DsType.ATTACH == childDs.getDsType() || !childDs.isMergePrint()) continue;
                if (entityType instanceof SubEntryType) {
                    this.mergeHeadFieldToSubEntry(querySetField, mergeData, entityType);
                    continue;
                }
                CollectionField collectionField = dataRowSet.getCollectionField(entityType.getName());
                List mergeValue = mergeData.getCollectionField(entityType.getName()).getValue();
                for (DataRowSet rowSet : mergeValue) {
                    for (String headField : querySetField) {
                        rowSet.put(R1PDataGrid_D2W.getMergeHeadField((String)headField), mergeData.getField(headField));
                    }
                }
                if (i == 0) continue;
                List value = collectionField.getValue();
                value.addAll(mergeValue);
            }
        }
        rowSetList.clear();
        rowSetList.add(dataRowSet);
    }

    private void mergeHeadFieldToSubEntry(Set<String> querySetField, DataRowSet mergeData, EntityType entityType) {
        String name = entityType.getParent().getName();
        CollectionField entry = mergeData.getCollectionField(name);
        List entryValue = entry.getValue();
        if (CollectionUtils.isEmpty((Collection)entryValue)) {
            return;
        }
        for (int j = 0; j < entryValue.size(); ++j) {
            DataRowSet rowSet = (DataRowSet)entryValue.get(j);
            CollectionField subEntry = rowSet.getCollectionField(entityType.getName());
            List subEntryValue = subEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)subEntryValue)) continue;
            for (DataRowSet subRow : subEntryValue) {
                for (String headField : querySetField) {
                    subRow.put(R1PDataGrid_D2W.getMergeHeadField((String)headField), mergeData.getField(headField));
                }
            }
        }
    }

    private Set<String> extendFields(Set<String> usedFields, MainEntityType mainEntityType, FormDataSource dataSource) {
        String versionControlField;
        HashMap<String, Object> dsMap = new HashMap<String, Object>(4);
        for (PrtDataSource ds : dataSource.getChildrenDs()) {
            dsMap.put(ds.getDsName(), ds);
        }
        dsMap.put(dataSource.getDsName(), dataSource);
        Iterator<String> it = usedFields.iterator();
        ArrayList<String> controlFields = new ArrayList<String>(10);
        Set<Object> itemClassFields = new HashSet(16);
        HashSet<String> flexRefBaseDataSet = new HashSet<String>(16);
        Map allFields = mainEntityType.getAllFields();
        while (it.hasNext()) {
            String dsName;
            PrtDataSource prtDataSource;
            DateTimeProp dateTimeProp;
            String relateOrg;
            String fieldKey = it.next();
            String[] fieldKeyArr = fieldKey.split("\\.");
            String usedKey = fieldKeyArr[0];
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(usedKey);
            if (property instanceof DecimalProp) {
                DecimalProp decimalProp = (DecimalProp)property;
                String controlPropName = decimalProp.getControlPropName();
                if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                    controlFields.add(controlPropName);
                }
            } else if (property instanceof ItemClassProp) {
                String typePropName = ((ItemClassProp)property).getTypePropName();
                controlFields.add(typePropName);
                itemClassFields = this.getItemClassNameAndNumberField(allFields, property, typePropName);
            } else if (property instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(relateOrg = (dateTimeProp = (DateTimeProp)property).getRelateOrg()))) {
                controlFields.add(relateOrg);
            }
            if (property instanceof BasedataProp && (prtDataSource = (PrtDataSource)dsMap.get(dsName = this.getDsName(property))) != null) {
                prtDataSource.getQueryField().add(property.getName() + ".id");
            }
            if (!(property instanceof FlexProp)) continue;
            FlexProp flexProp = (FlexProp)property;
            String basePropertyKey = flexProp.getBasePropertyKey();
            flexRefBaseDataSet.add(basePropertyKey);
        }
        usedFields.addAll(controlFields);
        String mainOrg = mainEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
            usedFields.add(mainOrg);
        }
        if (StringUtils.isNotBlank((CharSequence)(versionControlField = AclAdapter.getBasedataVersionService().getVersionControl(mainEntityType)))) {
            usedFields.add(versionControlField);
        }
        usedFields.addAll(flexRefBaseDataSet);
        HashSet<String> returnFields = new HashSet<String>(16);
        returnFields.addAll(usedFields);
        returnFields.addAll(itemClassFields);
        return returnFields;
    }

    private Set<String> getItemClassNameAndNumberField(Map<String, IDataEntityProperty> allFields, IDataEntityProperty property, String typePropName) {
        HashSet<String> itemClassFields = new HashSet<String>(16);
        IDataEntityProperty itemclassType = allFields.get(typePropName);
        if (itemclassType instanceof ItemClassTypeProp) {
            ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)itemclassType;
            Map itemTypes = itemClassTypeProp.getItemTypes();
            for (DynamicObjectType dynamicObjectType : itemTypes.values()) {
                String numberProperty;
                if (!(dynamicObjectType instanceof BasedataEntityType)) continue;
                BasedataEntityType refEntityType = (BasedataEntityType)dynamicObjectType;
                String nameProperty = refEntityType.getNameProperty();
                if (StringUtils.isNotBlank((CharSequence)nameProperty)) {
                    itemClassFields.add(property.getName() + "." + nameProperty);
                }
                if (!StringUtils.isNotBlank((CharSequence)(numberProperty = refEntityType.getNumberProperty()))) continue;
                itemClassFields.add(property.getName() + "." + numberProperty);
            }
        }
        return itemClassFields;
    }

    private void sortRowSet(List<DataRowSet> rowSetList, final List<Object> sortPKIds) {
        Collections.sort(rowSetList, new Comparator<DataRowSet>(){

            @Override
            public int compare(DataRowSet o1, DataRowSet o2) {
                Field fieldOne = o1.getField("id");
                Object valueOne = fieldOne.getValue();
                Field fieldTwo = o2.getField("id");
                Object valueTwo = fieldTwo.getValue();
                int io1 = sortPKIds.indexOf(valueOne);
                int io2 = sortPKIds.indexOf(valueTwo);
                return io1 - io2;
            }
        });
    }
}

