/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.service.dataprovider.AttachDataProvider;
import kd.bos.print.service.dataprovider.BaseDataProvider;
import kd.bos.print.service.dataprovider.CustomDataProvider;
import kd.bos.print.service.dataprovider.PrintDataHelper;
import kd.bos.print.service.dataprovider.WorkflowDataProvider;

public class QueryDataProvider
extends BaseDataProvider {
    private PrintDataHelper dataHelper = new PrintDataHelper();

    @Override
    public List<DataRowSet> getData(PrtDataSource dataSource) {
        DsType dsType;
        List<Object> rowSetList = Collections.EMPTY_LIST;
        PrintPluginProxy pluginProxy = this.getPluginProxy();
        if (pluginProxy != null) {
            BeforeLoadDataEvent evt = new BeforeLoadDataEvent(dataSource, (List)rowSetList);
            pluginProxy.fireBeforeLoadData(evt);
            if (evt.isCancleLoadData()) {
                return evt.getDataRowSets();
            }
        }
        if ((dsType = dataSource.getDsType()) == DsType.MAIN || dsType == DsType.REF) {
            FormDataSource formDataSource = (FormDataSource)dataSource;
            MainEntityType mainEntityType = formDataSource.getMainEntityType();
            rowSetList = mainEntityType instanceof BillEntityType || mainEntityType instanceof BasedataEntityType ? this.queryData(formDataSource) : Collections.EMPTY_LIST;
        } else if (dsType == DsType.CUSTOM) {
            CustomDataProvider dataProvider = new CustomDataProvider();
            dataProvider.setPluginProxy(this.getPluginProxy());
            rowSetList = dataProvider.getData(dataSource);
        } else if (dsType == DsType.APPROVELINE) {
            rowSetList = WorkflowDataProvider.getWorkflowApproveLine((WorkflowDataSource)dataSource);
        } else if (dsType == DsType.APPROVEACTIVITY) {
            rowSetList = WorkflowDataProvider.getWorkflowApproveActivity((WorkflowDataSource)dataSource);
        }
        if (pluginProxy != null) {
            AfterLoadDataEvent evt = new AfterLoadDataEvent(dataSource, rowSetList);
            pluginProxy.fireAfterLoadData(evt);
            rowSetList = evt.getDataRowSets();
        }
        return rowSetList;
    }

    private EntityType getEntityType(String dsName) {
        Map allEntities = this.getMainEntityType().getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    private List<DataRowSet> queryData(FormDataSource dataSource) {
        MainEntityType mainEntityType = dataSource.getMainEntityType();
        this.setMainEntityType(mainEntityType);
        if (!(mainEntityType instanceof BillEntityType) && !(mainEntityType instanceof BasedataEntityType)) {
            return Collections.EMPTY_LIST;
        }
        this.dataHelper.init(mainEntityType);
        String formId = dataSource.getFormId();
        HashSet<String> useFields = new HashSet<String>();
        List queryField = dataSource.getQueryField();
        queryField.add("id");
        Set<String> useFieldSets = PrintDataHelper.extendFields(new HashSet<String>(queryField), this.getMainEntityType(), (EntityType)this.getMainEntityType());
        useFields.addAll(useFieldSets);
        ArrayList<String> sortList = new ArrayList<String>();
        sortList.add("id desc");
        List childrenDs = dataSource.getChildrenDs();
        HashSet<String> attachKeys = new HashSet<String>(16);
        for (PrtDataSource childDs : childrenDs) {
            if (DsType.ATTACH == childDs.getDsType()) {
                attachKeys.addAll(childDs.getQueryField());
                continue;
            }
            EntityType entityType = this.getEntityType(childDs.getDsName());
            if (!(entityType instanceof EntryType)) continue;
            queryField = childDs.getQueryField();
            queryField.add("id");
            if (entityType.getProperty("seq") != null) {
                queryField.add("seq");
            }
            useFieldSets = PrintDataHelper.extendFields(new HashSet<String>(queryField), this.getMainEntityType(), entityType);
            useFields.addAll(useFieldSets);
        }
        ORM orm = ORM.create();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = dataSource.getQFilter();
        if (qFilter == null) {
            return Collections.EMPTY_LIST;
        }
        qFilters.add(qFilter);
        FilterCondition filterCondition = dataSource.getFilterCondition();
        if (filterCondition != null) {
            FilterBuilder filterBuilder = new FilterBuilder(this.getMainEntityType(), filterCondition, true);
            filterBuilder.buildFilter(true);
            QFilter filter = filterBuilder.getQFilter();
            if (filter != null) {
                qFilters.add(filter);
            }
        }
        QFilter[] filters = qFilters.toArray(new QFilter[0]);
        DynamicObjectCollection datas = orm.query(formId, useFields.stream().collect(Collectors.joining(",")), filters, StringUtils.join((Object[])sortList.toArray(), (String)","), 500);
        if (datas == null || datas.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<String> ids = datas.stream().map(item -> String.valueOf(item.getPkValue())).collect(Collectors.toList());
        Map<Object, Object> dataMap = new HashMap();
        if (!attachKeys.isEmpty()) {
            dataMap = AttachDataProvider.getAttachPanelObjs(dataSource, ids, attachKeys);
        }
        ArrayList<DataRowSet> rowSetList = new ArrayList<DataRowSet>(10);
        for (DynamicObject dyObj : datas) {
            String pk;
            Map data;
            DataRowSet rowSet = this.dataHelper.toDataRowSet(dyObj, dataSource);
            if (!dataMap.isEmpty() && (data = (Map)dataMap.get(pk = String.valueOf(dyObj.getPkValue()))) != null && !data.isEmpty()) {
                for (String attachKey : attachKeys) {
                    if (!data.containsKey(attachKey)) continue;
                    String attachName = StringUtils.join((Object[])((List)data.get(attachKey)).toArray(), (String)"\n");
                    rowSet.put(attachKey, (Field)new TextField(attachName));
                }
            }
            rowSetList.add(rowSet);
        }
        return rowSetList;
    }
}

