/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.service.dataprovider.BaseDataProvider;
import kd.bos.print.service.dataprovider.CustomDataProvider;
import kd.bos.print.service.dataprovider.utils.DataRowSetHelper;

public class ReportDataProvider
extends BaseDataProvider {
    private static final Log log = LogFactory.getLog(ReportDataProvider.class);
    private DataRowSetHelper dataHelper = new DataRowSetHelper();

    private IFormView getFormView(String pageId) {
        try {
            IFormView view = SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return SessionManager.getCurrent().getViewNoPlugin(pageId);
            }
            return view;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return SessionManager.getCurrent().getViewNoPlugin(pageId);
        }
    }

    @Override
    protected List<DataRowSet> queryDateRowSets(PrtDataSource prtDataSource) {
        if (prtDataSource.getDsType() == DsType.CUSTOM) {
            CustomDataProvider dataProvider = new CustomDataProvider();
            dataProvider.setPluginProxy(this.getPluginProxy());
            return dataProvider.getData(prtDataSource);
        }
        ArrayList<DataRowSet> rowSetList = new ArrayList<DataRowSet>(1);
        if (!(prtDataSource instanceof MainDataSource)) {
            return rowSetList;
        }
        DataRowSet resultRow = new DataRowSet();
        MainDataSource dataSource = (MainDataSource)prtDataSource;
        List filterFields = dataSource.getQueryField();
        List<String> reportEntryFields = dataSource.getChildrenDs().stream().flatMap(fMap -> fMap.getQueryField().stream()).collect(Collectors.toList());
        IFormView rptFormView = this.getFormView(dataSource.getPageId());
        if (rptFormView instanceof ReportView) {
            ReportListModel listModel = (ReportListModel)((ReportView)rptFormView).getReportList().getReportModel();
            LinkedHashMap filterValueMap = listModel.getReportQueryParam().getFilter().getFilterItems().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getPropName()) && f.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue, (t1, t2) -> t2, LinkedHashMap::new));
            this.dataHelper.init(dataSource.getMainEntityType());
            DynamicObjectCollection dynamicObjects = listModel.getRowData(0, listModel.getRowCount());
            ArrayList<DataRowSet> reportRows = new ArrayList<DataRowSet>(listModel.getRowCount());
            DynamicObject dynamicObject = null;
            if (dynamicObjects.size() > 0) {
                dynamicObject = (DynamicObject)dynamicObjects.get(0);
                assert (dynamicObject != null);
                for (int i = 0; i < dynamicObjects.size(); ++i) {
                    DynamicObject obj = (DynamicObject)dynamicObjects.get(i);
                    if (i == 0) {
                        Iterator iterator = filterValueMap.entrySet().iterator();
                        ArrayList<Map.Entry<String, Object>> itemClassProps = new ArrayList<Map.Entry<String, Object>>(5);
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> entry = iterator.next();
                            if (listModel.getItemType().getProperty((String)entry.getKey()) instanceof ItemClassProp) {
                                itemClassProps.add(entry);
                                continue;
                            }
                            this.setFilterValue2DynamicObject(dynamicObject, entry);
                        }
                        if (!CollectionUtils.isEmpty(itemClassProps)) {
                            for (Map.Entry entry : itemClassProps) {
                                this.setFilterValue2DynamicObject(dynamicObject, entry);
                            }
                        }
                    }
                    DataRowSet dataRowSet = this.dataHelper.toDataRowSet(obj, reportEntryFields);
                    dataRowSet.put("seq", (Field)new IntegerField(Integer.valueOf(i + 1)));
                    reportRows.add(dataRowSet);
                }
            }
            dataSource.getChildrenDs().stream().map(m -> m.getDsName().substring(m.getDsName().lastIndexOf(".") + 1)).filter(StringUtils::isNotBlank).forEach(childDsName -> {
                CollectionField collectionField = new CollectionField();
                collectionField.setValue(reportRows);
                resultRow.put(childDsName, (Field)collectionField);
            });
            if (dynamicObject != null) {
                DataRowSet filterRow = this.dataHelper.toDataRowSet(dynamicObject, filterFields.stream().map(m -> m.substring(m.indexOf(".") + 1)).collect(Collectors.toList()));
                for (String fieldName : filterFields) {
                    resultRow.put(fieldName, filterRow.getField(fieldName.substring(fieldName.indexOf(".") + 1)));
                }
            }
            rowSetList.add(resultRow);
        }
        return rowSetList;
    }

    private void setFilterValue2DynamicObject(DynamicObject dynamicObject, Map.Entry<String, Object> entry) {
        try {
            if (dynamicObject.containsProperty(entry.getKey())) {
                dynamicObject.set(entry.getKey(), entry.getValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

