/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;

public class WorkflowDataProvider {
    private static final Log log = LogFactory.getLog(WorkflowDataProvider.class);
    private static final String WITH_HISTORY = "withHistory";
    private static final String ALL_CONTAIN_HI_COMMENT = "allContainHiComment";
    private static String SIGN = "signature";

    static List<DataRowSet> getWorkflowApproveLine(WorkflowDataSource dataSource) {
        String businessKey = dataSource.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return Collections.EMPTY_LIST;
        }
        List<DataRowSet> dataRowSets = new ArrayList<DataRowSet>();
        String printScope = "";
        String approveLineType = "all";
        String approveLineSort = "default";
        boolean includeUserNode = false;
        boolean includeImage = true;
        boolean includeCall = false;
        Map wfParams = dataSource.getWorkFlowParams();
        if (wfParams != null && !wfParams.isEmpty()) {
            Object printScopeObj = wfParams.get("printScope");
            Object approveLineTypeObj = wfParams.get("approveLineType");
            Object approveLineSortObj = wfParams.get("approveLineSort");
            Object includeUserNodeObj = wfParams.get("includeUserNode");
            Object includeImgObj = wfParams.get("includeImg");
            Object includeCallObj = wfParams.get("includeCall");
            if (StringUtils.isNotBlank(printScopeObj)) {
                printScope = printScopeObj.toString();
            }
            if (StringUtils.isNotBlank(approveLineTypeObj)) {
                approveLineType = approveLineTypeObj.toString();
            }
            if (StringUtils.isNotBlank(approveLineSortObj)) {
                approveLineSort = approveLineSortObj.toString();
            }
            if (includeUserNodeObj != null) {
                includeUserNode = Boolean.parseBoolean(String.valueOf(includeUserNodeObj));
            }
            if (includeImgObj != null) {
                includeImage = Boolean.parseBoolean(String.valueOf(includeImgObj));
            }
            if (includeCallObj != null) {
                includeCall = Boolean.parseBoolean(String.valueOf(includeCallObj));
            }
        }
        if (WITH_HISTORY.equals(printScope)) {
            approveLineType = ALL_CONTAIN_HI_COMMENT;
        }
        try {
            HashMap<String, Object> printParam = new HashMap<String, Object>(3);
            printParam.put("order", approveLineSort);
            printParam.put("includeUserTask", includeUserNode);
            printParam.put("includeSSCImageUpload", includeImage);
            printParam.put("includeCallActivity", includeCall);
            printParam.put("entityNumber", dataSource.getFormId());
            StringBuilder requestParams = new StringBuilder();
            requestParams.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\uff1a\u3010businessKey:", (String)"WorkflowDataProvider_0", (String)"bos-print-service", (Object[])new Object[0])).append(businessKey).append(",approveLineType:").append(approveLineType).append(",printParam:").append(JSON.toJSONString(printParam)).append('\u3011');
            Collection wfDatas = WorkflowDataProvider.getWFService().getPrintCommentWithParam(businessKey, approveLineType, printParam);
            if (wfDatas != null) {
                dataRowSets = WorkflowDataProvider.lineNodesToDataRowSets(wfDatas);
            }
            log.info("\u65b0\u6253\u5370\u83b7\u53d6\u5ba1\u6279\u8def\u7ebf\u6570\u636e\uff1a" + requestParams + "---\u8fd4\u56de\u7ed3\u679c:" + (wfDatas == null ? "\u7a7a" : JSON.toJSONString((Object)wfDatas)));
        }
        catch (Exception e) {
            log.warn("\u65b0\u6253\u5370\uff1a\u83b7\u53d6\u5ba1\u6279\u7ebf\u8def\u51fa\u9519, businessKey:" + businessKey, (Throwable)e);
        }
        return dataRowSets;
    }

    static List<DataRowSet> getWorkflowApproveActivity(WorkflowDataSource dataSource) {
        String businessKey = dataSource.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataRowSet> dataRowSets = new ArrayList<DataRowSet>();
        try {
            Collection wfDatas;
            String type = "lastedConsent";
            Map wfParams = dataSource.getWorkFlowParams();
            if (wfParams != null && !wfParams.isEmpty() && StringUtils.isNotBlank(wfParams.get("singleactivity"))) {
                type = wfParams.get("singleactivity").toString();
            }
            if ((wfDatas = WorkflowDataProvider.getWFService().getCommentForPrintByType(businessKey, type)) != null && wfDatas.size() > 0) {
                dataRowSets.add(WorkflowDataProvider.activeNodesToRowSet(wfDatas));
            }
            log.info("\u65b0\u6253\u5370\uff1a\u83b7\u53d6\u5ba1\u6279\u8282\u70b9\u7ed3\u679c\u4e3a\uff1a" + (wfDatas == null || wfDatas.isEmpty() ? "\u7a7a" : wfDatas));
        }
        catch (Exception e) {
            log.error("\u65b0\u6253\u5370\uff1a\u83b7\u53d6\u5ba1\u6279\u7ebf\u8def\u51fa\u9519, businessKey:" + businessKey, (Throwable)e);
        }
        return dataRowSets;
    }

    private static DataRowSet activeNodesToRowSet(Collection<Map<String, String>> wfDatas) {
        DataRowSet rowSet = new DataRowSet();
        for (Map<String, String> activity : wfDatas) {
            String bizKey = activity.get("bizIdentifyKey");
            for (Map.Entry<String, String> entry : activity.entrySet()) {
                String fieldKey = bizKey + "." + entry.getKey();
                if (fieldKey.contains("resultname")) {
                    rowSet.put(fieldKey, (Field)new TextField(ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowDataProvider_1", (String)"bos-print-service", (Object[])new Object[0])));
                    continue;
                }
                if (fieldKey.contains(SIGN)) {
                    String value = entry.getValue();
                    if (StringUtils.isBlank((CharSequence)value)) {
                        value = "";
                    }
                    rowSet.put(fieldKey, (Field)new ImageField(value));
                    continue;
                }
                Field oldField = rowSet.getField(fieldKey);
                if (oldField instanceof NullField || oldField instanceof TextField && StringUtils.isBlank((Object)oldField.getValue())) {
                    rowSet.put(fieldKey, (Field)new TextField(entry.getValue()));
                    continue;
                }
                if (!fieldKey.contains("assignee") && !fieldKey.contains("message") && !fieldKey.contains("usernameformatter") && !fieldKey.contains("activityName") && !fieldKey.contains("userNameFormatter") && !fieldKey.contains("time") && !fieldKey.contains("resultName")) continue;
                String newValue = oldField.getValue() + "\n" + entry.getValue();
                rowSet.put(fieldKey, (Field)new TextField(newValue));
            }
        }
        return rowSet;
    }

    private static List<DataRowSet> lineNodesToDataRowSets(Collection<Map<String, String>> wfDatas) {
        ArrayList<DataRowSet> dataRowSets = new ArrayList<DataRowSet>(10);
        for (Map<String, String> wfData : wfDatas) {
            DataRowSet rowSet = new DataRowSet();
            for (Map.Entry<String, String> entry : wfData.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = "";
                }
                if (SIGN.equals(key)) {
                    rowSet.put(key, (Field)new ImageField(value));
                    continue;
                }
                rowSet.put(key, (Field)new TextField(value));
            }
            dataRowSets.add(rowSet);
        }
        return dataRowSets;
    }

    private static IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }
}

