/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.service.ISensitiveService;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.ConvertParam;
import kd.bos.print.service.provider.SensitiveServiceProvider;

public class BaseConvert {
    private Log log = LogFactory.getLog(BaseConvert.class);

    public Field convertToField(PropertyObject propObject) {
        Object value = propObject.getValue();
        Object field = value instanceof String ? new TextField((String)value) : NullField.get();
        return field;
    }

    protected Field deDesensitive(ConvertParam convertParam, Field field) {
        ISensitiveService sensitiveService = ExecuteContext.get().getServiceProxy().getSensitiveService();
        if (!sensitiveService.enablePrivacy()) {
            return field;
        }
        try {
            String[] fieldArr;
            PropertyObject propObject = convertParam.getPropObject();
            DynamicProperty property = propObject.getProperty();
            DynamicObject headerObj = convertParam.getHeaderObj();
            MainEntityType mainEntityType = (MainEntityType)headerObj.getDataEntityType();
            String formId = mainEntityType.getName();
            long orgId = this.getMainOrg(headerObj, mainEntityType);
            IDataEntityType parent = property.getParent();
            String fieldKey = convertParam.getFieldKey();
            if (sensitiveService != null && StringUtils.isNotBlank((CharSequence)fieldKey) && (field = ((SensitiveServiceProvider)sensitiveService).doFieldViewPermission(formId, orgId, (fieldArr = fieldKey.split("\\."))[0], field)).isDesensitive()) {
                return field;
            }
            if (field instanceof NullField) {
                return field;
            }
            if (sensitiveService != null && sensitiveService.enablePrivacy() && parent != null) {
                SensitiveServiceProvider sensitiveProvider = (SensitiveServiceProvider)sensitiveService;
                String dataSource = convertParam.getCurObj().getDataEntityType().getName();
                sensitiveProvider.deDesensitive(formId, dataSource, fieldKey, parent, (IDataEntityProperty)property, field);
            }
        }
        catch (Exception e) {
            this.log.warn("\u8131\u654f\u5f02\u5e38", (Throwable)e);
        }
        return field;
    }

    public Field convertToField(ConvertParam context) {
        Field field = this.convertToField(context.getPropObject());
        field = this.deDesensitive(context, field);
        return field;
    }

    private long getMainOrg(DynamicObject headerObj, MainEntityType mainEntityType) {
        Object mainOrgObj;
        long orgId = 0L;
        String mainOrg = mainEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg) && (mainOrgObj = headerObj.get(mainOrg)) != null) {
            orgId = mainOrgObj instanceof DynamicObject ? (Long)((DynamicObject)mainOrgObj).getPkValue() : Long.parseLong(mainOrgObj.toString());
        }
        return orgId;
    }
}

