/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.field.DateField;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.service.IUserService;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.BaseConvert;
import kd.bos.print.service.dataprovider.convert.ConvertParam;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;

public class DateTimePropConvert
extends BaseConvert {
    @Override
    public Field convertToField(ConvertParam context) {
        Field field = this.convertToField(context.getPropObject(), context.getHeaderObj(), context.getParentObj(), context.getCurObj());
        field = this.deDesensitive(context, field);
        return field;
    }

    private Field convertToField(PropertyObject propObject, DynamicObject headerObj, DynamicObject parentObj, DynamicObject curObj) {
        return this.formatDate(propObject, headerObj, parentObj, curObj);
    }

    @Override
    @Deprecated
    public Field convertToField(PropertyObject propObject) {
        return this.formatDate(propObject, null, null, null);
    }

    private Field formatDate(PropertyObject propObject, DynamicObject headerObj, DynamicObject parentObj, DynamicObject curObj) {
        String tf = "timeFormat";
        String format = "";
        Object value = propObject.getValue();
        DynamicProperty prop = propObject.getProperty();
        TimeZone timeZone = KDDateUtils.getSysTimeZone();
        if (value != null) {
            IUserService userService = ExecuteContext.get().getServiceProxy().getUserService();
            String dateFormat = userService.getDateFormat();
            Map timeFormat = userService.getTimeFormat();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            if (prop instanceof DateProp) {
                DateProp dProp = (DateProp)prop;
                InteTimeZone inteTimeZone = this.getTimeZone((DateTimeProp)dProp, headerObj, parentObj, curObj);
                timeZone = inteTimeZone.getTimeZone();
                sdf.setTimeZone(timeZone);
                format = sdf.format((Date)value);
            } else if (prop instanceof CreateDateProp || prop instanceof ModifyDateProp) {
                sdf = new SimpleDateFormat(dateFormat + " " + (String)timeFormat.get(tf));
                timeZone = KDDateUtils.getSysTimeZone();
                sdf.setTimeZone(timeZone);
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                format = sysTz.format((Date)value, (DateFormat)sdf);
            } else {
                DateTimeProp dProp = (DateTimeProp)prop;
                if (dProp.getRegionType() == 2) {
                    sdf = new SimpleDateFormat(dateFormat + " " + (String)timeFormat.get(tf));
                }
                InteTimeZone inteTimeZone = this.getTimeZone(dProp, headerObj, parentObj, curObj);
                timeZone = inteTimeZone.getTimeZone();
                sdf.setTimeZone(timeZone);
                format = sdf.format((Date)value);
            }
        }
        DateTimeField field = null;
        if (value instanceof Timestamp) {
            field = new DateTimeField((Timestamp)value);
            field.setDisplayVal(format);
            field.setTimeZone(timeZone);
        } else if (value instanceof Date) {
            field = new DateField((Date)value);
            field.setDisplayVal(format);
            field.setTimeZone(timeZone);
        } else {
            field = new TextField(format);
        }
        field.setFormat(propObject.getFormat());
        return field;
    }

    private InteTimeZone getTimeZone(DateTimeProp dateTimeProp, DynamicObject headerObj, DynamicObject parentObj, DynamicObject curObj) {
        DynamicObjectType dataEntityType;
        String relateOrg;
        Long orgId = 0L;
        if (headerObj == null || parentObj == null || curObj == null) {
            return dateTimeProp.getTimeZone(orgId);
        }
        MainEntityType mainEntityType = null;
        DynamicObjectType dynamicObjectType = headerObj.getDynamicObjectType();
        if (dynamicObjectType instanceof MainEntityType) {
            mainEntityType = (MainEntityType)dynamicObjectType;
        }
        if (StringUtils.isBlank((CharSequence)(relateOrg = dateTimeProp.getRelateOrg())) && mainEntityType != null) {
            relateOrg = mainEntityType.getMainOrg();
        }
        DynamicObject orgObj = null;
        DynamicObjectType entityType = curObj.getDynamicObjectType();
        DynamicProperty controlProp = entityType.getProperty(relateOrg);
        if (controlProp != null) {
            orgObj = curObj.getDynamicObject(relateOrg);
        }
        if (controlProp == null && mainEntityType != null && (controlProp = mainEntityType.getProperty(relateOrg)) != null) {
            orgObj = headerObj.getDynamicObject(relateOrg);
        }
        if (controlProp == null && entityType instanceof SubEntryType && parentObj != null && (controlProp = (dataEntityType = parentObj.getDynamicObjectType()).getProperty(relateOrg)) != null) {
            orgObj = parentObj.getDynamicObject(relateOrg);
        }
        if (orgObj != null) {
            orgId = (Long)orgObj.getPkValue();
        }
        return dateTimeProp.getTimeZone(orgId);
    }
}

