/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.BaseConvert;
import kd.bos.print.service.dataprovider.convert.ConvertParam;

public class DecimalPropConvert
extends BaseConvert {
    @Override
    public Field convertToField(PropertyObject propObject) {
        Object value = propObject.getValue();
        DecimalField field = new DecimalField((BigDecimal)value);
        return field;
    }

    @Override
    public Field convertToField(ConvertParam convertParam) {
        DynamicObjectType dataEntityType;
        MainEntityType mainEntityType;
        PropertyObject propObject = convertParam.getPropObject();
        DynamicObject curObj = convertParam.getCurObj();
        DynamicObject headerObj = convertParam.getHeaderObj();
        DynamicObject parentObj = convertParam.getParentObj();
        DynamicProperty property = propObject.getProperty();
        Object value = propObject.getValue();
        DecimalField field = new DecimalField((BigDecimal)value);
        DecimalProp decimalProp = (DecimalProp)property;
        DecimalField decimalField = field;
        decimalField.setShowZero(decimalProp.isZeroShow());
        int defaultScale = this.getDefaultScale(decimalProp);
        decimalField.setScale(defaultScale);
        String controlPropName = decimalProp.getControlPropName();
        if (StringUtils.isBlank((CharSequence)controlPropName)) {
            field = this.deDesensitive(convertParam, (Field)field);
            return field;
        }
        DynamicObject currencyObj = null;
        DynamicObjectType entityType = curObj.getDynamicObjectType();
        DynamicProperty controlProp = entityType.getProperty(controlPropName);
        if (controlProp != null) {
            currencyObj = curObj.getDynamicObject(controlPropName);
        }
        if (controlProp == null && (controlProp = (mainEntityType = (MainEntityType)headerObj.getDynamicObjectType()).getProperty(controlPropName)) != null) {
            currencyObj = headerObj.getDynamicObject(controlPropName);
        }
        if (controlProp == null && entityType instanceof SubEntryType && parentObj != null && (controlProp = (dataEntityType = parentObj.getDynamicObjectType()).getProperty(controlPropName)) != null) {
            currencyObj = parentObj.getDynamicObject(controlPropName);
        }
        if (controlProp != null && currencyObj != null) {
            if (controlProp instanceof UnitProp) {
                int precision = currencyObj.getInt("precision");
                decimalField.setScale(precision);
            } else {
                DecimalControlInfo info = this.getDecimalControlInfo(decimalProp, currencyObj);
                decimalField.setCode(info.code);
                decimalField.setSymbol(info.symbol);
                decimalField.setScale(info.scale);
            }
        }
        field = this.deDesensitive(convertParam, (Field)field);
        return field;
    }

    private DecimalControlInfo getDecimalControlInfo(DecimalProp decimalProp, DynamicObject currencyObj) {
        DecimalControlInfo info = new DecimalControlInfo();
        String code = currencyObj.getString("number");
        String symbol = currencyObj.getString("sign");
        int amountScale = currencyObj.getInt("amtprecision");
        int priceScale = currencyObj.getInt("priceprecision");
        if (StringUtils.isBlank((CharSequence)code)) {
            code = (String)FmtInfoUtils.getMainCurrencyFmt().get("cs");
        }
        info.code = code;
        info.symbol = symbol;
        if (StringUtils.isBlank((Object)amountScale)) {
            amountScale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("ap");
        }
        if (StringUtils.isBlank((Object)priceScale)) {
            priceScale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("pp");
        }
        if (decimalProp instanceof PriceProp) {
            info.scale = priceScale;
        } else if (decimalProp instanceof AmountProp) {
            info.scale = amountScale;
        } else if (decimalProp instanceof DecimalProp) {
            info.scale = decimalProp.getScale();
        }
        return info;
    }

    private int getDefaultScale(DecimalProp property) {
        int scale = 2;
        if (property instanceof PriceProp) {
            scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("pp");
        } else if (property instanceof AmountProp) {
            scale = (Integer)FmtInfoUtils.getMainCurrencyFmt().get("ap");
        } else if (property instanceof DecimalProp) {
            scale = property.getScale();
        }
        return scale;
    }

    private static class DecimalControlInfo {
        private String symbol;
        private String code;
        private int scale;

        private DecimalControlInfo() {
        }
    }
}

