/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.service.dataprovider.convert.BaseConvert;
import kd.bos.print.service.dataprovider.convert.ConvertParam;

public class ItemClassPropConvert
extends BaseConvert {
    @Override
    public Field convertToField(ConvertParam context) {
        String fieldKey = context.getFieldKey();
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            return this.deDesensitive(context, (Field)new TextField(""));
        }
        String[] split = fieldKey.split("\\.");
        if (split.length < 2) {
            return this.deDesensitive(context, (Field)NullField.get());
        }
        String field = split[split.length - 1];
        DynamicObject curObj = (DynamicObject)context.getPropObject().getValue();
        if (curObj == null) {
            return this.deDesensitive(context, (Field)NullField.get());
        }
        ItemClassProp itemClassProp = (ItemClassProp)context.getPropObject().getProperty();
        IDataEntityType complexType = itemClassProp.getComplexType();
        if (!(complexType instanceof BasedataEntityType)) {
            return this.deDesensitive(context, (Field)NullField.get());
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)complexType;
        boolean isNameProp = this.isNameProp(field, basedataEntityType);
        BasedataEntityType dataEntityType = (BasedataEntityType)curObj.getDataEntityType();
        if (isNameProp) {
            String name = curObj.getString(dataEntityType.getNameProperty());
            return this.deDesensitive(context, (Field)new TextField(name));
        }
        boolean isNumberProp = this.isNumberProp(field, basedataEntityType);
        if (isNumberProp) {
            String number = curObj.getString(dataEntityType.getNumberProperty());
            return this.deDesensitive(context, (Field)new TextField(number));
        }
        if (dataEntityType.getProperties().containsKey((Object)field)) {
            Object value = curObj.get(field);
            if (value == null) {
                return this.deDesensitive(context, (Field)NullField.get());
            }
            return this.deDesensitive(context, (Field)new TextField(value.toString()));
        }
        return this.deDesensitive(context, (Field)NullField.get());
    }

    private boolean isNumberProp(String field, BasedataEntityType basedataEntityType) {
        boolean isNumberProp = false;
        String numberProperty = basedataEntityType.getNumberProperty();
        if (field.equals(numberProperty)) {
            isNumberProp = true;
        }
        return isNumberProp;
    }

    private boolean isNameProp(String field, BasedataEntityType basedataEntityType) {
        boolean isNameProp = false;
        String nameProperty = basedataEntityType.getNameProperty();
        if (field.equals(nameProperty)) {
            isNameProp = true;
        }
        return isNameProp;
    }
}

