/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.SignatureProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.AdminDivisionPropConvert;
import kd.bos.print.service.dataprovider.convert.AttachmentPropConvert;
import kd.bos.print.service.dataprovider.convert.BaseConvert;
import kd.bos.print.service.dataprovider.convert.BooleanPropConvert;
import kd.bos.print.service.dataprovider.convert.ComboPropConvert;
import kd.bos.print.service.dataprovider.convert.ConvertParam;
import kd.bos.print.service.dataprovider.convert.DateTimePropConvert;
import kd.bos.print.service.dataprovider.convert.DecimalPropConvert;
import kd.bos.print.service.dataprovider.convert.FlexPropConvert;
import kd.bos.print.service.dataprovider.convert.IntegerPropConvert;
import kd.bos.print.service.dataprovider.convert.ItemClassPropConvert;
import kd.bos.print.service.dataprovider.convert.LongPropConvert;
import kd.bos.print.service.dataprovider.convert.MulBasedataPropConvert;
import kd.bos.print.service.dataprovider.convert.MulComboPropConvert;
import kd.bos.print.service.dataprovider.convert.MuliLangTextPropConvert;
import kd.bos.print.service.dataprovider.convert.PicturePropConvert;
import kd.bos.print.service.dataprovider.convert.TimePropConvert;

public class PropConvertProxy {
    private static Map<Class, BaseConvert> convertMap = new HashMap<Class, BaseConvert>();
    private static BaseConvert defaultConvert = new BaseConvert();

    public static Field convertToField(PropertyObject propObject) {
        DynamicProperty property = propObject.getProperty();
        Object value = propObject.getValue();
        if (value == null) {
            return NullField.get();
        }
        BaseConvert convert = convertMap.get(property.getClass());
        if (convert == null) {
            convert = defaultConvert;
        }
        return convert.convertToField(propObject);
    }

    public static Field convertToField(ConvertParam context) {
        PropertyObject propObject = context.getPropObject();
        Object value = propObject.getValue();
        if (value == null) {
            Field field = defaultConvert.deDesensitive(context, (Field)NullField.get());
            if (field.isDesensitive()) {
                return field;
            }
            return NullField.get();
        }
        DynamicProperty property = propObject.getProperty();
        BaseConvert convert = PropConvertProxy.getConvert(property.getClass());
        if (convert == null) {
            convert = defaultConvert;
        }
        return convert.convertToField(context);
    }

    private static BaseConvert getConvert(Class clazz) {
        Class superclass;
        if (clazz == null || !DynamicProperty.class.isAssignableFrom(clazz)) {
            return null;
        }
        BaseConvert convert = convertMap.get(clazz);
        if (convert == null && (superclass = clazz.getSuperclass()) != null) {
            convert = PropConvertProxy.getConvert(superclass);
        }
        return convert;
    }

    static {
        convertMap.put(AttachmentProp.class, new AttachmentPropConvert());
        convertMap.put(BooleanProp.class, new BooleanPropConvert());
        convertMap.put(ComboProp.class, new ComboPropConvert());
        convertMap.put(MulComboProp.class, new MulComboPropConvert());
        convertMap.put(DateTimeProp.class, new DateTimePropConvert());
        convertMap.put(TimeProp.class, new TimePropConvert());
        convertMap.put(DecimalProp.class, new DecimalPropConvert());
        convertMap.put(AdminDivisionProp.class, new AdminDivisionPropConvert());
        convertMap.put(FlexProp.class, new FlexPropConvert());
        convertMap.put(IntegerProp.class, new IntegerPropConvert());
        LongPropConvert longPropConvert = new LongPropConvert();
        convertMap.put(LongProp.class, longPropConvert);
        convertMap.put(BigIntProp.class, longPropConvert);
        convertMap.put(MulBasedataProp.class, new MulBasedataPropConvert());
        convertMap.put(MuliLangTextProp.class, new MuliLangTextPropConvert());
        convertMap.put(PictureProp.class, new PicturePropConvert());
        convertMap.put(SignatureProp.class, new PicturePropConvert());
        convertMap.put(ItemClassProp.class, new ItemClassPropConvert());
    }
}

