/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.convert;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.inte.api.IInteService;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.data.field.TimeField;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.BaseConvert;
import kd.bos.service.ServiceFactory;

public class TimePropConvert
extends BaseConvert {
    @Override
    public Field convertToField(PropertyObject propObject) {
        Integer value = (Integer)propObject.getValue();
        TimeField field = new TimeField(this.getTime(value));
        field.setRealValue(value);
        field.setFormat(propObject.getFormat());
        field.setDisplayVal(this.formatTime(value));
        return field;
    }

    private String getTime(Integer time) {
        if (time != null && time >= 0) {
            Integer hour = time / 3600;
            time = time % 3600;
            Integer minutes = time / 60;
            Integer second = time % 60;
            String result = (hour < 10 ? "0" : "") + hour + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (second < 10 ? "0" : "") + second;
            return result;
        }
        return "";
    }

    private String formatTime(Integer time) {
        if (time != null && time >= 0) {
            String result = this.getTime(time);
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            Long userId = RequestContext.get().getCurrUserId();
            Map timeFormat = inteService.getTimeFormat(userId);
            FormatResult r = Formats.getFormat((String)((String)timeFormat.get("timeFormat"))).format(new Variant((Object)result));
            result = (String)new TextField(r.toString()).getValue();
            return result;
        }
        return "";
    }
}

