/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.convert.ConvertParam;
import kd.bos.print.service.dataprovider.convert.PropConvertProxy;
import kd.bos.print.service.dataprovider.utils.DynamicObjectResolve;
import kd.bos.print.service.util.FormApUtil;

public class DataRowSetHelper {
    private static final Log logger = LogFactory.getLog(DataRowSetHelper.class);
    private MainEntityType mainEntityType;
    private DynamicObject headerObj;
    private DynamicObject parentObj;
    private DynamicObjectResolve dynamicObjectResolve = new DynamicObjectResolve();
    private Map<String, Map<String, String>> formatMap = new HashMap<String, Map<String, String>>(0);

    public void init(MainEntityType mainEntityType) {
        this.mainEntityType = mainEntityType;
    }

    public DataRowSet toDataRowSet(DynamicObject obj, FormDataSource dataSource) {
        this.headerObj = obj;
        this.parentObj = obj;
        List queryField = dataSource.getQueryField();
        queryField.add("id");
        DataRowSet rowSet = this.dyObjToDataRowSet(obj, queryField);
        List childrenDs = dataSource.getChildrenDs();
        for (PrtDataSource childDs : childrenDs) {
            String dsName = childDs.getDsName();
            queryField = childDs.getQueryField();
            EntityType entityType = this.getEntityType(dsName);
            if (entityType == null || DsType.ATTACH == childDs.getDsType() || entityType instanceof SubEntryType) continue;
            DynamicObjectCollection entryCollection = obj.getDynamicObjectCollection(entityType.getName());
            CollectionField collectionField = new CollectionField();
            for (int i = 0; i < entryCollection.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCollection.get(i);
                DataRowSet entryRow = this.dyObjToDataRowSet(entryObj, queryField);
                entryRow.put("seq", (Field)new IntegerField(Integer.valueOf(i + 1)));
                collectionField.add(entryRow);
                this.subEntryToDataRowList(entryRow, entryObj, (EntryType)entityType, childrenDs);
            }
            rowSet.put(entityType.getName(), (Field)collectionField);
        }
        return rowSet;
    }

    private DataRowSet dyObjToDataRowSet(DynamicObject obj, List<String> queryField) {
        DataRowSet dataRowSet = new DataRowSet();
        return this.toDataRowSet(dataRowSet, obj, queryField);
    }

    public DataRowSet toDataRowSet(DynamicObject obj, List<String> queryField) {
        this.headerObj = obj;
        this.parentObj = obj;
        DataRowSet dataRowSet = new DataRowSet();
        return this.toDataRowSet(dataRowSet, obj, queryField);
    }

    private void subEntryToDataRowList(DataRowSet entryDataRowSet, DynamicObject obj, EntryType entryType, List<PrtDataSource> childrenDs) {
        for (PrtDataSource prtDs : childrenDs) {
            SubEntryType subEntryType;
            String parentName;
            EntityType tempEntryType = this.getEntityType(prtDs.getDsName());
            this.parentObj = obj;
            if (!(tempEntryType instanceof SubEntryType) || !StringUtils.equals((CharSequence)(parentName = (subEntryType = (SubEntryType)tempEntryType).getParent().getName()), (CharSequence)entryType.getName())) continue;
            DynamicObjectCollection subCollection = obj.getDynamicObjectCollection(subEntryType.getName());
            ArrayList<DataRowSet> dataRowSets = new ArrayList<DataRowSet>(16);
            for (int i = 0; i < subCollection.size(); ++i) {
                DynamicObject subObj = (DynamicObject)subCollection.get(i);
                DataRowSet rowSet = this.dyObjToDataRowSet(subObj, prtDs.getQueryField());
                rowSet.put("seq", (Field)new IntegerField(Integer.valueOf(i + 1)));
                dataRowSets.add(rowSet);
            }
            entryDataRowSet.put(subEntryType.getName(), (Field)new CollectionField(dataRowSets));
        }
    }

    private DataRowSet toDataRowSet(DataRowSet dataRowSet, DynamicObject obj, List<String> queryField) {
        queryField = queryField.stream().distinct().collect(Collectors.toList());
        for (String queryKey : queryField) {
            PropertyObject propObject = this.dynamicObjectResolve.getPropObject(obj, queryKey);
            if (propObject == null) {
                dataRowSet.put(queryKey, (Field)NullField.get());
                continue;
            }
            DynamicProperty property = propObject.getProperty();
            if (property instanceof TimeProp || property instanceof DateTimeProp) {
                String[] split = queryKey.split("\\.");
                String prop = split[split.length - 1];
                String format = DataRowSetHelper.getFormat(this.formatMap, prop, property);
                propObject.setFormat(format);
            }
            ConvertParam convertParam = new ConvertParam();
            convertParam.setFieldKey(queryKey);
            convertParam.setCurObj(obj);
            convertParam.setHeaderObj(this.headerObj);
            convertParam.setParentObj(this.parentObj);
            convertParam.setPropObject(propObject);
            Field field = PropConvertProxy.convertToField(convertParam);
            dataRowSet.put(queryKey, field);
        }
        return dataRowSet;
    }

    private EntityType getEntityType(String dsName) {
        Map allEntities = this.mainEntityType.getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    public static String getFormat(Map<String, Map<String, String>> formatMap, String prop, DynamicProperty property) {
        if (prop == null) {
            return "";
        }
        IDataEntityType parent = property.getParent();
        String formId = DataRowSetHelper.getFormId(parent);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        Map<String, String> formats = formatMap.get(formId);
        if (formats == null) {
            Map<String, String> fieldFormatMap = DataRowSetHelper.getFieldMaskMap(formId);
            formatMap.put(formId, fieldFormatMap);
        }
        formats = formatMap.get(formId);
        return formats.get(prop);
    }

    private static String getFormId(IDataEntityType dynamicObjectType) {
        if (dynamicObjectType instanceof BillEntityType) {
            return dynamicObjectType.getName();
        }
        if (dynamicObjectType instanceof EntryType) {
            IDataEntityType parent = dynamicObjectType.getParent();
            if (parent instanceof BillEntityType) {
                return parent.getName();
            }
            if (parent instanceof EntryType && (parent = parent.getParent()) instanceof BillEntityType) {
                return parent.getName();
            }
        }
        return "";
    }

    private static Map<String, String> getFieldMaskMap(String formId) {
        try {
            return FormApUtil.dateFieldMaskMap(formId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return new HashMap<String, String>(0);
        }
    }
}

