/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.print.service.dataprovider.utils.FlexResolve;

public class DynamicObjectResolve {
    private static final Log logger = LogFactory.getLog(DynamicObjectResolve.class);
    private FlexResolve flexResolve = new FlexResolve();

    public PropertyObject getPropObject(DynamicObject obj, String propKey) {
        String[] props = propKey.split("\\.");
        return this.getPropObject(obj, obj, props, 0);
    }

    private PropertyObject getPropObject(DynamicObject srcDynamicObject, DynamicObject obj, String[] props, int index) {
        PropertyObject propertyObject;
        TextProp textProp;
        if (index < 0 || index >= props.length) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        String prop = props[index];
        DynamicObjectType dynamicObjectType = obj.getDynamicObjectType();
        DynamicProperty property = dynamicObjectType.getProperty(prop);
        if (property == null) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        Object value = property.getValue((Object)obj);
        if (property instanceof TextProp && (textProp = (TextProp)property).isPassword() && value != null && StringUtils.isNotEmpty((CharSequence)value.toString())) {
            return new PropertyObject((DynamicProperty)new TextProp(), "******");
        }
        if (prop == null) {
            return null;
        }
        if (property instanceof FlexProp) {
            if (value != null && index < props.length - 1) {
                String flexFieldName = props[props.length - 1];
                PropertyObject propertyObject2 = this.flexResolve.getFlexPropertyObject(srcDynamicObject, obj, (FlexProp)property, flexFieldName, (DynamicObject)value);
                return propertyObject2;
            }
        } else if (property instanceof MulBasedataProp) {
            if (index == props.length - 1) {
                propertyObject = new PropertyObject(property, value);
                return propertyObject;
            }
            if (index < props.length - 1) {
                String propName = props[index + 1];
                return new PropertyObject(property, (IDataEntityProperty)((MulBasedataProp)property).getComplexType().getProperties().get((Object)propName), value);
            }
        } else {
            if (property instanceof ItemClassProp) {
                propertyObject = value == null ? new PropertyObject((DynamicProperty)new TextProp(), "") : new PropertyObject(property, value);
                return propertyObject;
            }
            if (value instanceof DynamicObject) {
                propertyObject = this.getPropObject(srcDynamicObject, (DynamicObject)value, props, ++index);
                return propertyObject;
            }
        }
        propertyObject = new PropertyObject(property, value);
        return propertyObject;
    }
}

