/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.dataprovider.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.service.dataprovider.PropertyObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.acl.AclAdapter;

public class FlexResolve {
    private static final Log logger = LogFactory.getLog(FlexResolve.class);
    private Map<String, List<Long>> flexPropertyIdsMap = new HashMap<String, List<Long>>(16);
    private Map<String, FlexEntityType> flexEntityTypeMap = new HashMap<String, FlexEntityType>(16);
    private Map<String, BasedataEntityType> refBdTypeMap = new HashMap<String, BasedataEntityType>(16);
    private Map<String, DynamicObject> refBdValues = new HashMap<String, DynamicObject>(16);
    private Map<String, String> flexPropViewFieldMap = new HashMap<String, String>(16);

    public PropertyObject getFlexPropertyObject(DynamicObject srcDynamicObject, DynamicObject parentDynamicObject, FlexProp flexProp, String flexFieldName, DynamicObject flexValue) {
        int flexTypeId;
        String flexName;
        String flexPropertyIdCacheKey;
        List flexPropertyIds;
        if (flexValue == null || StringUtils.isBlank((CharSequence)flexFieldName)) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        DynamicObjectType dynamicObjectType = parentDynamicObject.getDynamicObjectType();
        if (!flexValue.containsProperty("value") || StringUtils.isBlank((CharSequence)flexValue.getString("value"))) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexValue.getString("value"), Map.class);
        String basePropertyKey = flexProp.getBasePropertyKey();
        BasedataProp refBaseDataProp = (BasedataProp)dynamicObjectType.getProperties().get((Object)basePropertyKey);
        DynamicObject refBaseData = parentDynamicObject.getDynamicObject(basePropertyKey);
        if (refBaseData == null) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        Object baseId = refBaseData.getPkValue();
        BasedataEntityType baseEntityType = (BasedataEntityType)refBaseDataProp.getComplexType();
        String relateBDEntityNumber = baseEntityType.getName();
        String relateBDFlexPropertyKey = baseEntityType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)baseEntityType.getFlexProperty()) && baseEntityType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            DynamicObject refBDMasterVal = (DynamicObject)refBaseData.get(baseEntityType.getMasteridPropName());
            if (refBDMasterVal != null) {
                baseId = refBDMasterVal.get("id");
            }
        }
        if ((flexPropertyIds = this.flexPropertyIdsMap.get(flexPropertyIdCacheKey = this.getCacheKey(baseId, relateBDEntityNumber, relateBDFlexPropertyKey))) == null) {
            flexPropertyIds = FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)baseId, (String)relateBDFlexPropertyKey);
            this.flexPropertyIdsMap.put(flexPropertyIdCacheKey, flexPropertyIds);
        }
        if (CollectionUtils.isEmpty(flexPropertyIds)) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        String dynamicObjectTypeName = dynamicObjectType.getName();
        String flexTypeCacheKey = this.getCacheKey(flexPropertyIdCacheKey, dynamicObjectTypeName, flexName = flexProp.getName(), flexTypeId = flexProp.getFlexTypeId());
        FlexEntityType flexEntityType = this.flexEntityTypeMap.get(flexTypeCacheKey);
        if (flexEntityType == null) {
            flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)dynamicObjectTypeName, (String)flexName, (int)flexTypeId, (List)flexPropertyIds);
            this.flexEntityTypeMap.put(flexTypeCacheKey, flexEntityType);
        }
        if (flexEntityType == null) {
            return new PropertyObject((DynamicProperty)new TextProp(), "");
        }
        Map<String, Object> flexValMap = this.getFlexValueMap(srcDynamicObject, valueMap, flexProp.getName(), flexEntityType);
        PropertyObject propertyObject = new PropertyObject((DynamicProperty)new TextProp(), flexValMap.get(flexFieldName));
        return propertyObject;
    }

    private Map<String, Object> getFlexValueMap(DynamicObject srcDynamicObject, Map<String, Object> valueMap, String flexFieldName, FlexEntityType flexEntityType) {
        LinkedHashMap<String, Object> flexValMap = new LinkedHashMap<String, Object>(16);
        for (IDataEntityProperty property : flexEntityType.getProperties()) {
            String propertyId;
            Object fieldValue;
            String name = property.getName();
            String[] nameSplit = name.split("__");
            if (nameSplit.length <= 1 || (fieldValue = valueMap.get(propertyId = nameSplit[1])) == null) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                String baseDataView = this.getBaseDataView(srcDynamicObject, propertyId, basedataProp, fieldValue);
                flexValMap.put(propertyId, baseDataView);
                continue;
            }
            if (!(property instanceof TextProp)) continue;
            flexValMap.put(propertyId, fieldValue);
        }
        StringBuilder builder = this.builderFlexAllView(flexEntityType, flexValMap);
        flexValMap.put(flexFieldName, builder.toString());
        return flexValMap;
    }

    private StringBuilder builderFlexAllView(FlexEntityType flexEntityType, Map<String, Object> flexValMap) {
        List flexProperties = flexEntityType.getFlexProperties();
        StringBuilder builder = new StringBuilder();
        for (FlexProperty flexProperty : flexProperties) {
            String flexField = flexProperty.getFlexField();
            if (!flexValMap.containsKey(flexField)) continue;
            String disPlayName = String.valueOf(flexProperty.getName());
            Object fieldValue = flexValMap.get(flexField);
            builder = this.builderFlexAllView(builder, disPlayName, fieldValue);
        }
        return builder;
    }

    private StringBuilder builderFlexAllView(StringBuilder builder, String disPlayName, Object viewText) {
        if (StringUtils.isNotBlank((Object)viewText)) {
            if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
                builder.append("\uff1b");
            }
            builder.append(disPlayName).append("\uff1a").append(viewText);
        }
        return builder;
    }

    private String getCacheKey(Object ... params) {
        StringBuilder builder = new StringBuilder();
        for (Object param : params) {
            builder.append(param).append("_");
        }
        String key = builder.toString();
        return key;
    }

    private String getBaseDataView(DynamicObject srcDynamicObject, String propertyId, BasedataProp basedataProp, Object fieldValue) {
        DynamicObject dynamicObjectNameVersion;
        String refBdValueCacheKey;
        DynamicObject dynamicObject;
        HashSet<String> selectFields = new HashSet<String>(2);
        if (fieldValue instanceof Integer) {
            fieldValue = ((Integer)fieldValue).longValue();
        }
        BasedataEntityType flexObjectBaseType = (BasedataEntityType)basedataProp.getComplexType();
        String nameProperty = flexObjectBaseType.getNameProperty();
        String numberProperty = flexObjectBaseType.getNumberProperty();
        String longNumberField = "longnumber";
        String fullNameField = "fullname";
        selectFields.add(numberProperty);
        selectFields.add(nameProperty);
        selectFields.add(longNumberField);
        selectFields.add(fullNameField);
        String baseTypeName = flexObjectBaseType.getName();
        String refBdTypeCacheKey = this.getCacheKey(baseTypeName, ((Object)selectFields).toString());
        BasedataEntityType refBDType = this.refBdTypeMap.get(refBdTypeCacheKey);
        if (refBDType == null) {
            refBDType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)baseTypeName, selectFields);
            this.refBdTypeMap.put(refBdTypeCacheKey, refBDType);
        }
        if ((dynamicObject = this.refBdValues.get(refBdValueCacheKey = this.getCacheKey(refBdTypeCacheKey, fieldValue))) == null) {
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)fieldValue, (DynamicObjectType)refBDType);
            this.refBdValues.put(refBdValueCacheKey, dynamicObject);
        }
        if ((dynamicObjectNameVersion = AclAdapter.getBasedataVersionService().getNameVersionData(dynamicObject, srcDynamicObject)) == null) {
            logger.info("Dirty data " + refBdTypeCacheKey);
            return "";
        }
        String viewFieldType = this.flexPropViewFieldMap.get(propertyId);
        if (StringUtils.isBlank((CharSequence)viewFieldType)) {
            viewFieldType = this.getBaseDataViewFieldType(propertyId);
            this.flexPropViewFieldMap.put(propertyId, viewFieldType);
        }
        String name = this.getOrDefault(nameProperty, dynamicObjectNameVersion);
        String number = this.getOrDefault(numberProperty, dynamicObjectNameVersion);
        String longNumber = this.getOrDefault(longNumberField, dynamicObjectNameVersion);
        String fullName = this.getOrDefault(fullNameField, dynamicObjectNameVersion);
        if ("1".equals(viewFieldType)) {
            return number;
        }
        if ("3".equals(viewFieldType)) {
            return this.getViewText(number, name);
        }
        if ("4".equals(viewFieldType)) {
            return longNumber;
        }
        if ("5".equals(viewFieldType)) {
            return fullName;
        }
        return name;
    }

    private String getOrDefault(String fieldKey, DynamicObject dynamicObjectNameVersion) {
        if (dynamicObjectNameVersion.containsProperty(fieldKey)) {
            return dynamicObjectNameVersion.getString(fieldKey);
        }
        return "";
    }

    private String getBaseDataViewFieldType(String propertyId) {
        String sql = "select fdisprops from t_bas_flex_property where fflexfield = ?";
        SqlParameter parameter = new SqlParameter("fflexfield", 12, (Object)propertyId);
        String viewFieldType = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{parameter}, resultSet -> {
            while (resultSet.next()) {
                String dis = resultSet.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)dis)) continue;
                Map dispMap = (Map)SerializationUtils.fromJsonString((String)dis, Map.class);
                Map map = dispMap.getOrDefault("disp", new HashMap(0));
                String dispprop = map.getOrDefault("dispprop", "2");
                return dispprop;
            }
            return "2";
        });
        return viewFieldType;
    }

    private String getViewText(String ... params) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < params.length; ++index) {
            String param = params[index];
            if (index == params.length - 1) {
                builder.append(param);
                break;
            }
            builder.append(param).append("\uff0c");
        }
        return builder.toString();
    }
}

