/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.formula.excel.UDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import kd.bos.print.core.service.I18nService;
import kd.bos.print.service.provider.I18nServiceProvider;

public abstract class AbstractPrintFormulaParser {
    private static final Log log = LogFactory.getLog(AbstractPrintFormulaParser.class);
    private static final int MIN_FUN_LENGTH = 2;
    private static final char D_QUOTES = '\"';
    private static final char S_QUOTES = '\'';
    private static final char LEFT_CHAR = '(';
    private static final char RIGHT_CHAR = ')';
    private static final char BLANK_SPACE = ' ';
    private static final String LEFT_STR = "(";
    private static final String RIGHT_STR = ")";
    private static final String UNDERLINE = "_";
    protected static final String COMMA_STR = ",";
    private static final char[] OPERATE_SYMBOL = new char[]{'+', '-', '*', '/', '>', '<', '=', '!'};
    protected static final String ENTER = "_enter_";
    protected static final String DATE_TO_CHAR = "TO_CHAR";
    protected UDFunction[] udFunctions = new UDFunction[]{NUMBER_UPPER_FUN};
    private static final char[][][] FUN_TABLES = new char[][][]{new char[][]{{'n', 'i', 'm', '1'}, {'n', 'e', 'l', '0'}, {'n', 'w', 'o', 'd', 'd', 'n', 'u', 'o', 'r', '0'}}, new char[][]{{'x', 'a', 'm', '1'}}, new char[][]{{'t', 'n', 'u', 'o', 'c', '1'}, {'t', 'f', 'e', 'l', '0'}, {'t', 'h', 'g', 'i', 'r', '0'}, {'t', 'a', 'c', 'n', 'o', 'c', '0'}, {'t', 'p', 'e', 'r', '0'}, {'t', 'n', 'i', '0'}}, new char[][]{{'m', 'u', 's', '1'}, {'m', 'i', 'r', 't', '0'}}, new char[][]{{'g', 'v', 'a', '1'}, {'g', 'n', 'i', 'r', 't', 's', 'b', 'u', 's', '0'}, {'g', 'n', 'i', 'r', 't', 's', '0'}}, new char[][]{{'f', 'i', '0'}, {'f', 'i', 'd', 'e', 't', 'a', 'd', '0'}}, new char[][]{{'d', 'n', 'i', 'f', '0'}, {'d', 'n', 'u', 'o', 'r', '0'}}, new char[][]{{'e', 't', 'u', 't', 'i', 't', 's', 'b', 'u', 's', '0'}, {'e', 'c', 'a', 'l', 'p', 'e', 'r', '0'}, {'e', 't', 'a', 'd', '0'}}, new char[][]{{'w', 'o', 'n', '0'}}, new char[][]{{'k', 'e', 'e', 'w', '0'}}, new char[][]{{'p', 'u', 'd', 'n', 'u', 'o', 'r', '0'}}, new char[][]{{'s', 'b', 'a', '0'}}, new char[][]{{'y', 'a', 'd', '0'}}, new char[][]{{'h', 't', 'n', 'o', 'm', '0'}}, new char[][]{{'r', 'a', 'e', 'y', '0'}, {'r', 'e', 'w', 'o', 'l', '0'}, {'r', 'e', 'p', 'p', 'u', 'r', 'e', 'b', 'm', 'u', 'n', '0'}, {'r', 'e', 'p', 'p', 'u', '0'}, {'r', 'e', 't', 'r', 'a', 'u', 'q', '0'}, {'r', 'a', 'h', 'c', '_', 'o', 't', '0'}, {'r', 'e', 'b', 'm', 'u', 'n', '_', 'o', 't', '_', 'y', 't', 'p', 'm', 'e', '0'}}};
    private static final char[] FUN_KEYWORD = new char[FUN_TABLES.length];
    protected static final int TYPE_ZH = 1;
    protected static final int TYPE_EN = 2;
    static final UDFunction NUMBER_UPPER_FUN;

    public String executeExp(List<Object> expressions) {
        if (CollectionUtils.isEmpty(expressions)) {
            return "";
        }
        LinkedHashMap<String, Object> variableMap = new LinkedHashMap<String, Object>(16);
        ArrayList<String> formulas = new ArrayList<String>(10);
        int v = 1;
        StringBuilder exp = new StringBuilder();
        LinkedList<FunctionInfo> funStack = new LinkedList<FunctionInfo>();
        LinkedList<Character> quotesStack = new LinkedList<Character>();
        block2: for (int index = 0; index < expressions.size(); ++index) {
            Object expression = expressions.get(index);
            if (expression instanceof Map) {
                this.beforeFieldExp(funStack, index, expressions);
                Map fieldItem = (Map)expression;
                String dataSource = String.valueOf(fieldItem.get("dataSource"));
                String variable = this.getBindFiled(fieldItem, dataSource);
                String textFormat = String.valueOf(fieldItem.get("textFormat"));
                Object fieldValue = this.getVariableValue(fieldItem, funStack);
                if (fieldValue instanceof List) {
                    List fieldValues = (List)fieldValue;
                    if (funStack.isEmpty() && fieldValues.size() > 0) {
                        exp.append(LEFT_STR);
                    }
                    for (int i = 0; i < fieldValues.size(); ++i) {
                        StringBuilder entryVar = new StringBuilder(variable);
                        if (variableMap.containsKey(variable)) {
                            entryVar.append(UNDERLINE).append(v++);
                        }
                        exp.append((CharSequence)entryVar);
                        variableMap.put(entryVar.toString(), this.transferVariableValue(fieldValues.get(i), dataSource, textFormat, this.currentFunctionName(funStack)));
                        if (i < fieldValues.size() - 1 && this.isGather(funStack)) {
                            exp.append(COMMA_STR);
                        }
                        if (funStack.isEmpty()) {
                            exp.append(RIGHT_STR);
                        }
                        formulas.add(exp.toString());
                        exp.setLength(0);
                        if (!this.isGather(funStack)) continue block2;
                    }
                    continue;
                }
                if (funStack.isEmpty()) {
                    exp.append(LEFT_STR);
                }
                if (variableMap.containsKey(variable)) {
                    variable = variable + UNDERLINE + v++;
                }
                exp.append(variable);
                variableMap.put(variable, this.transferVariableValue(fieldValue, dataSource, textFormat, this.currentFunctionName(funStack)));
                if (funStack.isEmpty()) {
                    exp.append(RIGHT_STR);
                }
                formulas.add(exp.toString());
                exp.setLength(0);
                continue;
            }
            this.literalExp(expressions, formulas, funStack, quotesStack, index, expression);
        }
        ArrayList<String> functions = new ArrayList(formulas.size());
        try {
            functions = this.splitFunctions(String.join((CharSequence)"", formulas));
        }
        catch (Exception e) {
            this.splitExceptionProcess();
        }
        StringBuilder result = this.executeFormulaCalculate(functions, variableMap);
        variableMap.clear();
        return result.toString();
    }

    protected void beforeFieldExp(Deque<FunctionInfo> funStack, int index, List<Object> expressions) {
    }

    private void literalExp(List<Object> expressions, List<String> formulas, Deque<FunctionInfo> funStack, Deque<Character> quotesStack, int index, Object expression) {
        String literalExp = this.trim(new StringBuilder(expression.toString()));
        this.beforeLiteralExp(funStack, literalExp, index, expressions);
        StringBuilder liter = new StringBuilder();
        if (!(!ENTER.equals(expression) || funStack.isEmpty() && quotesStack.isEmpty())) {
            return;
        }
        for (char c : literalExp.toCharArray()) {
            liter.append(c);
            if (c == '(') {
                char[] funChars = this.parseFunctionChars(liter.toString());
                if (funChars.length > 0) {
                    FunctionInfo functionInfo = new FunctionInfo(this.getFunctionName(funChars), this.isGatherFun(funChars));
                    funStack.push(functionInfo);
                }
                formulas.add(liter.toString());
                liter.setLength(0);
                continue;
            }
            if (c == ')') {
                if (!quotesStack.isEmpty() || funStack.isEmpty()) continue;
                funStack.pop();
                continue;
            }
            if (c != '\'' && c != '\"') continue;
            if (!quotesStack.isEmpty() && quotesStack.peek().charValue() == c) {
                quotesStack.pop();
                continue;
            }
            quotesStack.push(Character.valueOf(c));
        }
        if (liter.length() > 0) {
            formulas.add(liter.toString());
        }
    }

    protected void beforeLiteralExp(Deque<FunctionInfo> funStack, String literalExp, int index, List<Object> expressions) {
    }

    protected void splitExceptionProcess() {
    }

    protected boolean isGather(Deque<FunctionInfo> funStack) {
        return !funStack.isEmpty() && funStack.peek().gather;
    }

    private String currentFunctionName(Deque<FunctionInfo> funStack) {
        return funStack.peek() == null ? "" : funStack.peek().name;
    }

    private String getBindFiled(Map fieldItem, String dataSource) {
        String variable = String.valueOf(fieldItem.get("bindField"));
        if (StringUtil.equals((String)dataSource, (String)"$DsKey=[System]") && (variable.contains("=") || variable.contains(LEFT_STR) || variable.contains(RIGHT_STR))) {
            variable = variable.replace("=", "").replace(LEFT_STR, "").replace(RIGHT_STR, "");
        }
        return variable;
    }

    protected abstract Object getVariableValue(Map var1, Deque<FunctionInfo> var2);

    protected abstract Object transferVariableValue(Object var1, String var2, String var3, String var4);

    protected abstract StringBuilder executeFormulaCalculate(List<String> var1, Map<String, Object> var2);

    private String trim(StringBuilder expression) {
        Stack<Character> inQuote = new Stack<Character>();
        char[] chars = expression.toString().toCharArray();
        int offset = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'') {
                if (inQuote.isEmpty()) {
                    inQuote.push(Character.valueOf(chars[i]));
                } else if (((Character)inQuote.peek()).charValue() == '\'') {
                    inQuote.pop();
                }
            }
            if (chars[i] == '\"') {
                if (inQuote.isEmpty()) {
                    inQuote.push(Character.valueOf(chars[i]));
                } else if (((Character)inQuote.peek()).charValue() == '\"') {
                    inQuote.pop();
                }
            }
            if (chars[i] != ' ' || !inQuote.isEmpty()) continue;
            expression.deleteCharAt(i - offset);
            ++offset;
        }
        return expression.toString();
    }

    private char[] parseFunctionChars(String function) {
        if (function.length() < 2 || !Character.isLetter(function.charAt(0))) {
            return new char[0];
        }
        int firstIndex = -1;
        int dFirstIndex = function.indexOf(34);
        int sFirstIndex = function.indexOf(39);
        if (dFirstIndex != -1 && sFirstIndex != -1) {
            firstIndex = Math.min(dFirstIndex, sFirstIndex);
        } else if (dFirstIndex != -1) {
            firstIndex = dFirstIndex;
        } else if (sFirstIndex != -1) {
            firstIndex = sFirstIndex;
        }
        int lastIndex = Math.max(function.lastIndexOf(34), function.lastIndexOf(39));
        if (firstIndex != -1 && lastIndex != -1) {
            function = function.substring(0, firstIndex) + function.substring(lastIndex + 1);
        }
        char[] funChars = function.toCharArray();
        char[][] revFunChars = null;
        int f = 0;
        int w = 1;
        for (int i = funChars.length - 1; i >= 0; --i) {
            char c = Character.toLowerCase(funChars[i]);
            int index = this.charToIndex(c);
            if (revFunChars != null) {
                int startIndex = i;
                while (f < revFunChars.length) {
                    boolean match = true;
                    while (w < revFunChars[f].length - 1 && i >= 0) {
                        c = Character.toLowerCase(funChars[i]);
                        if (c != revFunChars[f][w++]) {
                            match = false;
                            break;
                        }
                        --i;
                    }
                    if (match) {
                        return revFunChars[f];
                    }
                    i = startIndex;
                    w = 1;
                    ++f;
                }
                i = startIndex;
                w = 1;
                f = 0;
                revFunChars = null;
                continue;
            }
            if (index < 0 || index >= FUN_TABLES.length) continue;
            revFunChars = FUN_TABLES[index];
        }
        return new char[0];
    }

    private String getFunctionName(char[] funChars) {
        if (funChars == null || funChars.length <= 1) {
            return "";
        }
        StringBuilder funStr = new StringBuilder();
        for (int i = funChars.length - 2; i >= 0; --i) {
            funStr.append(Character.toUpperCase(funChars[i]));
        }
        return funStr.toString();
    }

    private boolean isGatherFun(char[] funChars) {
        if (funChars == null || funChars.length <= 0) {
            return false;
        }
        return funChars[funChars.length - 1] == '1';
    }

    private int charToIndex(char c) {
        for (int i = 0; i < FUN_KEYWORD.length; ++i) {
            if (FUN_KEYWORD[i] != c) continue;
            return i;
        }
        return -1;
    }

    private List<String> splitFunctions(String function) {
        char[] chars;
        ArrayList<String> result = new ArrayList<String>(10);
        StringBuilder splitFun = new StringBuilder();
        LinkedList<Character> breakStack = new LinkedList<Character>();
        LinkedList<Character> quotesStack = new LinkedList<Character>();
        for (char c : chars = function.toCharArray()) {
            if (c != '\"' && c != '\'') {
                splitFun.append(c);
            }
            if (ENTER.equals(splitFun.toString())) {
                this.formulaEndRight(result, splitFun);
            }
            if (c == '(') {
                if (!breakStack.isEmpty() && ((Character)breakStack.peek()).charValue() != '(') continue;
                breakStack.push(Character.valueOf(c));
                continue;
            }
            if (quotesStack.isEmpty() && c == ')') {
                if (breakStack.isEmpty() || ((Character)breakStack.peek()).charValue() == '(') {
                    breakStack.pop();
                }
                if (!breakStack.isEmpty()) continue;
                this.formulaEndRight(result, splitFun);
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (!quotesStack.isEmpty() && ((Character)quotesStack.peek()).charValue() == c) {
                quotesStack.pop();
            } else {
                quotesStack.push(Character.valueOf(c));
            }
            if (!breakStack.isEmpty()) {
                if (((Character)breakStack.peek()).charValue() == c) {
                    splitFun.append(c);
                    breakStack.pop();
                    if (!breakStack.isEmpty()) continue;
                    this.formulaEndRight(result, splitFun);
                    continue;
                }
                splitFun.append(c);
                continue;
            }
            breakStack.push(Character.valueOf(c));
            this.formulaEndLeft(result, splitFun);
            splitFun.append(c);
        }
        this.formulaEndRight(result, splitFun);
        return result;
    }

    private void formulaEndRight(List<String> result, StringBuilder newFunction) {
        if (StringUtils.isBlank((CharSequence)newFunction)) {
            return;
        }
        if (result.size() > 0 && ArrayUtils.contains((char[])OPERATE_SYMBOL, (char)newFunction.charAt(0))) {
            int lastIndex = result.size() - 1;
            result.set(lastIndex, result.get(lastIndex) + newFunction);
        } else {
            result.add(newFunction.toString());
        }
        newFunction.setLength(0);
    }

    private void formulaEndLeft(List<String> result, StringBuilder newFunction) {
        if (StringUtils.isBlank((CharSequence)newFunction)) {
            return;
        }
        if (result.size() > 0 && ArrayUtils.contains((char[])OPERATE_SYMBOL, (char)newFunction.charAt(0))) {
            return;
        }
        result.add(newFunction.toString());
        newFunction.setLength(0);
    }

    static {
        for (int i = 0; i < FUN_TABLES.length; ++i) {
            AbstractPrintFormulaParser.FUN_KEYWORD[i] = FUN_TABLES[i][0][0];
        }
        NUMBER_UPPER_FUN = new UDFunction(){

            public String getName() {
                return "NUMBERUPPER";
            }

            public Object call(Object ... objects) {
                if (objects.length != 3) {
                    throw new KDBizException(ResManager.loadKDString((String)"NUMBERUPPER\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aNUMBERUPPER(<\u6570\u5b57>,<\u8d27\u5e01\u7b26\u53f7>,<\u91d1\u989d\u5927\u5199\u7684\u7c7b\u578b>)\u3002", (String)"AbstractPrintFormulaParser_1", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (!(objects[0] instanceof Number)) {
                    throw new KDBizException(ResManager.loadKDString((String)"NUMBERUPPER\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57\u3002", (String)"AbstractPrintFormulaParser_2", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (!(objects[1] instanceof String)) {
                    throw new KDBizException(ResManager.loadKDString((String)"NUMBERUPPER\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5b57\u7b26\u4e32\u3002", (String)"AbstractPrintFormulaParser_3", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (!(objects[2] instanceof Number)) {
                    throw new KDBizException(ResManager.loadKDString((String)"NUMBERUPPER\u51fd\u6570\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57\u3002", (String)"AbstractPrintFormulaParser_4", (String)"bos-print-service", (Object[])new Object[0]));
                }
                String amount = objects[0] instanceof BigDecimal ? ((BigDecimal)objects[0]).toPlainString() : ((Number)objects[0]).toString();
                String currencyCode = (String)objects[1];
                int type = (Integer)objects[2];
                I18nService i18nService = I18nServiceProvider.getProvider();
                try {
                    if (type == 1) {
                        if (StringUtils.isBlank((CharSequence)currencyCode)) {
                            Locale locale = Locale.forLanguageTag(ExecuteContext.get().getLang());
                            Locale localeLang = Locale.SIMPLIFIED_CHINESE;
                            if (locale != null) {
                                localeLang = locale;
                            }
                            return CurrencyFormatManager.shareInstance().upperFomat(currencyCode, localeLang, new Variant((Object)amount), false);
                        }
                        return i18nService.amountConvertZhUppercase(false, currencyCode, currencyCode, amount);
                    }
                    if (type == 2) {
                        return i18nService.amountConvertEnUppercase(false, currencyCode, amount);
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"NUMBERUPPER\u51fd\u6570\u4e0d\u652f\u6301\u3010type=%s\u3011\u7c7b\u578b\u7684\u8f6c\u6362\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractPrintFormulaParser_0", (String)"bos-print-service", (Object[])new Object[0]), type));
                }
                catch (Exception e) {
                    ErrorCode errorCode = new ErrorCode("print-exception", e.getMessage());
                    throw new KDException((Throwable)e, errorCode, new Object[0]);
                }
            }
        };
    }

    static class FunctionInfo {
        private String name;
        private boolean gather;

        FunctionInfo(String name, boolean gather) {
            this.name = name;
            this.gather = gather;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isGather() {
            return this.gather;
        }

        public void setGather(boolean gather) {
            this.gather = gather;
        }
    }
}

