/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

public enum EmOperator {
    ADD("+", 2, 1),
    SUB("-", 2, 1),
    MULTIPLY("*", 2, 2),
    DIVIDE("/", 2, 2),
    MAX("max", 3, 3),
    MIN("min", 3, 3),
    COUNT("count", 3, 3),
    SUM("sum", 3, 3),
    AVG("avg", 3, 3),
    LEFT_BRACKET("(", 0, Integer.MAX_VALUE),
    RIGHT_BRACKET(")", 0, Integer.MAX_VALUE);

    private String expression;
    private int paramNumber;
    private int priority;

    private EmOperator(String expression, int paramNumber, int priority) {
        this.expression = expression;
        this.paramNumber = paramNumber;
        this.priority = priority;
    }

    public static boolean isSimpleOperator(String expression) {
        return EmOperator.ADD.expression.equals(expression) || EmOperator.SUB.expression.equals(expression) || EmOperator.LEFT_BRACKET.expression.equals(expression) || EmOperator.RIGHT_BRACKET.expression.equals(expression) || EmOperator.MULTIPLY.expression.equals(expression) || EmOperator.DIVIDE.expression.equals(expression);
    }

    public static EmOperator getByExpression(String expression) {
        for (EmOperator operator : EmOperator.values()) {
            if (!operator.expression.equals(expression)) continue;
            return operator;
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getParamNumber() {
        return this.paramNumber;
    }

    public int getPriority() {
        return this.priority;
    }
}

