/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.data.field.DateField;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.service.formula.NumericalCalValidate;
import kd.bos.print.service.formula.PrintFormulaValidate;

@Deprecated
public class FormulaParseValue {
    private static final String FORMULA_SPECIAL = "FormulaSpecial_";
    private static final Log log = LogFactory.getLog(FormulaParseValue.class);
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private static final String DEF_TEXT_200_CHARS = "texttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttext";
    private static final String IDX_OUTOFRANGE_WARNING_CODE = "SYS.cts.WARNING_001";
    private static final String IDX_OUTOFRANGE_DATE_WARNING_CODE = "SYS.cts.DATE_WARNING_001";
    private Map<String, Object> ctx = new HashMap<String, Object>();

    public String parseExp(List<Object> expression) {
        List<Object> newExp = expression;
        ArrayList<Object> fieldList = new ArrayList<Object>();
        StringBuilder sbAfterReplace = this.replaceField2SpecialChar(false, newExp, fieldList);
        String exp = this.replaceQuotesInParentheses(sbAfterReplace.toString(), fieldList);
        return this.parseNewExp(exp);
    }

    private String replaceQuotesInParentheses(String s, List<Object> fieldList) {
        char[] c = s.toCharArray();
        int n = c.length;
        StringBuilder sbInIfFunction = new StringBuilder();
        String rgex = "if(.*?)\\)";
        Pattern p = Pattern.compile(rgex);
        Matcher mat = p.matcher(s);
        block0: while (mat.find()) {
            String matStr = mat.group();
            sbInIfFunction.append(matStr);
            Matcher matLeftBracket = Pattern.compile("\\(").matcher(matStr);
            int matLeftBracketCount = 0;
            while (matLeftBracket.find()) {
                ++matLeftBracketCount;
            }
            Matcher matrightBracket = Pattern.compile("\\)").matcher(matStr);
            int matrightBracketCount = 0;
            while (matrightBracket.find()) {
                ++matrightBracketCount;
            }
            int count = matLeftBracketCount - matrightBracketCount;
            if (count <= 0) continue;
            for (int i = mat.end(); i < n; ++i) {
                if (c[i] != ')') {
                    sbInIfFunction.append(c[i]);
                    if (c[i] != '(') continue;
                    ++count;
                    continue;
                }
                sbInIfFunction.append(RIGHT_BRACKET);
                if (--count <= 0) continue block0;
            }
        }
        String[] strInIfFunctionArr = sbInIfFunction.toString().split("\u20ab");
        block4: for (int k = 0; k < strInIfFunctionArr.length; ++k) {
            String strInIfFunction = strInIfFunctionArr[k];
            int count = 0;
            int index = -1;
            if (!strInIfFunction.contains("\u03a7")) continue;
            for (int j = k + 1; j < strInIfFunctionArr.length; ++j) {
                String strInIfFunction1 = strInIfFunctionArr[j];
                if (strInIfFunction1.contains(RIGHT_BRACKET)) {
                    char[] strInIfFunction1CharArr = strInIfFunction1.toCharArray();
                    for (int l = 0; l < strInIfFunction1CharArr.length; ++l) {
                        if (strInIfFunction1CharArr[l] == ')') {
                            index = l;
                            break;
                        }
                        if (strInIfFunction1CharArr[l] != '(') continue;
                        ++count;
                    }
                } else {
                    Matcher m = Pattern.compile("\\(", 2).matcher(strInIfFunction1);
                    while (m.find()) {
                        ++count;
                    }
                }
                if (index == -1) continue;
                for (int l = k - 1; l >= 0; --l) {
                    String strInIfFunction2 = strInIfFunctionArr[l];
                    char[] strInIfFunction2CharArr = strInIfFunction2.toCharArray();
                    if (!strInIfFunction2.contains(LEFT_BRACKET)) continue;
                    for (int m = strInIfFunction2CharArr.length - 1; m >= 0; --m) {
                        if (strInIfFunction2CharArr[m] == ')') {
                            ++count;
                            continue;
                        }
                        if (strInIfFunction2CharArr[m] != '(') continue;
                        if (count == 0) {
                            int pos;
                            Map field;
                            Object value;
                            StringBuilder sb = new StringBuilder();
                            for (int m1 = m - 1; m1 >= 0; --m1) {
                                if (!Character.isLetter(strInIfFunction2CharArr[m1])) continue;
                                sb.insert(0, strInIfFunction2CharArr[m1]);
                                if (sb.length() == 2) break;
                            }
                            if ("if".equals(sb.toString()) && (value = (field = (Map)fieldList.get(pos = Integer.parseInt(strInIfFunction.substring(1)))).get("value")) instanceof List && !((List)value).isEmpty()) {
                                field.put("value", ((List)value).get(0));
                                fieldList.set(pos, field);
                            }
                        }
                        --count;
                    }
                }
                continue block4;
            }
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<String> leftBracket = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            if (c[i] != '(') {
                sb.append(c[i]);
                continue;
            }
            leftBracket.add(LEFT_BRACKET);
            sb.append(LEFT_BRACKET);
            StringBuilder newSb = this.replaceValueNotInBracket(sb.toString(), fieldList, new StringBuilder());
            StringBuilder stringbuilder = new StringBuilder();
            i = this.recordAllLeftBracket(c, leftBracket, i, stringbuilder);
            sb = this.replaceValueInBracket(stringbuilder.toString(), fieldList, newSb);
        }
        return this.replaceValueNotInBracket(sb.toString(), fieldList, new StringBuilder()).toString();
    }

    private StringBuilder replaceValueNotInBracket(String s, List<Object> fieldList, StringBuilder sb) {
        String[] sbSplit;
        for (String str : sbSplit = s.split("\u20ab")) {
            if (str.contains("\u03a7")) {
                List v;
                Map field = (Map)fieldList.get(Integer.parseInt(str.substring(1)));
                String tf = (String)field.get("textFormat");
                String bf = (String)field.get("bindField");
                String ds = (String)field.get("dataSource");
                if (StringUtil.equals((String)ds, (String)"$DsKey=[System]")) {
                    sb.append("\"").append(field.get("value")).append("\"");
                    continue;
                }
                if ("Number".equals(tf) || "Amount".equals(tf)) {
                    if (field.get("value") instanceof List) {
                        v = (List)field.get("value");
                        if (v.isEmpty()) continue;
                        if (!(v.get(0) instanceof NullField)) {
                            this.ctx.put(FORMULA_SPECIAL + bf + str.substring(1), this.toBigDecimal(v.get(0)));
                            sb.append(FORMULA_SPECIAL).append(bf).append(str.substring(1));
                            continue;
                        }
                        sb.append(0);
                        continue;
                    }
                    if (!(field.get("value") instanceof NullField)) {
                        this.ctx.put(FORMULA_SPECIAL + bf + str.substring(1), this.toBigDecimal(field.get("value")));
                        sb.append(FORMULA_SPECIAL).append(bf).append(str.substring(1));
                        continue;
                    }
                    sb.append(0);
                    continue;
                }
                if ("Date".equals(tf)) {
                    Object value = field.get("value");
                    if (value instanceof List) {
                        List v2 = (List)field.get("value");
                        value = !v2.isEmpty() ? v2.get(0) : "";
                    }
                    sb.append("\"").append(value).append("\"");
                    continue;
                }
                if (field.get("value") instanceof List) {
                    v = (List)field.get("value");
                    if (v.isEmpty()) continue;
                    sb.append("\"").append(v.get(0).toString()).append("\"");
                    continue;
                }
                if (field.get("value") instanceof NullField) continue;
                sb.append("\"").append(field.get("value")).append("\"");
                continue;
            }
            sb.append(str);
        }
        return sb;
    }

    private StringBuilder replaceValueInBracket(String s, List<Object> fieldList, StringBuilder newSb) {
        String[] stringSplit;
        for (String str : stringSplit = s.replace("\"", "'").split("\u20ab")) {
            if (str.contains("\u03a7")) {
                int j;
                List v;
                Map field = (Map)fieldList.get(Integer.parseInt(str.substring(1)));
                String tf = (String)field.get("textFormat");
                String bf = (String)field.get("bindField");
                Object value = field.get("value");
                if ("Number".equals(tf) || "Amount".equals(tf)) {
                    if (value instanceof List) {
                        v = (List)value;
                        if (v.isEmpty()) {
                            newSb.append(0);
                            continue;
                        }
                        for (j = 0; j < v.size(); ++j) {
                            if (!(v.get(j) instanceof NullField)) {
                                this.ctx.put(bf + str.substring(1) + "_" + j, this.toBigDecimal(v.get(j)));
                            } else {
                                this.ctx.put(bf + str.substring(1) + "_" + j, BigDecimal.ZERO);
                            }
                            newSb.append(bf).append(str.substring(1)).append("_").append(j);
                            if (j >= v.size() - 1) continue;
                            newSb.append(",");
                        }
                        continue;
                    }
                    if (value != null && !(value instanceof NullField)) {
                        try {
                            this.ctx.put(bf + str.substring(1), this.toBigDecimal(value));
                            newSb.append(bf).append(str.substring(1));
                        }
                        catch (Exception e) {
                            log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38:" + value.toString());
                        }
                        continue;
                    }
                    newSb.append(0);
                    continue;
                }
                if ("Date".equals(tf)) {
                    if (value instanceof List) {
                        v = (List)value;
                        for (j = 0; j < v.size(); ++j) {
                            if (newSb.toString().endsWith("Year(") || newSb.toString().endsWith("MONTH(") || newSb.toString().endsWith("DAY(")) {
                                this.ctx.put(bf + str.substring(1) + "_" + j, this.toDate(v.get(j), true));
                            } else {
                                this.ctx.put(bf + str.substring(1) + "_" + j, this.toDate(v.get(j), false));
                            }
                            newSb.append(bf).append(str.substring(1)).append("_").append(j);
                            if (j >= v.size() - 1) continue;
                            newSb.append(",");
                        }
                        continue;
                    }
                    newSb.append("'").append(value).append("'");
                    continue;
                }
                if (value instanceof List) {
                    v = (List)value;
                    for (j = 0; j < v.size(); ++j) {
                        this.ctx.put(bf + str.substring(1) + "_" + j, v.get(j));
                        newSb.append(bf).append(str.substring(1)).append("_").append(j);
                        if (j >= v.size() - 1) continue;
                        newSb.append(",");
                    }
                    continue;
                }
                newSb.append("'").append(value).append("'");
                continue;
            }
            newSb.append(str);
        }
        return newSb;
    }

    private String toDate(Object field, Boolean userDateFunc) {
        SimpleDateFormat sdf;
        String displayVal = null;
        Timestamp timestamp = null;
        Date date = null;
        if (field instanceof String) {
            return (String)field;
        }
        if (field instanceof DateTimeField) {
            DateTimeField dateTimeField = (DateTimeField)field;
            displayVal = dateTimeField.getDisplayVal();
            timestamp = (Timestamp)dateTimeField.getValue();
        } else if (field instanceof DateField) {
            DateField dateField = (DateField)field;
            displayVal = dateField.getDisplayVal();
            date = (Date)dateField.getValue();
        }
        if (!userDateFunc.booleanValue() && null != displayVal) {
            return displayVal;
        }
        if (timestamp != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(timestamp.getTime()));
        }
        if (date != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(date);
        }
        return null;
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)value;
            BigDecimal bigDecimal = ((DecimalField)value).getValue();
            value = bigDecimal.setScale(decimalField.getScale(), 4);
        } else if (value instanceof Field) {
            value = ((Field)value).getValue();
        }
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            ret = new BigDecimal(((String)value).trim());
        } else if (value instanceof Integer) {
            ret = new BigDecimal((Integer)value);
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Long) {
            ret = new BigDecimal((Long)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }

    private String parseNewExp(String newExp) {
        List<String> expList = this.getExpStrings(newExp);
        StringBuilder newStr = new StringBuilder();
        for (String str : expList) {
            if ((str = str.trim()).startsWith("\"") && str.endsWith("\"")) {
                if (str.length() > 1) {
                    str = str.substring(1, str.length() - 1);
                }
                newStr.append(str);
                continue;
            }
            try {
                if (str.startsWith("min") || str.startsWith("max") || str.startsWith("count") || str.startsWith("sum") || str.startsWith("avg") || str.startsWith("if") || str.startsWith("DAY") || str.startsWith("MONTH") || str.startsWith("YEAR") || str.contains("+") && !str.equals("+") || str.contains("-") && !str.equals("-") || str.contains("*") && !str.equals("*") || str.contains("/") && !str.equals("/") || str.contains(">") && !str.equals(">") || str.contains("<") && !str.equals("<") || str.contains("=") && !str.equals("=") || this.ctx.containsKey(str) || str.startsWith("LEFT") || str.startsWith("RIGHT") || str.startsWith("SUBSTRING") || str.startsWith("STRING") || str.contains("CONCAT")) {
                    Object value = FormulaEngine.execExcelFormula((String)str, this.ctx);
                    str = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
                }
            }
            catch (Exception e) {
                str = "";
                log.warn("\u5f15\u64ce\u8fdb\u884c\u8ba1\u7b97\u6709\u7279\u6b8a\u60c5\u51b5\uff1a" + e.toString());
            }
            if (str.contains(FORMULA_SPECIAL)) {
                String[] sArr;
                for (String s : sArr = str.split(FORMULA_SPECIAL)) {
                    String ns = FORMULA_SPECIAL + s;
                    if (!this.ctx.containsKey(ns.trim())) continue;
                    Object value = this.ctx.get(ns.trim());
                    if (value instanceof BigDecimal) {
                        newStr.append(((BigDecimal)value).toPlainString());
                        continue;
                    }
                    newStr.append(value);
                }
                continue;
            }
            newStr.append(str);
        }
        return newStr.toString();
    }

    public String validateExp(List<Object> expression) {
        List<Object> newExp = expression;
        ArrayList<Object> fieldList = new ArrayList<Object>();
        StringBuilder sbAfterReplace = this.replaceField2SpecialChar(true, newExp, fieldList);
        String exp = this.replaceQuotesInParenthesesForValidate(sbAfterReplace.toString(), fieldList);
        return this.validateNewExp(exp);
    }

    private List<String> getExpStrings(String exp) {
        ArrayList<String> expList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char c : exp.toCharArray()) {
            if (c == '\"') {
                if (builder.length() == 0) {
                    builder.append(c);
                    continue;
                }
                if (builder.charAt(0) == '\"') {
                    builder.append(c);
                    expList.add(builder.toString());
                    builder.setLength(0);
                    continue;
                }
                expList.add(builder.toString());
                builder.setLength(0);
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            expList.add(builder.toString());
        }
        return expList;
    }

    private String replaceQuotesInParenthesesForValidate(String s, List<Object> fieldList) {
        char[] c = s.toCharArray();
        int n = c.length;
        StringBuilder sbInIfFunction = new StringBuilder();
        String rgex = "if(.*?)\\)";
        Pattern p = Pattern.compile(rgex);
        Matcher mat = p.matcher(s);
        block0: while (mat.find()) {
            String matStr = mat.group();
            sbInIfFunction.append(matStr);
            Matcher matLeftBracket = Pattern.compile("\\(").matcher(matStr);
            int matLeftBracketCount = 0;
            while (matLeftBracket.find()) {
                ++matLeftBracketCount;
            }
            Matcher matrightBracket = Pattern.compile("\\)").matcher(matStr);
            int matrightBracketCount = 0;
            while (matrightBracket.find()) {
                ++matrightBracketCount;
            }
            int count = matLeftBracketCount - matrightBracketCount;
            if (count <= 0) continue;
            for (int i = mat.end(); i < n; ++i) {
                if (c[i] != ')') {
                    sbInIfFunction.append(c[i]);
                    if (c[i] != '(') continue;
                    ++count;
                    continue;
                }
                sbInIfFunction.append(RIGHT_BRACKET);
                if (--count <= 0) continue block0;
            }
        }
        String[] strInIfFunctionArr = sbInIfFunction.toString().split("\u20ab");
        block4: for (int k = 0; k < strInIfFunctionArr.length; ++k) {
            String strInIfFunction = strInIfFunctionArr[k];
            int count = 0;
            int index = -1;
            if (!strInIfFunction.contains("\u03a7")) continue;
            for (int j = k + 1; j < strInIfFunctionArr.length; ++j) {
                String strInIfFunction1 = strInIfFunctionArr[j];
                if (strInIfFunction1.contains(RIGHT_BRACKET)) {
                    char[] strInIfFunction1CharArr = strInIfFunction1.toCharArray();
                    for (int l = 0; l < strInIfFunction1CharArr.length; ++l) {
                        if (strInIfFunction1CharArr[l] == ')') {
                            index = l;
                            break;
                        }
                        if (strInIfFunction1CharArr[l] != '(') continue;
                        ++count;
                    }
                } else {
                    Matcher m = Pattern.compile("\\(", 2).matcher(strInIfFunction1);
                    while (m.find()) {
                        ++count;
                    }
                }
                if (index == -1) continue;
                for (int l = k - 1; l >= 0; --l) {
                    String strInIfFunction2 = strInIfFunctionArr[l];
                    char[] strInIfFunction2CharArr = strInIfFunction2.toCharArray();
                    if (!strInIfFunction2.contains(LEFT_BRACKET)) continue;
                    for (int m = strInIfFunction2CharArr.length - 1; m >= 0; --m) {
                        if (strInIfFunction2CharArr[m] == ')') {
                            ++count;
                            continue;
                        }
                        if (strInIfFunction2CharArr[m] != '(') continue;
                        if (count == 0) {
                            Object value;
                            int pos;
                            Map field;
                            String tf;
                            StringBuilder sb = new StringBuilder();
                            for (int m1 = m - 1; m1 >= 0; --m1) {
                                if (!Character.isLetter(strInIfFunction2CharArr[m1])) continue;
                                sb.insert(0, strInIfFunction2CharArr[m1]);
                                if (sb.length() == 2) break;
                            }
                            if ("if".equals(sb.toString()) && ("Number".equals(tf = (String)(field = (Map)fieldList.get(pos = Integer.parseInt(strInIfFunction.substring(1)))).get("textFormat")) || "Amount".equals(tf)) && (value = field.get("value")) instanceof List && !((List)value).isEmpty()) {
                                field.put("value", ((List)value).get(0));
                                fieldList.set(pos, field);
                            }
                        }
                        --count;
                    }
                }
                continue block4;
            }
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<String> leftBracket = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            if (c[i] != '(') {
                sb.append(c[i]);
                continue;
            }
            leftBracket.add(LEFT_BRACKET);
            sb.append(LEFT_BRACKET);
            StringBuilder newSb = this.replaceValueNotInBracketForValidate(sb.toString(), fieldList, new StringBuilder());
            StringBuilder stringbuilder = new StringBuilder();
            i = this.recordAllLeftBracket(c, leftBracket, i, stringbuilder);
            sb = this.replaceValueInBracketForValidate(stringbuilder.toString(), fieldList, newSb);
        }
        return this.replaceValueNotInBracketForValidate(sb.toString(), fieldList, new StringBuilder()).toString();
    }

    private StringBuilder replaceValueNotInBracketForValidate(String s, List<Object> fieldList, StringBuilder sb) {
        String[] sbSplit;
        for (String str : sbSplit = s.split("\u20ab")) {
            if (str.contains("\u03a7")) {
                Map field = (Map)fieldList.get(Integer.parseInt(str.substring(1)));
                String tf = (String)field.get("textFormat");
                if ("Number".equals(tf) || "Amount".equals(tf)) {
                    if (field.get("value") instanceof List) {
                        List v = (List)field.get("value");
                        if (v.isEmpty()) continue;
                        if (!(v.get(0) instanceof NullField)) {
                            sb.append(v.get(0));
                            continue;
                        }
                        sb.append(0);
                        continue;
                    }
                    if (!(field.get("value") instanceof NullField)) {
                        sb.append(field.get("value"));
                        continue;
                    }
                    sb.append(0);
                    continue;
                }
                if (field.get("value") instanceof NullField) continue;
                sb.append("\"").append(field.get("value")).append("\"");
                continue;
            }
            sb.append(str);
        }
        return sb;
    }

    private StringBuilder replaceValueInBracketForValidate(String s, List<Object> fieldList, StringBuilder newSb) {
        String[] stringSplit;
        for (String str : stringSplit = s.replace("\"", "'").split("\u20ab")) {
            if (str.contains("\u03a7")) {
                Map field = (Map)fieldList.get(Integer.parseInt(str.substring(1)));
                String tf = (String)field.get("textFormat");
                if ("Number".equals(tf) || "Amount".equals(tf)) {
                    if (field.get("value") instanceof List) {
                        List v = (List)field.get("value");
                        for (int j = 0; j < v.size(); ++j) {
                            if (j < v.size() - 1) {
                                if (!(v.get(j) instanceof NullField)) {
                                    newSb.append(v.get(j)).append(",");
                                    continue;
                                }
                                newSb.append(0);
                                continue;
                            }
                            if (!(v.get(j) instanceof NullField)) {
                                newSb.append(v.get(j));
                                continue;
                            }
                            newSb.append(0);
                        }
                        continue;
                    }
                    if (!(field.get("value") instanceof NullField)) {
                        newSb.append(field.get("value"));
                        continue;
                    }
                    newSb.append(0);
                    continue;
                }
                if (field.get("value") instanceof NullField) continue;
                newSb.append("'").append(field.get("value")).append("'");
                continue;
            }
            newSb.append(str);
        }
        return newSb;
    }

    private int recordAllLeftBracket(char[] c, Queue<String> leftBracket, int idx, StringBuilder stringbuilder) {
        while (!leftBracket.isEmpty() && ++idx < c.length) {
            if (c[idx] != ')') {
                if (c[idx] == '(') {
                    leftBracket.add(LEFT_BRACKET);
                }
                stringbuilder.append(c[idx]);
                continue;
            }
            stringbuilder.append(RIGHT_BRACKET);
            leftBracket.poll();
        }
        return idx;
    }

    private StringBuilder replaceField2SpecialChar(boolean validateFlag, List<Object> newExp, List<Object> fieldList) {
        StringBuilder s = new StringBuilder();
        for (Object obj : newExp) {
            if (obj instanceof Map) {
                if (validateFlag) {
                    this.initDefault4Validate((Map)obj);
                }
                fieldList.add(obj);
                s.append("\u20ab\u03a7").append(fieldList.size() - 1).append("\u20ab");
                continue;
            }
            s.append(obj);
        }
        return s;
    }

    private void initDefault4Validate(Map obj) {
        String tf = (String)obj.get("textFormat");
        if ("Number".equals(tf) || "Amount".equals(tf)) {
            obj.put("value", String.valueOf(Integer.MAX_VALUE));
        } else if ("Date".equals(tf)) {
            obj.put("value", "2018-08-08 01:02:03");
        } else if ("Time".equals(tf)) {
            obj.put("value", "01:02:03");
        } else {
            obj.put("value", DEF_TEXT_200_CHARS);
        }
    }

    private String validateNewExp(String exp) {
        List<String> expList = this.getExpStrings(exp);
        for (String ss : expList) {
            if (!StringUtils.isNotBlank((CharSequence)ss)) continue;
            ss = ss.trim();
            try {
                Object formulaValue;
                if (ss.startsWith("\"")) {
                    if (ss.length() > 1 && ss.endsWith("\"")) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\"\u65e0\u5339\u914d\u7b26\u3002", (String)"FormulaParseValue_3", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (!(!ss.startsWith("min(") && !ss.startsWith("max(") && !ss.startsWith("sum(") && !ss.startsWith("avg(") || ss.startsWith("DAY(") || ss.startsWith("MONTH(") || ss.startsWith("YEAR(") || ss.startsWith("if(") || ss.startsWith("count("))) {
                    ss = ss.replace(" ", "");
                    NumericalCalValidate.cal2Str(ss);
                    continue;
                }
                if (!(ss.contains("min") || ss.contains("max") || ss.contains("count") || ss.contains("sum") || ss.contains("avg") || ss.contains("if") || ss.contains("DAY") || ss.contains("MONTH") || ss.contains("YEAR") || ss.contains("+") && !ss.equals("+") || ss.contains("-") && !ss.equals("-") || ss.contains("*") && !ss.equals("*") || ss.contains("/") && !ss.equals("/") || ss.contains("LEFT") || ss.contains("RIGHT") || ss.contains("SUBSTRING") || ss.contains("STRING")) && !ss.contains("CONCAT") || (formulaValue = FormulaEngine.execExcelFormula((String)ss)) != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
            }
            catch (ClassCastException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570\u53c2\u6570\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\u51fd\u6570\u8bed\u6cd5\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"FormulaParseValue_1", (String)"bos-print-service", (Object[])new Object[0]));
            }
            catch (ArithmeticException e) {
                throw new KDBizException(e.toString());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg.contains("parse")) {
                    throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if ("0".equals(msg)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u53c2\u6570\u3002", (String)"FormulaParseValue_2", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (ss.contains("SUBSTRING") && null != e.getMessage() && e.getMessage().contains("String index out of range")) {
                    throw new KDBizException(new ErrorCode(IDX_OUTOFRANGE_WARNING_CODE, ResManager.loadKDString((String)"start_num\u8d77\u59cb\u4f4d\u7f6e\u7684\u503c\u8fc7\u5927\uff08\u7ed1\u5b9a\u5b57\u6bb5\u6700\u5927\u503c\u4e3a200\uff09\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (String)"FormulaParseValue_4", (String)"bos-print-service", (Object[])new Object[0])), null);
                }
                if ((ss.contains("YEAR") || ss.contains("DAY") || ss.contains("MONTH")) && null != e.getMessage() && (e.getMessage().contains("Illegal date string:") || e.getMessage().contains(ResManager.loadKDString((String)"\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FormulaParseValue_9", (String)"bos-print-service", (Object[])new Object[0])))) {
                    throw new KDBizException(new ErrorCode(IDX_OUTOFRANGE_DATE_WARNING_CODE, ResManager.loadKDString((String)"\u65f6\u95f4\u51fd\u6570\u53c2\u6570\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FormulaParseValue_5", (String)"bos-print-service", (Object[])new Object[0])), null);
                }
                throw new KDBizException(e.getMessage());
            }
        }
        return "";
    }
}

