/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.print.service.formula.EmOperator;
import kd.bos.print.service.formula.PrintFormulaValidate;

public class NumericalCalValidate {
    private static final char NEGATIVE_SIGN = '#';
    private static final char RADIX_POINT = '.';

    private NumericalCalValidate() {
        throw new IllegalStateException("Utility class");
    }

    public static BigDecimal cal(String expression) throws Exception {
        return NumericalCalValidate.privateCal(NumericalCalValidate.preProcess(expression), new Stack<EmOperator>(), new Stack<BigDecimal>());
    }

    public static String cal2Str(String expression) {
        try {
            return String.valueOf(NumericalCalValidate.cal(expression));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static BigDecimal privateCal(String expression, Stack<EmOperator> opStack, Stack<BigDecimal> dataStack) throws Exception {
        char[] charArr = expression.toCharArray();
        int length = charArr.length;
        int i = 0;
        while (i < length) {
            EmOperator curOp;
            char value = charArr[i];
            StringBuilder strBuilder = new StringBuilder();
            if (Character.isDigit(value) || '#' == value) {
                char next;
                strBuilder.append('#' == value ? "-" : Character.valueOf(value));
                while (++i < length && (Character.isDigit(next = charArr[i]) || '.' == next)) {
                    strBuilder.append(next);
                }
                try {
                    dataStack.push(new BigDecimal(strBuilder.toString()));
                    continue;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"NumericalCalValidate_6", (String)"bos-print-service", (Object[])new Object[0]));
                }
            }
            if (EmOperator.isSimpleOperator(String.valueOf(value))) {
                EmOperator stackOp;
                curOp = EmOperator.getByExpression(String.valueOf(value));
                if (EmOperator.RIGHT_BRACKET != curOp && (opStack.isEmpty() || EmOperator.LEFT_BRACKET == (stackOp = opStack.peek()) || stackOp.getPriority() < curOp.getPriority())) {
                    opStack.push(curOp);
                    ++i;
                    continue;
                }
                NumericalCalValidate.singleCal(opStack, dataStack);
                if (EmOperator.RIGHT_BRACKET != curOp) continue;
                while (EmOperator.LEFT_BRACKET != opStack.peek()) {
                    NumericalCalValidate.singleCal(opStack, dataStack);
                }
                if (EmOperator.LEFT_BRACKET != opStack.pop()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"NumericalCalValidate_5", (String)"bos-print-service", (Object[])new Object[0]));
                }
                ++i;
                continue;
            }
            if (Character.isLetter(value)) {
                while (i < length && Character.isLetter(charArr[i])) {
                    strBuilder.append(charArr[i]);
                    ++i;
                }
                curOp = EmOperator.getByExpression(strBuilder.toString());
                if (null == curOp) {
                    throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (charArr[i] != '(') {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570%1$s()\u8bed\u6cd5\u4e0d\u6b63\u786e\uff0c\u7f3a\u5c11\u2018('\u3002", (String)"NumericalCalValidate_4", (String)"bos-print-service", (Object[])new Object[]{curOp.toString().toLowerCase()}));
                }
                String temp = new String(charArr);
                int count = 1;
                int rightIndex = -1;
                for (int j = i + 1; j < charArr.length; ++j) {
                    if (charArr[j] == ')') {
                        if (count == 1) {
                            rightIndex = j;
                            break;
                        }
                        --count;
                    }
                    if (charArr[j] != '(') continue;
                    ++count;
                }
                if (rightIndex < 0 || rightIndex + 1 != temp.length() && temp.charAt(rightIndex + 1) != '+' && temp.charAt(rightIndex + 1) != '-' && temp.charAt(rightIndex + 1) != '/' && temp.charAt(rightIndex + 1) != '*') {
                    throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if ((temp = temp.substring(i + 1, rightIndex)).startsWith(",") || temp.endsWith(",")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4e2d\u662f\u5426\u5b58\u5728\u591a\u4f59\u7684\u9017\u53f7\uff0c(\u5982\u51fd\u6570(1,))\u3002", (String)"NumericalCalValidate_3", (String)"bos-print-service", (Object[])new Object[0]));
                }
                ArrayList<String> params = new ArrayList<String>(10);
                int splitIndex = 0;
                int existBracket = 0;
                for (int j = 0; j < temp.length(); ++j) {
                    if (temp.charAt(j) == ',' && existBracket == 0) {
                        params.add(temp.substring(splitIndex, j));
                        splitIndex = j + 1;
                    }
                    if (temp.charAt(j) == '(') {
                        ++existBracket;
                        continue;
                    }
                    if (temp.charAt(j) != ')') continue;
                    --existBracket;
                }
                if (splitIndex < temp.length()) {
                    params.add(temp.substring(splitIndex));
                }
                for (String param : params) {
                    try {
                        dataStack.push(NumericalCalValidate.cal(param));
                    }
                    catch (Exception e) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570%s()\u53c2\u6570\u9519\u8bef\uff1a\u53c2\u6570\u8981\u6c42\u662f\u3010\u7c7b\u578b\uff1a\u6570\u503c\u3011\u3002", (String)"NumericalCalValidate_2", (String)"bos-print-service", (Object[])new Object[0]), curOp.toString().toLowerCase()));
                    }
                }
                if (opStack.isEmpty() || opStack.peek().getPriority() < curOp.getPriority()) {
                    opStack.push(curOp);
                } else {
                    NumericalCalValidate.singleCal(opStack, dataStack);
                }
                i = rightIndex + 1;
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u5b57\u7b26\uff1a%s\u3002", (String)"NumericalCalValidate_7", (String)"bos-print-service", (Object[])new Object[]{Character.valueOf(value)}));
        }
        while (!opStack.isEmpty()) {
            NumericalCalValidate.singleCal(opStack, dataStack);
        }
        return dataStack.pop();
    }

    private static void singleCal(Stack<EmOperator> opStack, Stack<BigDecimal> dataStack) throws KDBizException {
        int i = dataStack.size();
        EmOperator op = opStack.peek();
        if (EmOperator.LEFT_BRACKET == op) {
            return;
        }
        opStack.pop();
        BigDecimal firstValue = new BigDecimal(0);
        BigDecimal secondValue = new BigDecimal(0);
        if (op.getParamNumber() == 1) {
            firstValue = dataStack.pop();
        } else if (!dataStack.isEmpty()) {
            secondValue = dataStack.pop();
            if (!dataStack.isEmpty()) {
                firstValue = dataStack.pop();
            }
        } else if (!"count".equals(op.getExpression())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570%s()\u81f3\u5c11\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u4f46\u4f20\u5165\u4e860\u4e2a\u53c2\u6570\u3002", (String)"NumericalCalValidate_1", (String)"bos-print-service", (Object[])new Object[0]), op.getExpression()));
        }
        BigDecimal result = null;
        switch (op) {
            case ADD: {
                result = firstValue.add(secondValue);
                break;
            }
            case SUB: {
                result = firstValue.subtract(secondValue);
                break;
            }
            case MULTIPLY: {
                result = firstValue.multiply(secondValue);
                break;
            }
            case DIVIDE: {
                result = firstValue.divide(secondValue);
                break;
            }
            case MIN: {
                if (!opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && i == 2) {
                    result = secondValue;
                    dataStack.push(firstValue);
                    break;
                }
                result = firstValue.min(secondValue);
                while (!(dataStack.isEmpty() || !opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && dataStack.size() == 1)) {
                    result = result.min(dataStack.pop());
                }
                break;
            }
            case MAX: {
                if (!opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && i == 2) {
                    result = secondValue;
                    dataStack.push(firstValue);
                    break;
                }
                result = firstValue.max(secondValue);
                while (!(dataStack.isEmpty() || !opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && dataStack.size() == 1)) {
                    result = result.max(dataStack.pop());
                }
                break;
            }
            case AVG: {
                if (!opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && i == 2) {
                    result = secondValue;
                    dataStack.push(firstValue);
                    break;
                }
                result = firstValue.add(secondValue);
                while (!dataStack.isEmpty()) {
                    result = result.add(dataStack.pop());
                    if (opStack.isEmpty() || !EmOperator.isSimpleOperator(opStack.peek().getExpression()) || dataStack.size() != 1) continue;
                }
                result = result.divide(new BigDecimal(i), result.scale(), RoundingMode.FLOOR);
                break;
            }
            case SUM: {
                if (!opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && i == 2) {
                    result = secondValue;
                    dataStack.push(firstValue);
                    break;
                }
                result = firstValue.add(secondValue);
                while (!(dataStack.isEmpty() || !opStack.isEmpty() && EmOperator.isSimpleOperator(opStack.peek().getExpression()) && dataStack.size() == 1)) {
                    result = result.add(dataStack.pop());
                }
                break;
            }
            case COUNT: {
                result = new BigDecimal(i);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u7684\u51fd\u6570\uff1a%s\u3002", (String)"NumericalCalValidate_8", (String)"bos-print-service", (Object[])new Object[]{op}));
            }
        }
        dataStack.push(new BigDecimal("" + result));
    }

    private static String preProcess(String expression) throws KDBizException {
        if ((expression = expression.trim()).contains("\uff09") || expression.contains("\uff08") || expression.contains("\uff0c")) {
            throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
        }
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 35;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(') continue;
            arr[i] = 35;
        }
        if (arr[0] == '+') {
            return new String(arr, 1, arr.length - 1);
        }
        if (arr[0] == '*' || arr[0] == '/' || arr[arr.length - 1] == '*' || arr[arr.length - 1] == '/' || String.valueOf(arr[0]).matches("[\u4e00-\u9fa5]") || String.valueOf(arr[arr.length - 1]).matches("[\u4e00-\u9fa5]")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u6216\u8005\u5b57\u6bb5\u662f\u5426\u4f7f\u7528\u82f1\u6587\u53cc\u5f15\u53f7\u6807\u8bc6 (\u5982 \"\u8f93\u5165\u7684\u6587\u5b57\")\u3002", (String)"NumericalCalValidate_0", (String)"bos-print-service", (Object[])new Object[0]));
        }
        if (arr[0] == '#' && (arr[1] == '(' || Character.isDigit(arr[1]) || Character.isLetter(arr[1]))) {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }
}

