/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.data.field.DateField;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.service.formula.AbstractPrintFormulaParser;
import kd.bos.service.KDDateUtils;

public final class PrintFormulaExecute
extends AbstractPrintFormulaParser {
    private static final Log log = LogFactory.getLog(PrintFormulaExecute.class);
    private static final List<String> MONTH_FUN = Arrays.asList("YEAR", "MONTH", "DAY", "DATEDIF");

    @Override
    protected Object getVariableValue(Map fieldItem, Deque<AbstractPrintFormulaParser.FunctionInfo> funStack) {
        return fieldItem.get("value");
    }

    @Override
    protected Object transferVariableValue(Object value, String dataSource, String textFormat, String function) {
        StringBuilder result = new StringBuilder();
        if (StringUtil.equals((String)dataSource, (String)"$DsKey=[System]")) {
            return value;
        }
        if ("Number".equals(textFormat) || "Amount".equals(textFormat)) {
            if (!(value instanceof NullField)) {
                return this.toBigDecimal(value);
            }
            result.append(0);
        } else {
            if ("Date".equals(textFormat)) {
                if (MONTH_FUN.contains(function)) {
                    return this.toDateFormat(value, true);
                }
                if ("TO_CHAR".equals(function)) {
                    return this.toDate(value);
                }
                return this.toDateFormat(value, false);
            }
            if (!(value instanceof NullField)) {
                return value.toString();
            }
        }
        return result.toString();
    }

    @Override
    protected StringBuilder executeFormulaCalculate(List<String> functions, Map<String, Object> variableMap) {
        StringBuilder result = new StringBuilder();
        for (String function : functions) {
            if ("_enter_".equals(function)) {
                result.append(System.lineSeparator());
                continue;
            }
            try {
                Object execResult = FormulaEngine.execExcelFormula((String)function, variableMap, (UDFunction[])this.udFunctions);
                if (execResult == null) continue;
                if (execResult instanceof BigDecimal) {
                    result.append(((BigDecimal)execResult).toPlainString());
                    continue;
                }
                result.append(execResult);
            }
            catch (Exception e) {
                log.warn("\u5f15\u64ce\u8fdb\u884c\u8ba1\u7b97\u6709\u7279\u6b8a\u60c5\u51b5\uff1a" + e);
            }
        }
        return result;
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)value;
            BigDecimal bigDecimal = ((DecimalField)value).getValue();
            value = bigDecimal.setScale(decimalField.getScale(), 4);
        } else if (value instanceof Field) {
            value = ((Field)value).getValue();
        }
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            ret = new BigDecimal(((String)value).trim());
        } else if (value instanceof Integer) {
            ret = new BigDecimal((Integer)value);
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Long) {
            ret = new BigDecimal((Long)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }

    private String toDateFormat(Object field, Boolean userDateFunc) {
        SimpleDateFormat sdf;
        String displayVal = null;
        Timestamp timestamp = null;
        Date date = null;
        if (field instanceof String) {
            return (String)field;
        }
        if (field instanceof DateTimeField) {
            DateTimeField dateTimeField = (DateTimeField)field;
            displayVal = dateTimeField.getDisplayVal();
            timestamp = (Timestamp)dateTimeField.getValue();
        } else if (field instanceof DateField) {
            DateField dateField = (DateField)field;
            displayVal = dateField.getDisplayVal();
            date = (Date)dateField.getValue();
        }
        if (!userDateFunc.booleanValue() && null != displayVal) {
            return displayVal;
        }
        if (timestamp != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setTimeZone(field, sdf);
            return sdf.format(new Date(timestamp.getTime()));
        }
        if (date != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setTimeZone(field, sdf);
            return sdf.format(date);
        }
        return null;
    }

    private void setTimeZone(Object field, SimpleDateFormat sdf) {
        if (field instanceof Field) {
            TimeZone timeZone = ((Field)field).getTimeZone();
            if (timeZone == null) {
                timeZone = KDDateUtils.getSysTimeZone();
            }
            sdf.setTimeZone(timeZone);
        }
    }

    private Date toDate(Object field) {
        Timestamp timestamp;
        if (field instanceof DateTimeField && (timestamp = (Timestamp)((DateTimeField)field).getValue()) != null) {
            return new Date(timestamp.getTime());
        }
        if (field instanceof DateField) {
            return (Date)((DateField)field).getValue();
        }
        return null;
    }
}

