/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.formula;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.service.formula.AbstractPrintFormulaParser;

public final class PrintFormulaValidate
extends AbstractPrintFormulaParser {
    private static final String IDX_OUTOFRANGE_WARNING_CODE = "SYS.cts.WARNING_001";
    private static final String IDX_OUTOFRANGE_DATE_WARNING_CODE = "SYS.cts.DATE_WARNING_001";
    private static final String LINEFEED_WARNING_CODE = "SYS.cts.LINEFEED_WARNING_001";
    private static final String DEF_TEXT_200_CHARS = "texttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttexttext";
    private static final Log logger = LogFactory.getLog(PrintFormulaValidate.class);

    @Override
    protected Object getVariableValue(Map fieldItem, Deque<AbstractPrintFormulaParser.FunctionInfo> funStack) {
        String tf = (String)fieldItem.get("textFormat");
        if ("Number".equals(tf) || "Amount".equals(tf)) {
            if (!funStack.isEmpty() && NUMBER_UPPER_FUN.getName().equals(funStack.getFirst().getName())) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }
        if ("Date".equals(tf)) {
            if (!funStack.isEmpty() && "TO_CHAR".equals(funStack.getFirst().getName())) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                try {
                    date = sf.parse("2018-08-08 01:02:03");
                }
                catch (ParseException e) {
                    logger.error(ResManager.loadKDString((String)"PrintFormulaValidate.transferVariableValue\u89e3\u6790\u65e5\u671f\u5931\u8d25\u3002", (String)"FormulaCheckValue_0", (String)"bos-print-service", (Object[])new Object[0]));
                }
                return date;
            }
            return "2018-08-08 01:02:03";
        }
        if ("Time".equals(tf)) {
            return "01:02:03";
        }
        return DEF_TEXT_200_CHARS;
    }

    @Override
    protected Object transferVariableValue(Object value, String dataSource, String textFormat, String function) {
        return value;
    }

    @Override
    protected void splitExceptionProcess() {
        throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
    }

    @Override
    protected void beforeFieldExp(Deque<AbstractPrintFormulaParser.FunctionInfo> funStack, int index, List<Object> expressions) {
        if (this.isGather(funStack) && index + 1 < expressions.size() && expressions.get(index + 1) instanceof Map) {
            throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570\u4e2d\u53c2\u6570\u4e4b\u95f4\u9700\u4ee5\u9017\u53f7\u76f8\u9694\u3002", (String)"PrintFormulaValidate_0", (String)"bos-print-service", (Object[])new Object[0]));
        }
    }

    @Override
    protected void beforeLiteralExp(Deque<AbstractPrintFormulaParser.FunctionInfo> funStack, String literalExp, int index, List<Object> expressions) {
    }

    public static String getExceptionTips() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6838\u5bf9\u51fd\u6570\u8bed\u6cd5\u540e\u91cd\u65b0\u8f93\u5165\uff1a 1.\u7b26\u53f7\u662f\u5426\u4e3a\u82f1\u6587\u8f93\u5165\u72b6\u6001\u4e0b\u8f93\u5165\uff1b2.\u624b\u52a8\u8f93\u5165\u6587\u672c\u65f6\uff0c\u662f\u5426\u4f7f\u7528\u82f1\u6587\u53cc\u5f15\u53f7\u6807\u8bc6 (\u5982 \"\u8f93\u5165\u7684\u6587\u5b57\")\uff1b3.\u51fd\u6570\u4e2d\u662f\u5426\u5b58\u5728\u591a\u4f59\u7684\u9017\u53f7\uff0c(\u5982 \u51fd\u6570(1,))\uff1b4.\u51fd\u6570\u662f\u5426\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff1b5.\u662f\u5426\u5b58\u5728\u5e76\u884c\u51fd\u6570\uff0c\u5982\u51fd\u6570(1)\u51fd\u6570(1)\uff1b6.\u662f\u5426\u5b58\u5728\u6362\u884c\u7b26\u5bfc\u81f4\u51fd\u6570\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]);
    }

    @Override
    protected StringBuilder executeFormulaCalculate(List<String> functions, Map<String, Object> variableMap) {
        StringBuilder result = new StringBuilder();
        for (String function : functions) {
            if ("_enter_".equals(function)) {
                result.append(System.lineSeparator());
                continue;
            }
            try {
                Object execResult = FormulaEngine.execExcelFormula((String)function, variableMap, (UDFunction[])this.udFunctions);
                if (execResult != null) {
                    if (execResult instanceof BigDecimal) {
                        result.append(((BigDecimal)execResult).toPlainString());
                        continue;
                    }
                    result.append(execResult);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6838\u5bf9\u51fd\u6570\u8bed\u6cd5\u540e\u91cd\u65b0\u8f93\u5165\uff1a 1.\u7b26\u53f7\u662f\u5426\u4e3a\u82f1\u6587\u8f93\u5165\u72b6\u6001\u4e0b\u8f93\u5165\uff1b2.\u624b\u52a8\u8f93\u5165\u6587\u672c\u65f6\uff0c\u662f\u5426\u4f7f\u7528\u82f1\u6587\u53cc\u5f15\u53f7\u6807\u8bc6 (\u5982 \"\u8f93\u5165\u7684\u6587\u5b57\")\uff1b3.\u51fd\u6570\u4e2d\u662f\u5426\u5b58\u5728\u591a\u4f59\u7684\u9017\u53f7\uff0c(\u5982 \u51fd\u6570(1,))\uff1b4.\u51fd\u6570\u662f\u5426\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff1b5.\u662f\u5426\u5b58\u5728\u5e76\u884c\u51fd\u6570\uff0c\u5982\u51fd\u6570(1)\u51fd\u6570(1)\uff1b6.\u662f\u5426\u5b58\u5728\u6362\u884c\u7b26\u5bfc\u81f4\u51fd\u6570\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
            }
            catch (ClassCastException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u53c2\u6570\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\u51fd\u6570\u8bed\u6cd5\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"FormulaParseValue_8", (String)"bos-print-service", (Object[])new Object[0]));
            }
            catch (ArithmeticException e) {
                throw new KDBizException(e.toString());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg.contains("parse")) {
                    throw new KDBizException(ResManager.loadKDString((String)PrintFormulaValidate.getExceptionTips(), (String)"FormulaParseValue_0", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if ("0".equals(msg)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u53c2\u6570\u3002", (String)"FormulaParseValue_2", (String)"bos-print-service", (Object[])new Object[0]));
                }
                if (function.contains("SUBSTRING") && null != e.getMessage() && e.getMessage().contains("String index out of range")) {
                    throw new KDBizException(new ErrorCode(IDX_OUTOFRANGE_WARNING_CODE, ResManager.loadKDString((String)"start_num\u8d77\u59cb\u4f4d\u7f6e\u7684\u503c\u8fc7\u5927\uff08\u7ed1\u5b9a\u5b57\u6bb5\u6700\u5927\u503c\u4e3a200\uff09\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (String)"FormulaParseValue_4", (String)"bos-print-service", (Object[])new Object[0])), null);
                }
                if ((function.contains("YEAR") || function.contains("DAY") || function.contains("MONTH")) && null != e.getMessage() && (e.getMessage().contains("Illegal date string:") || e.getMessage().contains(ResManager.loadKDString((String)"\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5", (String)"PrintFormulaValidate_1", (String)"bos-print-service", (Object[])new Object[0])))) {
                    throw new KDBizException(new ErrorCode(IDX_OUTOFRANGE_DATE_WARNING_CODE, ResManager.loadKDString((String)"\u65f6\u95f4\u51fd\u6570\u53c2\u6570\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FormulaParseValue_5", (String)"bos-print-service", (Object[])new Object[0])), null);
                }
                if (function.contains("_enter_") && null != e.getMessage()) {
                    throw new KDBizException(new ErrorCode(LINEFEED_WARNING_CODE, ResManager.loadKDString((String)"\u6362\u884c\u7b26\u5bfc\u81f4\u51fd\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u51fd\u6570\u3002", (String)"FormulaParseValue_7", (String)"bos-print-service", (Object[])new Object[0])), null);
                }
                throw new KDBizException(e.getMessage());
            }
        }
        return result;
    }
}

