/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.helper;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.WebSocketObject;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.service.util.PrintClientMsgUtil;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.print.service.webapi.service.PrintClientService;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;

public class ClientMsgListener
implements WebSocketListener {
    private static Log log = LogFactory.getLog(ClientMsgListener.class);
    private static PrintClientService clientService = new PrintClientService();
    private static ThreadPool clientThreadPool = ThreadPools.newFixedThreadPool((String)"print-client-pool", (int)1);

    public String getType() {
        return "KDPrintClient";
    }

    public void onConnect(WebSocketObject webSocketObject) {
        String identifyType = webSocketObject.getIdentifyType();
        log.info("\u6253\u5370\u5ba2\u6237\u7aef\uff0c\u8fde\u63a5\u6210\u529f,\u5ba2\u6237\u7aef\u7f16\u7801={}", (Object)identifyType);
        PrintClientUtil.doHeartBeat(webSocketObject.getSessionId(), identifyType);
        PrintClientMsgUtil.sendMsgToClient(identifyType, PrintClientMsgUtil.MsgType.S_CONNECT_PONG);
    }

    public void onMessage(WebSocketObject webSocketObject, String message) {
        String identifyType = webSocketObject.getIdentifyType();
        log.debug("\u6253\u5370\u5ba2\u6237\u7aef\uff0c\u63a5\u53d7\u5230\u5ba2\u6237\u7aef\u6d88\u606f,identifyType={},message={}", (Object)identifyType, (Object)message);
        ClientMsgListener.handMessage(webSocketObject, message);
    }

    public void onClose(WebSocketObject webSocketObject) {
        String identifyType = webSocketObject.getIdentifyType();
        log.info("\u6253\u5370\u5ba2\u6237\u7aef\uff0c\u8fde\u63a5\u65ad\u5f00,\u5ba2\u6237\u7aef\u7f16\u7801={}", (Object)identifyType);
        PrintClientUtil.turnOffLine(webSocketObject.getSessionId(), identifyType);
    }

    private static void handMessage(WebSocketObject webSocketObject, String message) {
        String sessionId = webSocketObject.getSessionId();
        String identifyType = webSocketObject.getIdentifyType();
        PrintClientUtil.doHeartBeat(webSocketObject.getSessionId(), identifyType);
        Map messageObj = null;
        try {
            messageObj = (Map)SerializeUtils.fromJsonString((String)message, Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (messageObj == null || messageObj.isEmpty()) {
            return;
        }
        PrintClientMsgUtil.MsgType msgType = PrintClientMsgUtil.getMsgType(messageObj);
        if (msgType == PrintClientMsgUtil.MsgType.UNKNOW) {
            return;
        }
        if (msgType == PrintClientMsgUtil.MsgType.R_HEART_PING) {
            return;
        }
        if (msgType == PrintClientMsgUtil.MsgType.R_PRINTER_STATUS) {
            PrintClientUtil.updatePrinterStatus(identifyType, (Map)messageObj.get("info"));
            return;
        }
        ClientMsgListener.initRequestContext(sessionId);
        Map finalMessageObj = messageObj;
        clientThreadPool.execute(() -> {
            if (msgType == PrintClientMsgUtil.MsgType.R_UPDATES_TATUS) {
                String taskId = String.valueOf(finalMessageObj.get("taskId"));
                String status = String.valueOf(finalMessageObj.get("status"));
                log.info("\u6253\u5370\u5ba2\u6237\u7aef\uff0c\u66f4\u65b0\u6253\u5370\u72b6\u6001,taskId={}", (Object)taskId);
                clientService.updateTask(taskId, Boolean.parseBoolean(status));
            } else if (msgType == PrintClientMsgUtil.MsgType.R_CLEAR_TASK) {
                clientService.clearTask();
            }
        });
    }

    private static void initRequestContext(String sessionId) {
        RequestContext requestContext = RequestContext.create();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "accountId", "userId", "userName", "orgId", "requestId", "client", "userType", "uid", "userOpenId"});
        requestContext.setTraceId(TraceIdUtil.createTraceIdString());
        requestContext.setGlobalSessionId(sessionId);
        requestContext.setTenantId((String)sessionInfo.get("tenantId"));
        requestContext.setAccountId((String)sessionInfo.get("accountId"));
        requestContext.setUserId((String)sessionInfo.get("userId"));
        requestContext.setUserName((String)sessionInfo.get("userName"));
        requestContext.setOrgId(Long.parseLong((String)sessionInfo.get("orgId")));
        requestContext.setRequestId((String)sessionInfo.get("requestId"));
        requestContext.setClient((String)sessionInfo.get("client"));
        requestContext.setUserType((String)sessionInfo.get("userType"));
        requestContext.setUid((String)sessionInfo.get("uid"));
        String userOpenId = (String)sessionInfo.get("userOpenId");
        requestContext.setUserOpenId(userOpenId);
        RequestContextThreadBinder.bind((RequestContext)requestContext);
    }
}

