/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.helper;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.watermark.IWaterMarkProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.PrintContext;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.facade.PrtUnitTestFacadeFactory;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.cardgrid.CardGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.api.metedata.control.prop.AnchorField;
import kd.bos.print.api.metedata.control.prop.SortSetting;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.StreamUtil;
import kd.bos.print.core.ctrl.print.util.PdfWaterMarkUtil;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.RefDataSource;
import kd.bos.print.core.data.datasource.RefParam;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.datasource.prop.SortField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteEngine;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.utils.PrtFileNameUtil;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.service.IAttachmentService;
import kd.bos.print.core.service.ICacheService;
import kd.bos.print.core.service.IClientService;
import kd.bos.print.core.service.IFontService;
import kd.bos.print.core.service.IFormulaService;
import kd.bos.print.core.service.ISensitiveService;
import kd.bos.print.core.service.IUserService;
import kd.bos.print.core.service.PrintServiceProxy;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.service.PrtFont;
import kd.bos.print.core.utils.FilterUtil;
import kd.bos.print.service.helper.ExecuteParam;
import kd.bos.print.service.helper.PrintJob;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.print.service.provider.CacheServiceProvider;
import kd.bos.print.service.provider.ClientScptServiceProvider;
import kd.bos.print.service.provider.ClientServiceProvider;
import kd.bos.print.service.provider.FontServiceProvider;
import kd.bos.print.service.provider.FormulaServiceProvider;
import kd.bos.print.service.provider.I18nServiceProvider;
import kd.bos.print.service.provider.SensitiveServiceProvider;
import kd.bos.print.service.provider.UserServiceProvider;
import kd.bos.print.service.transform.PrintMetadataReader;
import kd.bos.service.ServiceFactory;
import kd.bos.session.SystemPropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportService {
    private static final Log log = LogFactory.getLog(ExportService.class);

    public ExportService(String lang) {
        this.setContext(null, lang);
    }

    public ExportService(String taskId, String lang) {
        this.setContext(taskId, lang);
    }

    private void setContext(String taskId, String lang) {
        ExecuteContext executeContext = ExecuteContext.get();
        PrintServiceProxy serviceProxy = executeContext.getServiceProxy();
        FontServiceProvider fontService = new FontServiceProvider();
        fontService.setDefaultFont(new PrtFont("\u601d\u6e90\u5b8b\u4f53 CN", "Source Han Serif CN", "source han serif cn.ttf"));
        serviceProxy.register((IFontService)fontService);
        serviceProxy.register((IUserService)UserServiceProvider.getProvider());
        serviceProxy.register((IAttachmentService)AttachmentServiceProvider.getProvider());
        serviceProxy.register((IFormulaService)new FormulaServiceProvider());
        String prtEnablePrivacy = SystemPropertyUtils.getProptyByTenant((String)"PRT_ENABLE_PRIVACY", (String)RequestContext.get().getTenantId());
        serviceProxy.register((ICacheService)CacheServiceProvider.getProvider());
        serviceProxy.register(I18nServiceProvider.getProvider());
        boolean enablePrivacy = true;
        if ("false".equalsIgnoreCase(prtEnablePrivacy)) {
            enablePrivacy = false;
        }
        serviceProxy.register((ISensitiveService)new SensitiveServiceProvider(enablePrivacy));
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        }
        executeContext.setTaskId(taskId);
        executeContext.setServiceProxy(serviceProxy);
        PrintContext.get().setLang(lang);
        executeContext.setLang(lang);
        executeContext.setPageLimit(ConfigConstUtil.getPageLimit());
        executeContext.setShowExp(false);
    }

    protected RuntimeModel loadR1Model(PrintJob job) {
        PrintMetadata metadata = job.getMetadata();
        IPrintDataProvider dataProvider = job.getDataProvider();
        PrintMetadataReader reader = new PrintMetadataReader();
        ReportModel rm = reader.parseModel(metadata);
        RuntimeModel runtimeModel = new RuntimeModel(rm);
        runtimeModel.setTplVer(metadata.getVersion());
        runtimeModel.setFormId(job.getFormId());
        ArrayList<Object> pkIds = new ArrayList(0);
        if (!CollectionUtils.isEmpty(job.getPkIds())) {
            pkIds = new ArrayList<Object>(job.getPkIds());
        }
        runtimeModel.setPkIds(pkIds);
        runtimeModel.setPdfName((String)metadata.getName().getLocaleValue());
        runtimeModel.setFileNameData(metadata.getPaper().getFileName());
        runtimeModel.setSplicePrint(metadata.getPaper().isSplicePrint());
        runtimeModel.setTplId(metadata.getId());
        runtimeModel.setTplKey(metadata.getKey());
        ExecuteContext.get().setTplId(metadata.getId());
        ExecuteContext.get().setTplKey(metadata.getKey());
        PrintPluginProxy proxy = this.buildPrintPluginProxy(job);
        runtimeModel.setPluginProxy(proxy);
        dataProvider.setPluginProxy(proxy);
        ExecuteContext.get().getServiceProxy().register(dataProvider);
        ExecuteContext.get().setPluginProxy(proxy);
        Map<String, PrtDataSource> dataSources = this.buildDataSource(job);
        runtimeModel.hookDataProvider(dataProvider, dataSources);
        if (metadata.getPaper().isShowWaterMark() || PdfWaterMarkUtil.checkIsTempLicense()) {
            IWaterMarkProxy waterMarkService = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
            WaterMark wm = waterMarkService.loadFromCache(job.getFormId());
            runtimeModel.setWaterMark(wm);
        }
        return runtimeModel;
    }

    protected PrintPluginProxy buildPrintPluginProxy(PrintJob job) {
        PrintMetadata metadata = job.getMetadata();
        String pluginstr = metadata.getPlugins();
        List plugins = null;
        plugins = StringUtils.isBlank((CharSequence)pluginstr) ? new ArrayList() : (List)SerializeUtils.fromJsonString((String)pluginstr, List.class);
        PrintPluginProxy proxy = new PrintPluginProxy(plugins);
        PrtUnitTestFacadeFactory.getUnitTestFacades().forEach(unitTestFacade -> unitTestFacade.afterBuildPlugin((Object)proxy));
        return proxy;
    }

    private Map<String, PrtDataSource> buildDataSource(PrintJob job) {
        PrintMetadata metadata = job.getMetadata();
        String type = metadata.getType();
        String mainFormId = metadata.getFormId();
        Map<String, PrtDataSource> dataSourceMap = this.scanField(metadata);
        HashMap<String, PrtDataSource> resultDsMap = new HashMap<String, PrtDataSource>(16);
        boolean isSysTpl = "PrintTplMetadata".equals(type);
        if (isSysTpl) {
            return resultDsMap;
        }
        MainDataSource mainDataSource = (MainDataSource)dataSourceMap.remove(mainFormId);
        if (mainDataSource == null) {
            mainDataSource = new MainDataSource(mainFormId, DsType.MAIN, mainFormId);
        }
        mainDataSource.setPageId(job.getPageId());
        mainDataSource.getQueryField().add("id");
        this.setFileNameQueryField(metadata, mainDataSource);
        resultDsMap.put(mainFormId, (PrtDataSource)mainDataSource);
        Map<String, Map> refMap = this.getRefMap(metadata);
        for (Map.Entry<String, PrtDataSource> entry : dataSourceMap.entrySet()) {
            String key = entry.getKey();
            String[] arr = key.split("\\.");
            String dsFormId = arr[0];
            PrtDataSource dataSource = entry.getValue();
            DsType dsType = dataSource.getDsType();
            Map map = refMap.get(dsFormId);
            if (map != null) {
                if (!resultDsMap.containsKey(dsFormId)) {
                    RefDataSource refDataSource = (RefDataSource)dataSourceMap.get(dsFormId);
                    if (refDataSource == null) {
                        refDataSource = new RefDataSource(dsFormId, dsFormId);
                    }
                    String unionField = (String)map.get("unionfield");
                    Map unionObj = (Map)SerializationUtils.fromJsonString((String)unionField, Map.class);
                    String mainUnionField = (String)unionObj.get("mainunionfield");
                    DynamicProperty property = mainDataSource.getMainEntityType().getProperty(mainUnionField);
                    if (property instanceof BasedataProp) {
                        mainUnionField = mainUnionField + ".id";
                    }
                    mainDataSource.getQueryField().add(mainUnionField);
                    String unionCp = (String)unionObj.get("combofield");
                    String refField = (String)unionObj.get("importunionfield");
                    property = refDataSource.getMainEntityType().getProperty(refField);
                    if (property instanceof BasedataProp) {
                        refField = refField + ".id";
                    }
                    RefParam refParam = new RefParam(mainUnionField, unionCp, refField);
                    refDataSource.setRefParam(refParam);
                    String filtercondition = (String)map.get("filtercondition");
                    if (StringUtils.isNotBlank((CharSequence)filtercondition)) {
                        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filtercondition, FilterCondition.class);
                        refDataSource.setFilterCondition(filterCondition);
                    }
                    mainDataSource.addRefDs(refDataSource);
                    resultDsMap.put(dsFormId, (PrtDataSource)refDataSource);
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)dsFormId)) continue;
            }
            if (dsType == DsType.CUSTOM) {
                CustomDataSource customDs = (CustomDataSource)dataSource;
                customDs.setFormId(job.getFormId());
                customDs.setPkId(job.getPkId());
                customDs.setPageId(job.getPageId());
                resultDsMap.put(key, dataSource);
                continue;
            }
            if (dsType == DsType.SYS) {
                resultDsMap.put(key, dataSource);
                continue;
            }
            if (dsType == DsType.APPROVELINE || dsType == DsType.APPROVEACTIVITY) {
                WorkflowDataSource workflowDataSource = (WorkflowDataSource)dataSource;
                workflowDataSource.setWorkFlowParams(job.getWorkFlowParams());
                workflowDataSource.setBusinessKey(job.getPkId() + "");
                resultDsMap.put(key, (PrtDataSource)workflowDataSource);
                continue;
            }
            FormDataSource headDataSource = (FormDataSource)resultDsMap.get(dsFormId);
            if (dsType == DsType.SUBENTRY) {
                EntityType entityType = headDataSource.getEntityType(key);
                String entryKey = headDataSource.getDsName() + "." + entityType.getParent().getName();
                PrtDataSource prtDataSource = dataSourceMap.get(entryKey);
                if (prtDataSource == null) {
                    prtDataSource = new PrtDataSource(entryKey, DsType.ENTRY);
                    prtDataSource.addField("id");
                    headDataSource.addChildDs(prtDataSource);
                }
                if (prtDataSource.isMergePrint() || dataSource.isMergePrint()) {
                    dataSource.setMergePrint(true);
                    prtDataSource.setMergePrint(true);
                    Set mergePrintSet = ExecuteContext.get().getHasMergePrintDsMap().getOrDefault(metadata.getKey(), new HashSet(16));
                    mergePrintSet.add(dataSource.getDsName());
                    mergePrintSet.add(prtDataSource.getDsName());
                    ExecuteContext.get().getHasMergePrintDsMap().put(metadata.getKey(), mergePrintSet);
                }
            }
            headDataSource.addChildDs(dataSource);
        }
        return resultDsMap;
    }

    private void setFileNameQueryField(PrintMetadata metadata, MainDataSource mainDataSource) {
        Paper paper = metadata.getPaper();
        if (null == paper) {
            return;
        }
        List fileName = paper.getFileName();
        if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)fileName)) {
            return;
        }
        List fieldList = PrtFileNameUtil.parseField((List)fileName);
        if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)fieldList)) {
            HashSet set = new HashSet(mainDataSource.getQueryField());
            set.addAll(fieldList);
            mainDataSource.setQueryField(new ArrayList(set));
        }
    }

    private Map<String, Map> getRefMap(PrintMetadata metadata) {
        Map<String, Map> refMap = null;
        String refDs = metadata.getRefDs();
        if (StringUtils.isNotBlank((CharSequence)refDs)) {
            List resList = (List)SerializationUtils.fromJsonString((String)refDs, List.class);
            refMap = resList.stream().collect(Collectors.toMap(item -> (String)item.get("formId"), item -> item));
        } else {
            refMap = Collections.EMPTY_MAP;
        }
        return refMap;
    }

    private Map<String, PrtDataSource> scanField(PrintMetadata metadata) {
        HashMap<String, PrtDataSource> dsMap = new HashMap<String, PrtDataSource>();
        Iterator iterator = metadata.getPages().iterator();
        HashMap<String, Map> conditionMap = new HashMap<String, Map>(16);
        HashSet<String> dsMergePrintSet = new HashSet<String>(16);
        while (iterator.hasNext()) {
            List page = (List)iterator.next();
            HashMap<String, List<SortSetting>> hashMap = new HashMap<String, List<SortSetting>>(8);
            Iterator iterator2 = page.iterator();
            while (iterator2.hasNext()) {
                Text text;
                AnchorField af;
                List settings;
                Control control = (Control)iterator2.next();
                if (control instanceof DataGrid && !kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)(settings = ((DataGrid)control).getSortSettings()))) {
                    ArrayList sortSettings = (ArrayList)hashMap.get(control.getKey());
                    if (sortSettings == null) {
                        sortSettings = new ArrayList(5);
                    }
                    sortSettings.addAll(settings);
                    hashMap.put(control.getKey(), sortSettings);
                }
                if (control instanceof DataGrid || control instanceof CardGrid) {
                    String filterSetting = "";
                    String dataSource = "";
                    boolean mergePrint = false;
                    if (control instanceof DataGrid) {
                        DataGrid dataGrid = (DataGrid)control;
                        dataSource = dataGrid.getDataSource();
                        filterSetting = dataGrid.getFilterSettingValue();
                        mergePrint = dataGrid.isMergePrint();
                    }
                    if (control instanceof CardGrid) {
                        CardGrid cardGrid = (CardGrid)control;
                        dataSource = cardGrid.getDataSource();
                        filterSetting = cardGrid.getFilterSettingValue();
                        mergePrint = cardGrid.isMergePrint();
                    }
                    if (StringUtils.isNotBlank((CharSequence)filterSetting)) {
                        Map gridConditionMap = conditionMap.getOrDefault(dataSource, new HashMap(1));
                        List conditionList = FilterUtil.getConditionList((String)filterSetting, (String)dataSource);
                        if (!CollectionUtils.isEmpty((Collection)conditionList)) {
                            gridConditionMap.put(control.getKey(), conditionList);
                            conditionMap.put(dataSource, gridConditionMap);
                        }
                    }
                    if (mergePrint) {
                        dsMergePrintSet.add(dataSource);
                    }
                }
                if (!(control instanceof BaseDsControl)) continue;
                BaseDsControl ctrl = (BaseDsControl)control;
                String ds = ctrl.getDataSource();
                String dsTypeStr = ctrl.getDsType();
                DsType dsType = DsType.from((String)dsTypeStr);
                List formulaData = ctrl.getFormulaData();
                String bindField = ctrl.getBindField();
                if (control instanceof LayoutGridRow) {
                    if (StringUtils.isBlank((CharSequence)ds) || StringUtils.isBlank((CharSequence)ctrl.getBindField())) continue;
                    if (StringUtils.isBlank((CharSequence)dsTypeStr)) {
                        dsType = DsType.ENTRY;
                    }
                } else if (control instanceof Text && (af = (text = (Text)control).getAnchorField()) != null) {
                    this.addToDsMap(dsMap, af.getDataSource(), DsType.from((String)af.getDsType()), null, af.getBindField());
                }
                if (StringUtils.isBlank((CharSequence)ds) && DsType.FORMULA != dsType) continue;
                this.addToDsMap(dsMap, ds, dsType, formulaData, bindField);
            }
            this.addSortField(dsMap, hashMap);
        }
        for (Map.Entry entry : dsMap.entrySet()) {
            String dataSource = (String)entry.getKey();
            if (conditionMap.containsKey(dataSource)) {
                Map gridConditionMap = (Map)conditionMap.get(dataSource);
                PrtDataSource prtDataSource = (PrtDataSource)entry.getValue();
                gridConditionMap.forEach((arg_0, arg_1) -> ((PrtDataSource)prtDataSource).putConditionList(arg_0, arg_1));
            }
            if (!dsMergePrintSet.contains(dataSource)) continue;
            PrtDataSource prtDataSource = (PrtDataSource)entry.getValue();
            prtDataSource.setMergePrint(true);
        }
        Map hasMergePrintDsSet = ExecuteContext.get().getHasMergePrintDsMap();
        hasMergePrintDsSet.put(metadata.getKey(), dsMergePrintSet);
        ExecuteContext.get().setHasMergePrintDsMap(hasMergePrintDsSet);
        return dsMap;
    }

    private void addToDsMap(Map<String, PrtDataSource> dsMap, String ds, DsType dsType, List<Object> formulaData, String bindField) {
        if (!dsMap.containsKey(ds)) {
            if (dsType == DsType.FORMULA && formulaData != null) {
                for (Object object : formulaData) {
                    if (!(object instanceof Map)) continue;
                    ds = (String)((Map)object).get("dataSource");
                    String bf = (String)((Map)object).get("bindField");
                    dsType = DsType.from((String)((String)((Map)object).get("dsType")));
                    if (!dsMap.containsKey(ds)) {
                        PrtDataSource dataSource = this.getDataSource(ds, dsType);
                        dataSource.addField(bf);
                        dsMap.put(ds, dataSource);
                        continue;
                    }
                    PrtDataSource d = dsMap.get(ds);
                    d.addField(bf);
                }
            } else {
                PrtDataSource dataSource = this.getDataSource(ds, dsType);
                dataSource.addField(bindField);
                dsMap.put(ds, dataSource);
            }
        } else {
            PrtDataSource dataSource = dsMap.get(ds);
            dataSource.addField(bindField);
        }
    }

    private void addSortField(Map<String, PrtDataSource> dsMap, Map<String, List<SortSetting>> sortSettingMap) {
        Comparator comparator = this.getDsCuzSortComparable();
        sortSettingMap.forEach((key, sorts) -> sorts.forEach(sort -> {
            PrtDataSource prtDataSource;
            if (StringUtils.isNotBlank((CharSequence)sort.getDataSource()) && StringUtils.isNotBlank((CharSequence)sort.getBindField()) && (prtDataSource = (PrtDataSource)dsMap.get(sort.getDataSource())) != null) {
                SortField sortField = new SortField();
                sortField.setDataSource(sort.getDataSource());
                sortField.setBindName(sort.getBindName());
                sortField.setBindField(sort.getBindField());
                sortField.setComparator(comparator);
                sortField.setOrderBy(StringUtils.isBlank((CharSequence)sort.getOrderBy()) ? SortField.getDefaultOrderBy() : sort.getOrderBy());
                ArrayList<SortField> sortFields = prtDataSource.getSortFields(key);
                if (sortFields == null) {
                    sortFields = new ArrayList<SortField>(5);
                    sortFields.add(sortField);
                    prtDataSource.setSortFields(key, sortFields);
                } else {
                    sortFields.add(sortField);
                }
            }
        }));
    }

    private PrtDataSource getDataSource(String ds, DsType dsType) {
        Object dataSource = dsType == DsType.MAIN || dsType == DsType.MAIN_REPORT ? new MainDataSource(ds, dsType, ds) : (dsType == DsType.REF ? new RefDataSource(ds, ds) : (dsType == DsType.CUSTOM ? new CustomDataSource(ds) : (dsType == DsType.SYS ? new PrtDataSource(ds, dsType) : (dsType == DsType.APPROVEACTIVITY || dsType == DsType.APPROVELINE ? new WorkflowDataSource(ds, dsType, ds) : new PrtDataSource(ds, dsType)))));
        return dataSource;
    }

    public String doExecute(ExecuteParam exeParam) {
        List<PrintJob> jobs = exeParam.getJobs();
        String expType = exeParam.getExpType();
        if (PrintWork.EXP_TYPE.EXP_CLIENT.getCode().equals(expType)) {
            String serviceN = exeParam.getServiceN();
            if (StringUtils.isBlank((CharSequence)serviceN)) {
                throw new PrintException("5", ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u670d\u52a1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PrintClientService_0", (String)"bos-print-service", (Object[])new Object[0]));
            }
            ClientServiceProvider provider = new ClientServiceProvider(serviceN, exeParam.getPrinterName());
            provider.setCopyNum(exeParam.getCopyNum());
            ExecuteContext.get().getServiceProxy().register((IClientService)provider);
        } else if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(expType) && ExecuteContext.get().getServiceProxy().getClientService() == null) {
            ExecuteContext.get().getServiceProxy().register((IClientService)new ClientScptServiceProvider());
        }
        return this.doExport(jobs, expType);
    }

    @Deprecated
    public boolean exportPdf(List<PrintJob> jobs, OutputStream outputStream) {
        String taskId = this.doExport(jobs, "pdf");
        PrtAttach prtAttach = ExecuteService.getAttachService().getPrtAttach(taskId);
        PrtAttach.AttachDetail attachDetail = null;
        for (PrtAttach.AttachDetail prtDetail : prtAttach.getAttachDetail()) {
            if (!"C".equalsIgnoreCase(prtDetail.getSource())) continue;
            attachDetail = prtDetail;
            break;
        }
        if (attachDetail == null) {
            return false;
        }
        String firstFilePath = attachDetail.getFilePath();
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(firstFilePath);
        try {
            StreamUtil.copy((InputStream)inputStream, (OutputStream)outputStream, (int)1024);
            StreamUtil.closeStream((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
        return true;
    }

    public String doExport(List<PrintJob> jobs, String printType) {
        ArrayList<RuntimeModel> runModelList = new ArrayList<RuntimeModel>();
        ExecuteContext.get().setFormId(jobs.get(0).getFormId());
        for (int i = 0; i < jobs.size(); ++i) {
            RuntimeModel runtimeModel = this.loadR1Model(jobs.get(i));
            if (runtimeModel.getReportModel().hasRichText()) {
                if ("xls".equals(printType)) {
                    String message = ResManager.loadKDString((String)"\u6a21\u7248\uff1a%s\uff0c\u5305\u542b\u5bcc\u6587\u672c\u63a7\u4ef6\uff0c\u6682\u4e0d\u652f\u6301\u5bfc\u51faExcel\u3002", (String)"BosPrintBusinessServiceImpl_0", (String)"bos-print-service", (Object[])new Object[0]);
                    message = String.format(message, runtimeModel.getPdfName());
                    throw new KDBizException(message);
                }
                runModelList.add(runtimeModel);
                continue;
            }
            runModelList.add(runtimeModel);
        }
        try {
            if (!runModelList.isEmpty()) {
                this.doExport(printType, runModelList);
            }
        }
        catch (Exception e) {
            log.error("\u6253\u5370\u5bfc\u51fapdf\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return ExecuteContext.get().getTaskId();
    }

    private void doExport(String printType, List<RuntimeModel> runModelList) {
        ExecuteContext.get().setRunFast(true);
        this.doExportFast(printType, runModelList);
    }

    private void doExportFast(String printType, List<RuntimeModel> runModelList) {
        ExecuteEngine engine = new ExecuteEngine(printType);
        engine.execute(runModelList);
    }

    @Deprecated
    protected StringBuilder prepareCrossPrint(List<PrintJob> jobs) {
        return null;
    }

    @Deprecated
    protected <NotePrinter> NotePrinter getNotePrinter() {
        try {
            String className = "kd.bos.print.core.ctrl.kdf.form2.ui.NotePrinter";
            Class<?> clazz = Class.forName(className);
            return (NotePrinter)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Comparator getDsCuzSortComparable() {
        List facades = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (facades != null && !facades.isEmpty()) {
            return ((IPrtDataSourceFacade)facades.get(0)).getDsCuzSortComparable();
        }
        return null;
    }
}

