/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.execute.PFileStorageType;
import kd.bos.print.core.service.IAttachmentService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.util.EncryptUtils;
import org.apache.http.util.ByteArrayBuffer;

public class AttachmentServiceProvider
implements IAttachmentService {
    private static volatile AttachmentServiceProvider provider = null;
    private static final Log log = LogFactory.getLog(AttachmentServiceProvider.class);

    private AttachmentServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttachmentServiceProvider getProvider() {
        if (provider != null) return provider;
        Class<AttachmentServiceProvider> clazz = AttachmentServiceProvider.class;
        synchronized (AttachmentServiceProvider.class) {
            if (provider != null) return provider;
            provider = new AttachmentServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    public PrtAttach getPrtAttach(String taskId) {
        PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
        return this.convertToPrtAttach(prtResult);
    }

    public String savePrtFile(String fileName, byte[] bytes) {
        boolean isPreview = ExecuteContext.get().isPreview();
        if (isPreview) {
            return PrintFileUtil.byteToTempUrl((String)fileName, (String)"", (String)"", (byte[])bytes, (boolean)false);
        }
        return this.savePrtFile(fileName, new ByteArrayInputStream(bytes));
    }

    public String savePrtFile(String fileName, InputStream inputStream) {
        PFileStorageType fileStorageType = ExecuteContext.get().getpFileStorageType();
        if ("2".equals(fileStorageType.getCode()) || ExecuteContext.get().isPreview()) {
            return PrintFileUtil.saveInputStream2TempFile((String)fileName, (InputStream)inputStream, (int)fileStorageType.getTimeout());
        }
        return PrintFileUtil.saveInputStream2FileServer((String)fileName, (InputStream)inputStream);
    }

    public void savePrtResult(PrtAttach prtAttach) {
        boolean isPreview = ExecuteContext.get().isPreview();
        PrtTaskResult result = this.convertToPrtResult(prtAttach);
        result.setTemp(isPreview);
        PrtTaskResultServiceHelper.savePrtResult((PrtTaskResult)result);
    }

    public byte[] getImage(String imageKey) {
        if (StringUtils.isBlank((CharSequence)imageKey)) {
            return null;
        }
        byte[] result = null;
        try {
            if (imageKey.startsWith("http:") || imageKey.startsWith("https:")) {
                result = AttachmentServiceProvider.readImageFromNet(imageKey);
            } else if (StringUtils.isNumeric((CharSequence)imageKey)) {
                Map<String, Object> res = this.getResources(imageKey);
                if (res != null) {
                    String url = (String)res.get("url");
                    Object data = res.get("data");
                    if (data instanceof byte[]) {
                        result = (byte[])data;
                    } else if (StringUtils.isNotBlank((CharSequence)url)) {
                        result = AttachmentServiceProvider.readImageFromImageService(url);
                    }
                }
            } else {
                result = AttachmentServiceProvider.readImageFromImageService(imageKey);
            }
        }
        catch (Exception e) {
            log.warn("\u6253\u5370-\u65e0\u6cd5\u4e0b\u8f7d\u56fe\u7247 :" + imageKey + ", \u539f\u56e0: " + e.getCause());
        }
        return result;
    }

    private Map<String, Object> getResources(String imageKey) {
        long rcId = 0L;
        try {
            rcId = Long.parseLong(imageKey);
        }
        catch (Exception e) {
            return null;
        }
        String sql = "select furl,fdata from %s where fid=?";
        sql = String.format(sql, "t_svc_printresource");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{rcId}, rSet -> {
            if (rSet.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("url", rSet.getString(1));
                result.put("data", rSet.getBytes(2));
                return result;
            }
            return null;
        });
    }

    private static byte[] readImageFromImageService(String imageUrl) {
        try {
            imageUrl = EncryptUtils.decrypt((String)imageUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String newUrl = imageUrl;
        if (newUrl.indexOf("?v=") > 0) {
            newUrl = newUrl.substring(0, newUrl.indexOf("?v="));
        }
        if (newUrl.indexOf("&v=") > 0) {
            newUrl = newUrl.substring(0, newUrl.indexOf("&v="));
        }
        byte[] byteImage = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileServiceFactory.getImageFileService().download(newUrl, (OutputStream)bos, null);
            byteImage = bos.toByteArray();
        }
        catch (IOException e) {
            log.warn("\u6253\u5370-\u65e0\u6cd5\u4e0b\u8f7d\u56fe\u7247.", (Throwable)e);
        }
        return byteImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readImageFromNet(String fullUrl) {
        InputStream in = null;
        BufferedInputStream bis = null;
        byte[] queryResult = null;
        try {
            HttpURLConnection urlConn;
            URL url = new URL(fullUrl);
            HttpURLConnection httpConn = urlConn = (HttpURLConnection)url.openConnection();
            httpConn.setAllowUserInteraction(false);
            httpConn.connect();
            in = httpConn.getInputStream();
            bis = new BufferedInputStream(in);
            ByteArrayBuffer baf = new ByteArrayBuffer(50);
            int read = 0;
            int bufSize = 512;
            byte[] buffer = new byte[bufSize];
            while ((read = bis.read(buffer)) != -1) {
                baf.append(buffer, 0, read);
            }
            queryResult = baf.toByteArray();
        }
        catch (Exception e) {
            log.warn("DEBUG: ", (Object)e.toString());
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return queryResult;
    }

    private PrtAttach convertToPrtAttach(PrtTaskResult prtTaskResult) {
        PrtAttach prtAttach = new PrtAttach();
        prtAttach.setTaskId(prtTaskResult.getTaskId());
        prtAttach.setFormId(prtTaskResult.getFormId());
        prtAttach.setOrgId(prtTaskResult.getOrgId());
        prtAttach.setAppId(prtTaskResult.getAppId());
        prtAttach.setUserId(prtTaskResult.getUserId());
        prtAttach.setDiskType(prtTaskResult.getDiskType());
        prtAttach.setTaskName(prtTaskResult.getTaskName());
        prtAttach.setExtType(prtTaskResult.getExtType());
        prtAttach.setServiceN(prtTaskResult.getServiceN());
        prtAttach.setPrinter(prtTaskResult.getPrinter());
        prtAttach.setStatus(prtTaskResult.getStatus());
        List attachs = prtTaskResult.getAttach();
        for (PrtTaskResult.Attach attach : attachs) {
            PrtAttach.AttachDetail detail = new PrtAttach.AttachDetail();
            detail.setAttachId(attach.getAttachId());
            detail.setFilePath(attach.getFilePath());
            detail.setFileName(attach.getFileName());
            detail.setSource(attach.getSource());
            detail.setExtParam(attach.getExtParam());
            prtAttach.addAttachDetail(detail);
        }
        return prtAttach;
    }

    private PrtTaskResult convertToPrtResult(PrtAttach prtAttach) {
        PrtTaskResult prtResult = new PrtTaskResult();
        prtResult.setTaskId(prtAttach.getTaskId());
        prtResult.setFormId(prtAttach.getFormId());
        prtResult.setOrgId(prtAttach.getOrgId());
        prtResult.setAppId(prtAttach.getAppId());
        prtResult.setUserId(prtAttach.getUserId());
        prtResult.setDiskType(prtAttach.getDiskType());
        prtResult.setTaskName(prtAttach.getTaskName());
        prtResult.setExtType(prtAttach.getExtType());
        prtResult.setServiceN(prtAttach.getServiceN());
        prtResult.setPrinter(prtAttach.getPrinter());
        prtResult.setStatus(prtAttach.getStatus());
        List attachs = prtAttach.getAttachDetail();
        attachs = attachs.stream().sorted(Comparator.comparingInt(PrtAttach.AttachDetail::getSeq)).collect(Collectors.toList());
        for (PrtAttach.AttachDetail attach : attachs) {
            PrtTaskResult.Attach detail = new PrtTaskResult.Attach();
            detail.setAttachId(attach.getAttachId());
            detail.setFilePath(attach.getFilePath());
            detail.setFileName(attach.getFileName());
            detail.setSource(attach.getSource());
            detail.setExtParam(attach.getExtParam());
            prtResult.addAttach(detail);
        }
        return prtResult;
    }
}

