/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.print.core.service.ICacheService;
import kd.bos.svc.acl.AclAdapter;

public class CacheServiceProvider
implements ICacheService {
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static volatile CacheServiceProvider provider = null;
    private static ICacheService.DistributeCache printDistributeCache = new DistributeCacheImpl();

    private CacheServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheServiceProvider getProvider() {
        if (provider != null) return provider;
        Class<CacheServiceProvider> clazz = CacheServiceProvider.class;
        synchronized (CacheServiceProvider.class) {
            if (provider != null) return provider;
            provider = new CacheServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    public ICacheService.DistributeCache getDistributeCache() {
        return printDistributeCache;
    }

    private static class DistributeCacheImpl
    implements ICacheService.DistributeCache {
        private DistributeCacheImpl() {
        }

        public void put(String key, String value, int timeoutSeconds) {
            distributeCache.put(key, (Object)value, timeoutSeconds);
        }

        public String get(String key) {
            return (String)distributeCache.get(key);
        }

        public void remove(String key) {
            distributeCache.remove(key);
        }
    }
}

