/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.execute.qrender.CJob;
import kd.bos.print.core.service.IClientService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrintFileUtil;

public class ClientScptServiceProvider
implements IClientService {
    private Log log = LogFactory.getLog(ClientScptServiceProvider.class);
    private DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static final String CLIENT_LOCAL_CACKE_KEY = "clientScpt_";
    private static String clientLocalServerUrl = "https://127.0.0.1:49425/lpServer";
    private int attachCount = 0;

    public static String getClientLocalServerUrl() {
        CustomParam customParam = new CustomParam();
        String key = "CLIENT_LOCAL_SERVER_URL";
        HashSet<String> searchKeySet = new HashSet<String>();
        searchKeySet.add(key);
        customParam.setSearchKeySet(searchKeySet);
        Map customParamMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if (customParamMap != null) {
            return customParamMap.getOrDefault(key, clientLocalServerUrl);
        }
        return clientLocalServerUrl;
    }

    public void setPrinter(String printer) {
    }

    public static String getTaskKey(String taskId) {
        return CLIENT_LOCAL_CACKE_KEY + taskId;
    }

    public void execute(CJob cJob) {
        if (cJob.getInfo() == null) {
            return;
        }
        cJob.setPrinter(null);
        cJob.setpNum(1);
        String sendText = SerializationUtils.toJsonString((Object)cJob);
        byte[] sendByte = sendText.getBytes(StandardCharsets.UTF_8);
        String fileName = cJob.getTaskId() + cJob.getSeq() + ".tpl";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sendByte);
        String tempKey = PrintFileUtil.saveInputStream2TempFile((String)fileName, (InputStream)inputStream, (int)1800);
        tempKey = cJob.isEnd() ? tempKey + "&isEnd=true" : tempKey + "&isEnd=false";
        String key = ClientScptServiceProvider.getTaskKey(ExecuteContext.get().getTaskId());
        this.distributeCache.put(key, String.valueOf(cJob.getSeq()), (Object)tempKey);
        this.attachCount = cJob.getSeq() + 1;
    }

    public int getCopyNum() {
        return 1;
    }

    public void savePrtResult(PrtAttach prtAttach) {
        prtAttach.setServiceN(String.valueOf(this.attachCount));
        AttachmentServiceProvider.getProvider().savePrtResult(prtAttach);
    }

    public int getMaxPageSize() {
        return 100;
    }

    public int getMinPageSize() {
        return 100;
    }

    public int getMaxIdeTime() {
        return 1200000;
    }
}

