/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.execute.qrender.CJob;
import kd.bos.print.core.execute.qrender.ClientCaptain;
import kd.bos.print.core.service.IClientService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.print.service.util.PrintClientMsgUtil;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.print.PrintFileUtil;
import org.apache.commons.lang.StringUtils;

public class ClientServiceProvider
implements IClientService {
    private Log log = LogFactory.getLog(ClientCaptain.class);
    private String serviceN;
    private String printer;
    private int copyNum;
    private int maxJobSize = 0x300000;

    public ClientServiceProvider(String serviceN, String printer) {
        this.serviceN = serviceN;
        this.printer = printer;
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String maxJobSizeStr = (String)customParam.get("ClientCaptain_MaxJobSize");
        if (StringUtils.isNotBlank((String)maxJobSizeStr)) {
            this.maxJobSize = Integer.parseInt(maxJobSizeStr);
        }
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public void setCopyNum(int copyNum) {
        this.copyNum = copyNum;
    }

    public void execute(CJob cJob) {
        cJob.setPrinter(this.printer);
        cJob.setpNum(this.copyNum);
        if (cJob.getSeq() == 0) {
            this.log.debug("\u6253\u5370\u5ba2\u6237\u7aef\u53d1\u9001\u7b2c\u4e00\u4e2a\u4efb\u52a1\uff0ctaskId={},isEnd={}", (Object)cJob.getTaskId(), (Object)cJob.isEnd());
        } else if (cJob.isEnd()) {
            this.log.debug("\u6253\u5370\u5ba2\u6237\u7aef\u53d1\u9001\u6700\u540e\u4e00\u4e2a\u4efb\u52a1\uff0ctaskId={},isEnd={}", (Object)cJob.getTaskId(), (Object)cJob.isEnd());
        }
        String sendText = SerializationUtils.toJsonString((Object)cJob);
        byte[] sendByte = sendText.getBytes(StandardCharsets.UTF_8);
        if (cJob.getSeq() > 5 || sendByte.length > this.maxJobSize) {
            String fileName = cJob.getTaskId() + cJob.getSeq() + ".tpl";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sendByte);
            String tempKey = PrintFileUtil.saveInputStream2TempFile((String)fileName, (InputStream)inputStream, (int)10800);
            String rcKey = Base64.getEncoder().encodeToString(tempKey.getBytes(StandardCharsets.UTF_8));
            cJob.setJobName(rcKey);
            cJob.setType("J1");
            cJob.setInfo(null);
            sendText = SerializationUtils.toJsonString((Object)cJob);
        }
        PrintClientMsgUtil.sendMsgToClient(this.serviceN, sendText);
    }

    public int getCopyNum() {
        return this.copyNum;
    }

    public void savePrtResult(PrtAttach prtAttach) {
        prtAttach.setServiceN(this.serviceN);
        prtAttach.setPrinter(this.printer);
        AttachmentServiceProvider.getProvider().savePrtResult(prtAttach);
    }
}

