/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.service.IFontService;
import kd.bos.print.core.service.PrtFont;
import kd.bos.svc.util.print.PrintFileUtil;

public class FontServiceProvider
implements IFontService {
    private static final Log log = LogFactory.getLog(FontServiceProvider.class);
    private PrtFont defaultFont = new PrtFont("\u601d\u6e90\u5b8b\u4f53 CN", "Source Han Serif CN", ".ttf");

    public List<PrtFont> getFonts() {
        String cacheKey = RequestContext.get().getTenantId();
        LocalMemoryCache fontCache = FontServiceProvider.getFontCache();
        Object cacheObj = fontCache.get(cacheKey);
        if (cacheObj != null) {
            List fontList = (List)cacheObj;
            return fontList;
        }
        List<PrtFont> fontList = this.getFontsFromDb();
        fontCache.put(cacheKey, fontList);
        fontCache.put(cacheKey + "_v", (Object)System.currentTimeMillis());
        return fontList;
    }

    public String getFontVer() {
        String cacheKey = RequestContext.get().getTenantId() + "_v";
        return String.valueOf(FontServiceProvider.getFontCache().get(cacheKey));
    }

    public PrtFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(PrtFont prtFont) {
        this.defaultFont = prtFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFont(PrtFont font) {
        InputStream inputStream;
        String fontFilesDir = this.getFontFilesDir();
        String fileName = font.getFontFileName();
        String fileFullName = fontFilesDir + File.separatorChar + fileName;
        File fontFile = new File(fileFullName);
        if (fontFile.exists()) {
            return fontFile;
        }
        long rcId = font.getRcId();
        Map<String, Object> rcObj = FontServiceProvider.getRcObj(rcId);
        String url = (String)rcObj.get("url");
        Object data = rcObj.get("data");
        if (data != null) {
            inputStream = new ByteArrayInputStream((byte[])data);
        } else if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                return fontFile;
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u5b57\u4f53\u201c%s\u201d\u6587\u4ef6\u88ab\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u635f\u574f\uff0c\u8bf7\u91cd\u65b0\u5220\u9664\u5f53\u524d\u5b57\u4f53\u3002", (String)"FontServiceProvider_0", (String)"bos-print-service", (Object[])new Object[0]);
            log.warn(String.format(msg, font.getFontName()));
            return fontFile;
        }
        try (FileOutputStream fos = new FileOutputStream(fontFile);){
            int index;
            byte[] bytes = new byte[1024];
            while ((index = inputStream.read(bytes)) != -1) {
                fos.write(bytes, 0, index);
                fos.flush();
            }
            Font.createFont(0, fontFile);
            log.info("\u6253\u5370 \uff1a \u5df2\u6210\u529f\u5c06" + fileName + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + fileFullName);
        }
        catch (Exception e) {
            if ((e instanceof FontFormatException || e instanceof IOException) && fontFile.exists() && !fontFile.delete()) {
                log.warn("\u5f02\u5e38\u5b57\u4f53\u5220\u9664\u5931\u8d25\uff1a" + fontFile.getAbsolutePath());
            }
            log.warn("\u6253\u5370 \uff1a\u5c06" + fileName + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return fontFile;
    }

    public String getFontFilesDir() {
        String result = "";
        String filePath = System.getProperty("user.dir");
        String fileSeparator = System.getProperty("file.separator");
        String fileName = filePath + fileSeparator + "font" + fileSeparator + "fonts.properties" + fileSeparator + RequestContext.get().getTenantId();
        File file = new File(fileName = PrintFileUtil.normalize((String)fileName));
        if (!file.exists()) {
            file.mkdirs();
        }
        result = file.getAbsolutePath();
        return result;
    }

    private List<PrtFont> getFontsFromDb() {
        String tenantId = RequestContext.get().getTenantId();
        ArrayList<PrtFont> fontList = new ArrayList<PrtFont>(10);
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter, new QFilter("billstatus", "=", (Object)"B")};
        Map fonts = BusinessDataReader.loadFromCache((String)"bos_prt_font", (QFilter[])filters);
        ArrayList sortList = new ArrayList(fonts.values());
        sortList.sort((o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String source1 = o1.getString("source");
            String source2 = o2.getString("source");
            if (source1 == null) {
                return -1;
            }
            if (source2 == null) {
                return 1;
            }
            return source1.compareTo(source2);
        });
        HashSet<String> fontSet = new HashSet<String>(16);
        ArrayList<Long> rcIds = new ArrayList<Long>(sortList.size());
        for (DynamicObject item2 : sortList) {
            String name = item2.getString("name");
            if (name == null || fontSet.contains(name)) continue;
            fontSet.add(name);
            rcIds.add(Long.parseLong(item2.getString("rcid")));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rcIds)};
        Map rcMap = BusinessDataReader.loadFromCache((String)"bos_print_resource", (QFilter[])qFilters);
        Map<String, DynamicObject> rcIdMap = sortList.stream().collect(Collectors.toMap(item -> item.getString("rcid"), item -> item));
        for (DynamicObject rcObj : rcMap.values()) {
            long rcId = rcObj.getLong("id");
            String fontFileName = rcObj.getString("filename");
            String suffix = fontFileName.substring(fontFileName.lastIndexOf(46));
            DynamicObject fontObj = rcIdMap.get(String.valueOf(rcId));
            String name = fontObj.getString("name");
            PrtFont prtFont = new PrtFont();
            prtFont.setFontName(name);
            prtFont.setFontCode(fontObj.getString("number"));
            prtFont.setFileSuffix(suffix);
            prtFont.setRcId(rcId);
            fontList.add(prtFont);
        }
        return fontList;
    }

    private static LocalMemoryCache getFontCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "FontCacheGroup", info);
    }

    private static Map<String, Object> getRcObj(long rcId) {
        String sql = "select furl,fdata from %s where fid=?";
        sql = String.format(sql, "t_svc_printresource");
        Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{rcId}, rSet -> {
            if (rSet.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("url", rSet.getString(1));
                result.put("data", rSet.getBytes(2));
                return result;
            }
            return null;
        });
        return res;
    }
}

