/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.service.ISensitiveService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.acl.AclAdapter;

public class SensitiveServiceProvider
implements ISensitiveService {
    private Map<String, Tuple<IDataEntityType, IDataEntityProperty>> mapping = new HashMap<String, Tuple<IDataEntityType, IDataEntityProperty>>(16);
    private boolean enablePrivacy;
    private Map<String, FieldControlRules> fieldControlRulesMap = new HashMap<String, FieldControlRules>(16);
    private long mainOrg = 0L;
    private Map<String, FieldControlRule> fieldControlRuleMap = new HashMap<String, FieldControlRule>(16);

    public SensitiveServiceProvider(boolean enablePrivacy) {
        this.enablePrivacy = enablePrivacy;
    }

    public boolean enablePrivacy() {
        return this.enablePrivacy;
    }

    public boolean isSensitive(String dataSource, String fieldKey) {
        return false;
    }

    public void deDesensitive(String formId, String dataSource, String fieldKey, Field field) {
        if (!this.enablePrivacy) {
            return;
        }
        String key = dataSource + "." + fieldKey;
        if (!this.mapping.containsKey(key)) {
            return;
        }
        Tuple<IDataEntityType, IDataEntityProperty> tuple = this.mapping.get(key);
        Object desensitizeValue = fieldKey.contains(".") ? this.getDesensitizeValue(formId, fieldKey, ExecuteContext.get().getLang(), field.getValue()) : this.getDesensitizeValue((IDataEntityProperty)tuple.item2, ExecuteContext.get().getLang(), field.getValue());
        if (desensitizeValue != null && desensitizeValue.equals(field.getValue())) {
            return;
        }
        field.setDisplayVal((String)Optional.ofNullable(desensitizeValue).map(Object::toString).orElse(null));
        field.setDesensitive(true);
    }

    public void deDesensitive(String formId, String dataSource, String fieldKey, IDataEntityType entityType, IDataEntityProperty prop, Field field) {
        if (!this.enablePrivacy) {
            return;
        }
        Object desensitizeValue = fieldKey.contains(".") ? this.getDesensitizeValue(formId, fieldKey, ExecuteContext.get().getLang(), field.getValue()) : this.getDesensitizeValue(prop, ExecuteContext.get().getLang(), field.getValue());
        if (desensitizeValue != null && desensitizeValue.equals(field.getValue())) {
            return;
        }
        field.setDisplayVal((String)Optional.ofNullable(desensitizeValue).map(Object::toString).orElse(null));
        field.setDesensitive(true);
        String key = dataSource + "." + fieldKey;
        if (!this.mapping.containsKey(key)) {
            this.mapping.put(key, (Tuple<IDataEntityType, IDataEntityProperty>)new Tuple((Object)entityType, (Object)prop));
        }
    }

    private FieldControlRules getFieldControlRules(String formId) {
        long userId = RequestContext.get().getCurrUserId();
        if (this.fieldControlRulesMap.containsKey(formId)) {
            return this.fieldControlRulesMap.get(formId);
        }
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.fieldControlRulesMap.put(formId, null);
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null) {
            this.fieldControlRulesMap.put(formId, null);
            return null;
        }
        this.fieldControlRulesMap.put(formId, fieldControlRules);
        return fieldControlRules;
    }

    public long getMainOrg() {
        return this.mainOrg;
    }

    private FieldControlRule getFieldControlRule(String formId, long orgId) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        String cacheKey = formId + "@_" + orgId;
        if (this.fieldControlRuleMap.containsKey(cacheKey)) {
            return this.fieldControlRuleMap.get(cacheKey);
        }
        FieldControlRules fieldControlRules = this.getFieldControlRules(formId);
        if (fieldControlRules == null) {
            return fieldControlRule;
        }
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        this.fieldControlRuleMap.put(cacheKey, fieldControlRule);
        return fieldControlRule;
    }

    public Field doFieldViewPermission(String formId, long orgId, String fieldKey, Field field) {
        if (!this.enablePrivacy) {
            return field;
        }
        this.mainOrg = orgId;
        FieldControlRule fieldControlRule = this.getFieldControlRule(formId, orgId);
        Set canNotReadFields = fieldControlRule.getCanNotReadFields();
        if (canNotReadFields == null || canNotReadFields.isEmpty()) {
            return field;
        }
        if (canNotReadFields.contains(fieldKey)) {
            if (field instanceof NullField) {
                field = new TextField("");
            }
            field.setDisplayVal("******");
            field.setDesensitive(true);
        }
        return field;
    }

    private Object getDesensitizeValue(IDataEntityProperty prop, String localeid, Object value) {
        return AclAdapter.getPrivacyCenterService().getDesensitizeValue(prop, localeid, "PRINT", null, value);
    }

    private Object getDesensitizeValue(String dataSource, String fieldKey, String localeid, Object value) {
        return AclAdapter.getPrivacyCenterService().getDesensitizeValue(dataSource, fieldKey, localeid, "PRINT", null, value);
    }
}

