/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.IInteService;
import kd.bos.print.core.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class UserServiceProvider
implements IUserService {
    private static IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
    private static final String CFG_SUFFIX = "_printsetting";
    private Map<String, String> timeFormat = null;
    private String dateFormat = null;

    public static UserServiceProvider getProvider() {
        return new UserServiceProvider();
    }

    public String getTenantId() {
        return RequestContext.get().getTenantId();
    }

    public String getUserName() {
        return RequestContext.get().getUserName();
    }

    public String getUserId() {
        return RequestContext.get().getUserId();
    }

    public String getOrgId() {
        return String.valueOf(RequestContext.get().getOrgId());
    }

    public Map<String, Object> getPrintSetting(String configKey) {
        configKey = configKey + CFG_SUFFIX;
        String userId = this.getUserId();
        if (!StringUtils.isNumeric((CharSequence)userId)) {
            return Collections.emptyMap();
        }
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            return (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getTimeFormat() {
        if (this.timeFormat == null) {
            Long userId = RequestContext.get().getCurrUserId();
            this.timeFormat = inteService.getTimeFormat(userId);
        }
        return this.timeFormat;
    }

    public String getDateFormat() {
        if (this.dateFormat == null) {
            Long userId = RequestContext.get().getCurrUserId();
            this.dateFormat = inteService.getDateFormat(userId);
        }
        return this.dateFormat;
    }
}

