/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.BaseControl;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.model.IBindFieldSupport;
import kd.bos.print.core.model.designer.common.IContainer;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.service.transform.ControlDto;
import kd.bos.print.service.transform.IR1ControlReader;
import kd.bos.print.service.transform.ReaderFactroy;
import kd.bos.print.service.transform.style.StyleCache;

public abstract class AbstractR1ControlReader
implements IR1ControlReader<IReportObject, ControlDto> {
    protected StyleCache _styleCache = new StyleCache();
    protected Paper paper;

    protected AbstractR1ControlReader getReader(String type) {
        AbstractR1ControlReader reader = ReaderFactroy.getReader(type);
        reader._styleCache = this._styleCache;
        return reader;
    }

    @Override
    public IReportObject parseObject(ControlDto controlDto) {
        BaseControl control = (BaseControl)controlDto.getControl();
        IReportObject reportObject = (IReportObject)this.createObject();
        reportObject.setId(control.getId());
        reportObject.setKey(control.getKey());
        reportObject.setXLom(this.parseToInt(control.getX()));
        reportObject.setYLom(this.parseToInt(control.getY()));
        reportObject.setWidthLom(this.parseToInt(control.getWidth()));
        reportObject.setHeightLom(this.parseToInt(control.getHeight()));
        reportObject.setPrintAtPage(control.getPrintAtPage());
        reportObject.setHide(control.isHidden());
        reportObject.setHideMove(control.isHideMove());
        StyleAttributes sa = this.getStyleCache().getStyle(control.getId());
        if (sa != null) {
            reportObject.setStyleAttribute(sa);
        }
        if (control instanceof BaseDsControl) {
            this.loadDataNode(reportObject, (BaseDsControl)control);
        }
        return reportObject;
    }

    @Override
    public void parseChildren(IContainer container, List<ControlDto> childs) {
        for (ControlDto dto : childs) {
            BaseControl baseControl;
            Control control = dto.getControl();
            if (control instanceof BaseControl && (baseControl = (BaseControl)control).isHidden()) continue;
            String type = control.getType();
            IReportObject reportObject = this.getReader(type).parseObject(dto);
            container.addChild(reportObject);
        }
    }

    protected void loadDataNode(IReportObject ro, BaseDsControl control) {
        if (!(ro instanceof IBindFieldSupport)) {
            return;
        }
        IBindFieldSupport roBind = (IBindFieldSupport)ro;
        String ds = control.getDataSource();
        roBind.setDatasource(ds);
        roBind.setBindField(control.getBindField());
        if (StringUtil.isEmptyString((String)ds)) {
            roBind.setBindField((String)control.getBindText().getLocaleValue());
        }
    }

    public int parseToInt(Object value) {
        if (value instanceof LocaleValue) {
            LocaleValue localeValue = (LocaleValue)value;
            return this.parseToInt(localeValue.getLocaleValue());
        }
        if (value instanceof Integer) {
            return (Integer)value * 10;
        }
        if (value instanceof Float) {
            return (int)(((Float)value).floatValue() * 10.0f);
        }
        if (value instanceof Double) {
            return (int)((Double)value * 10.0);
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value) * 10;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(10L));
            return bigDecimal.intValue();
        }
        return 0;
    }

    protected StyleCache getStyleCache() {
        return this._styleCache;
    }

    public Paper getPaper() {
        return this.paper;
    }

    public void setPaper(Paper paper) {
        this.paper = paper;
    }
}

