/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import java.awt.Color;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.prop.AnchorField;
import kd.bos.print.api.metedata.control.prop.Border;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideModel;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.CurrencyFormat;
import kd.bos.print.core.model.designer.AbstractTextObject;
import kd.bos.print.core.model.designer.common.IAnchorSupport;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.common.ITextSupport;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.ControlDto;
import kd.bos.print.service.transform.style.StyleCache;
import kd.bos.print.service.transform.style.StyleParser;

public abstract class AbstractTextReader
extends AbstractR1ControlReader {
    @Override
    public IReportObject parseObject(ControlDto dto) {
        AbstractTextObject textObject = (AbstractTextObject)super.parseObject(dto);
        Control control = dto.getControl();
        Text textControl = (Text)control;
        AbstractTextReader.loadTextProp((ITextSupport)textObject, textControl, this.getStyleCache());
        return textObject;
    }

    public static void loadTextProp(ITextSupport support, Text textControl, StyleCache styleCache) {
        int divideNums;
        boolean isDivided;
        String textOverFlow = textControl.getTextOverFlow();
        support.setAdjustHeight(StringUtils.equals((CharSequence)"WrapLine", (CharSequence)textOverFlow));
        support.setLineWrapRule(textControl.getLineWrapRule());
        support.setWordFlex(textControl.isWordFlex());
        support.setIgnoreTailZero(textControl.isIgnoreTailZero());
        support.setIgnoreZero(textControl.isIgnoreZero());
        support.setFormulaData(textControl.getFormulaData());
        if (textControl.isAnchor() && support instanceof IAnchorSupport) {
            IAnchorSupport anchorSupport = (IAnchorSupport)support;
            anchorSupport.setAnchor(textControl.isAnchor());
            AnchorField af = textControl.getAnchorField();
            if (af != null) {
                anchorSupport.setLinkField(af.getBindField());
                anchorSupport.setLinkDs(af.getDataSource());
                anchorSupport.setLinkDsType(af.getDsType());
            } else {
                anchorSupport.setLinkUrl(textControl.getAnchorText());
            }
        }
        if ((isDivided = textControl.isDivideModel()) && (divideNums = textControl.getDivideCharNums()) > 0) {
            Number inner;
            support.setDivideCharNums(divideNums);
            support.setAdjustHeight(false);
            textControl.setTextOverFlow("Truncate");
            boolean isShowDivideLine = false;
            Border border = (Border)textControl.getBorder().getLocaleValue();
            if (border != null && (inner = (Number)border.getWidth().getInner()) != null && inner.floatValue() > 0.0f) {
                isShowDivideLine = true;
            }
            if (isShowDivideLine) {
                DivideModel model = new DivideModel();
                model.setShowLine(isShowDivideLine);
                Color color = StyleParser.stringToColor((String)border.getColor().getInner());
                LineStyle lineStyle = StyleParser.getLineStyle((Number)border.getWidth().getInner());
                PenStyle penStyle = PenStyle.getPenStyle((String)((String)border.getStyle().getInner()));
                model.setLinesStyle(Styles.Position.TOP, penStyle, lineStyle, color);
                model.setLinesStyle(Styles.Position.RIGHT, penStyle, lineStyle, color);
                model.setLinesStyle(Styles.Position.LEFT, penStyle, lineStyle, color);
                model.setLinesStyle(Styles.Position.BOTTOM, penStyle, lineStyle, color);
                model.setLinesStyle(Styles.Position.DIAGONALRIGHT, penStyle, lineStyle, color);
                model.setLinesStyle(Styles.Position.DIAGONALLEFT, penStyle, lineStyle, color);
                support.setDivideModel(model);
            }
        }
        String textFormat = textControl.getTextFormat();
        support.setTextFormat(textFormat);
        if ("Amount".equals(textControl.getTextFormat())) {
            CurrencyFormat currencyObj = new CurrencyFormat();
            currencyObj.setUppercase(textControl.judgeUppercase());
            String currencyCode = textControl.getCurrencyCode();
            if (StringUtils.isBlank((CharSequence)currencyCode) || StringUtils.equals((CharSequence)"-", (CharSequence)currencyCode)) {
                currencyObj.setShowCurrency(false);
            } else {
                currencyObj.setShowCurrency(textControl.isShowCurrencySymbol());
                currencyObj.setShowCurrencySymbol(textControl.isShowCurrencySymbol());
                currencyObj.setShowCurrencyCode(textControl.isShowCurrencyCode());
                currencyObj.setCurrencyCode(textControl.getCurrencyCode());
            }
            support.setCurrencyFormat(currencyObj);
            support.setUppercaseType(textControl.getUppercaseType());
        } else {
            support.setShowPercentage(textControl.isShowPercentage());
            support.setNativeType(textControl.getNegativeType());
            support.setShowRedNegative(textControl.isShowRedNegative());
            if (StringUtils.equals((CharSequence)textFormat, (CharSequence)"Date")) {
                support.setFormat(textControl.getDateFormat());
            } else if (StringUtils.equals((CharSequence)textFormat, (CharSequence)"Time")) {
                support.setFormat(textControl.getTimeFormat());
            }
        }
        support.setThousandSplit(textControl.isThousandSplit());
        support.setJiaoZheng(textControl.isJiaoZheng());
        support.setPrecision(textControl.getPrecision());
    }
}

