/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import kd.bos.print.api.metedata.control.Barcode;
import kd.bos.print.api.metedata.control.BaseControl;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.ControlDto;

public class BarcodeReader
extends AbstractR1ControlReader {
    @Override
    public IReportObject createObject() {
        return new BarcodeObject();
    }

    @Override
    public IReportObject parseObject(ControlDto dto) {
        BarcodeObject barcodeObj = (BarcodeObject)super.parseObject(dto);
        BaseControl control = (BaseControl)dto.getControl();
        barcodeObj.setScale(0);
        barcodeObj.setBarCodeFontSize(14);
        barcodeObj.setDpi(300);
        int width = this.parseToInt(control.getWidth());
        if (width != 0) {
            barcodeObj.setModelWidth(1.0);
        }
        barcodeObj.setBarHeight((double)this.parseToInt(control.getHeight()));
        barcodeObj.setShowSample(false);
        this.parseSpecial(barcodeObj, control);
        return barcodeObj;
    }

    protected void parseSpecial(BarcodeObject barcodeObj, BaseControl control) {
        Barcode barcode = (Barcode)control;
        int rotate = barcode.getRotate();
        barcodeObj.setBarcodeType(barcode.getEncodeMode());
        barcodeObj.setShowText(barcode.isShowLabel());
        barcodeObj.setSampleTxt((String)barcode.getBindText().getLocaleValue());
        barcodeObj.setRotate(rotate);
        barcodeObj.setFormulaData(barcode.getFormulaData());
    }
}

