/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import java.util.List;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.model.designer.R1PrintPage;
import kd.bos.print.core.model.designer.common.IContainer;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.ControlDto;

public class PaperReader
extends AbstractR1ControlReader {
    @Override
    public IReportObject createObject() {
        R1PrintPage page = new R1PrintPage();
        page.setExtendProperty("pi", (Object)new R1PrintInfo());
        return page;
    }

    @Override
    public IReportObject parseObject(ControlDto controlDto) {
        List<ControlDto> children;
        Paper control = (Paper)controlDto.getControl();
        R1PrintPage page = (R1PrintPage)this.createObject();
        page.setId(control.getId());
        int width = this.parseToInt(control.getWidth()) - this.parseToInt(control.getMarginLeft()) - this.parseToInt(control.getMarginRight());
        int height = this.parseToInt(control.getHeight()) - this.parseToInt(control.getMarginTop()) - this.parseToInt(control.getMarginBottom());
        page.setWidthLom(width);
        page.setHeightLom(height);
        page.setKey(control.getKey());
        StyleAttributes sa = this.getStyleCache().getStyle(control.getId());
        if (sa != null) {
            page.setStyleAttribute(sa);
        }
        if ((children = controlDto.getChildren()) != null && children.size() > 0) {
            this.parseChildren((IContainer)page, children);
        }
        return page;
    }
}

