/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.RichText;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.api.metedata.control.grid.tabletail.TableTail;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.R1PrintPage;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.ControlDto;

public class PrintMetadataReader
extends AbstractR1ControlReader {
    private static final Map<String, String> newFormatsMap = new HashMap<String, String>(16);

    @Override
    public IR1Page createObject() {
        R1PrintPage page = new R1PrintPage();
        page.setExtendProperty("pi", (Object)new R1PrintInfo());
        return page;
    }

    public ReportModel parseModel(PrintMetadata metadata) {
        ReportModel model = new ReportModel();
        R1PrintInfo info = this.readFromMeta(metadata);
        model.setR1PrintInfo(info);
        Paper paper = metadata.getPaper();
        String pageId = paper.getId();
        List pages = metadata.getPages();
        for (List page : pages) {
            ControlDto paperDto = new ControlDto((Control)paper);
            LinkedHashMap<String, ControlDto> controlMetaMap = new LinkedHashMap<String, ControlDto>(16);
            controlMetaMap.put(pageId, paperDto);
            ArrayList<String> groupIds = new ArrayList<String>();
            for (Control control : page) {
                if (control instanceof Text) {
                    String timeFormat;
                    String dateFormat;
                    Text textControl = (Text)control;
                    String textFormat = textControl.getTextFormat();
                    if ("Date".equals(textFormat) && !"-".equals(dateFormat = textControl.getDateFormat())) {
                        textControl.setDateFormat(newFormatsMap.getOrDefault(dateFormat, dateFormat));
                    }
                    if ("Time".equals(textFormat) && !"-".equals(timeFormat = textControl.getTimeFormat())) {
                        textControl.setTimeFormat(newFormatsMap.getOrDefault(timeFormat, timeFormat));
                    }
                }
                if (control instanceof RichText) {
                    model.setHasRichText(true);
                }
                if (control instanceof DataGrid && metadata.getPaper().isDynamicPaper()) {
                    DataGrid dataGrid = (DataGrid)control;
                    dataGrid.setFixedRowAtPage(false);
                }
                if (control instanceof LayoutGridRow && "Group".equals(((LayoutGridRow)control).getRowType())) {
                    groupIds.add(control.getId());
                }
                controlMetaMap.put(control.getId(), new ControlDto(control));
            }
            for (String string : groupIds) {
                ControlDto groupDto = (ControlDto)controlMetaMap.get(string);
                LayoutGridRow groupRow = (LayoutGridRow)groupDto.getControl();
                String parentId = groupRow.getParentId();
                ControlDto parentCd = (ControlDto)controlMetaMap.get(parentId);
                DataGrid dataGrid = (DataGrid)parentCd.getControl();
                String ds = dataGrid.getDataSource();
                groupRow.setDataSource(ds);
            }
            this.getStyleCache().cacheStyleFromPage(page);
            for (Map.Entry entry : controlMetaMap.entrySet()) {
                ControlDto parControl;
                ControlDto controlDto = (ControlDto)entry.getValue();
                Control control = controlDto.getControl();
                String parId = control.getParentId();
                if (control instanceof SubDataGrid) {
                    SubDataGrid subDataGrid = (SubDataGrid)control;
                    parId = subDataGrid.getParentGridId();
                } else if (control instanceof LayoutGridCell) {
                    LayoutGridCell cell = (LayoutGridCell)control;
                    parId = cell.getRowId();
                } else if (control instanceof TableTail) {
                    parId = ((TableTail)control).getParentGridId();
                }
                if ((parControl = (ControlDto)controlMetaMap.get(parId)) == null) continue;
                List<ControlDto> children = parControl.getChildren();
                if (children == null) {
                    children = new ArrayList<ControlDto>();
                }
                children.add(controlDto);
                parControl.setChildren(children);
            }
            ControlDto controlMeta = (ControlDto)controlMetaMap.get(pageId);
            controlMetaMap.clear();
            IR1Page iR1Page = (IR1Page)this.getReader("Paper").parseObject(controlMeta);
            iR1Page.setExtendProperty("pi", (Object)info);
            model.addPage(iR1Page);
        }
        return model;
    }

    private R1PrintInfo readFromMeta(PrintMetadata metadata) {
        R1PrintInfo info = new R1PrintInfo();
        Paper paper = metadata.getPaper();
        int topM = this.parseToInt(paper.getMarginTop());
        int leftM = this.parseToInt(paper.getMarginLeft());
        int bottomM = this.parseToInt(paper.getMarginBottom());
        int rightM = this.parseToInt(paper.getMarginRight());
        info.setMarginTop(topM);
        info.setMarginLeft(leftM);
        info.setMarginBottom(bottomM);
        info.setMarginRight(rightM);
        Map extParam = ExecuteContext.get().getExtParam();
        int pageWidth = this.parseToInt(paper.getWidth());
        int pageHeght = this.parseToInt(paper.getHeight());
        if (extParam != null && extParam.get("removemargin") != null && Boolean.parseBoolean(extParam.get("removemargin").toString())) {
            info.setMarginTop(0);
            info.setMarginLeft(0);
            pageHeght += topM;
        }
        if (Objects.equals("vertical", paper.getPaperDirection())) {
            info.setOrientation("PORTRAIT");
        } else {
            info.setOrientation("LANDSCAPE");
        }
        info.setPaperWidth(pageWidth);
        info.setPaperHeight(pageHeght);
        info.setPaperName(paper.getPaperType());
        if (ExecuteContext.get().isVerEconomizePaper() || ExecuteContext.get().isHorEconomizePaper()) {
            info.setVerEconomizePaper(ExecuteContext.get().isVerEconomizePaper());
            info.setHorEconomizePaper(ExecuteContext.get().isHorEconomizePaper());
        } else {
            info.setVerEconomizePaper(paper.isVerticalEconomize());
            info.setHorEconomizePaper(paper.isHorizonEconomize());
        }
        if (info.isHorEconomizePaper() || info.isVerEconomizePaper()) {
            metadata.getPaper().setDynamicPaper(false);
        } else if (this.isTurnoffPaging(extParam)) {
            info.setDynamicPaper(true);
        } else {
            info.setDynamicPaper(("Custom".equals(paper.getPaperType()) || "1".equals(metadata.getBizType())) && paper.isDynamicPaper());
        }
        info.setPageNumType(ExecuteContext.get().getPageNumType());
        info.setShowBgImage(paper.isShowBgImage());
        info.setBgImageUrl(paper.getBgImgRcId());
        return info;
    }

    private boolean isTurnoffPaging(Map<String, Object> extParam) {
        return extParam != null && Boolean.parseBoolean(extParam.getOrDefault("turnoffpaging", "false").toString());
    }

    static {
        newFormatsMap.put("h:mm;@", "H:mm;@");
        newFormatsMap.put("h:mm:ss;@", "H:mm:ss;@");
        newFormatsMap.put("h\u65f6mm\u5206;@", "H\u65f6mm\u5206;@");
        newFormatsMap.put("h\u65f6mm\u5206ss\u79d2;@", "H\u65f6mm\u5206ss\u79d2;@");
        newFormatsMap.put("[DBNum1]h\u65f6mm\u5206;@", "[DBNum1]H\u65f6mm\u5206;@");
        newFormatsMap.put("yyyy-m-d", "yyyy-M-d");
        newFormatsMap.put("yyyy-mm-dd", "yyyy-MM-dd");
        newFormatsMap.put("yyyy\\/m\\/d", "yyyy\\/M\\/d");
        newFormatsMap.put("yyyy\\/mm\\/dd HH:mm:ss", "yyyy\\/MM\\/dd HH:mm:ss");
        newFormatsMap.put("[DBNum1]yyyy\u5e74m\u6708d\u65e5;@", "[DBNum1]yyyy\u5e74M\u6708d\u65e5;@");
        newFormatsMap.put("[DBNum1]yyyy\u5e74m\u6708;@", "[DBNum1]yyyy\u5e74M\u6708;@");
        newFormatsMap.put("[DBNum1]m\u6708d\u65e5;@", "[DBNum1]M\u6708d\u65e5;@");
        newFormatsMap.put("yyyy\u5e74m\u6708d\u65e5;@", "yyyy\u5e74M\u6708d\u65e5;@");
        newFormatsMap.put("yyyy\u5e74m\u6708;@", "yyyy\u5e74M\u6708;@");
        newFormatsMap.put("m\u6708d\u65e5;@", "M\u6708d\u65e5;@");
        newFormatsMap.put("yyyy-m-d h:mm AM/PM;@", "yyyy-M-d h:mm AM/PM;@");
        newFormatsMap.put("yyyy-m-d h:mm;@", "yyyy-M-d H:mm;@");
        newFormatsMap.put("yy-m-d;@", "yy-M-d;@");
        newFormatsMap.put("m-d;@", "M-d;@");
        newFormatsMap.put("m-d-yy;@", "M-d-yy;@");
        newFormatsMap.put("mm-dd-yy;@", "MM-dd-yy;@");
        newFormatsMap.put("d-mmm;@", "d-MMM;@");
        newFormatsMap.put("dd-mmm-yy;@", "dd-MMM-yy;@");
        newFormatsMap.put("mmm-yy;@", "MMM-yy;@");
        newFormatsMap.put("dd-mmm-yyyy;@", "dd-MMM-yyyy;@");
        newFormatsMap.put("mmmm-yy;@", "MMMM-yy;@");
        newFormatsMap.put("mmmmm;@", "MMMMM;@");
        newFormatsMap.put("mmmmm-yy;@", "MMMMM-yy;@");
        newFormatsMap.put("yyyymmdd", "yyyyMMdd");
    }
}

