/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.BarcodeReader;
import kd.bos.print.service.transform.HeaderFooterReader;
import kd.bos.print.service.transform.ImageReader;
import kd.bos.print.service.transform.LineReader;
import kd.bos.print.service.transform.PaperReader;
import kd.bos.print.service.transform.QRCodeReader;
import kd.bos.print.service.transform.RichTextReader;
import kd.bos.print.service.transform.TextReader;
import kd.bos.print.service.transform.grid.CardGridReader;
import kd.bos.print.service.transform.grid.DataGridReader;
import kd.bos.print.service.transform.grid.LayoutGridReader;
import kd.bos.print.service.transform.grid.SubDataGridReader;
import kd.bos.print.service.transform.grid.TableTailReader;
import kd.bos.util.ThreadLocals;

public class ReaderFactroy {
    private static ThreadLocal<Map<String, AbstractR1ControlReader>> controlReaderFactory = ThreadLocals.create();

    private static Map<String, AbstractR1ControlReader> getReaderMap() {
        Map<String, AbstractR1ControlReader> context = controlReaderFactory.get();
        if (context == null) {
            controlReaderFactory.set(new HashMap());
        }
        return controlReaderFactory.get();
    }

    private static AbstractR1ControlReader createInstance(String key) {
        if ("Paper".equalsIgnoreCase(key)) {
            return new PaperReader();
        }
        if ("Text".equalsIgnoreCase(key)) {
            return new TextReader();
        }
        if ("RichText".equalsIgnoreCase(key)) {
            return new RichTextReader();
        }
        if ("Image".equalsIgnoreCase(key)) {
            return new ImageReader();
        }
        if ("Barcode".equals(key)) {
            return new BarcodeReader();
        }
        if ("QRCode".equals(key)) {
            return new QRCodeReader();
        }
        if ("Header".equals(key) || "Footer".equals(key)) {
            return new HeaderFooterReader();
        }
        if ("DataGrid".equals(key)) {
            return new DataGridReader();
        }
        if ("SubDataGrid".equals(key)) {
            return new SubDataGridReader();
        }
        if ("LayoutGrid".equals(key)) {
            return new LayoutGridReader();
        }
        if ("CardGrid".equals(key)) {
            return new CardGridReader();
        }
        if ("TableTail".equals(key)) {
            return new TableTailReader();
        }
        if ("Line".equals(key)) {
            return new LineReader();
        }
        throw new RuntimeException("Unknown: " + key);
    }

    public static AbstractR1ControlReader getReader(String type) {
        Map<String, AbstractR1ControlReader> readerMap = ReaderFactroy.getReaderMap();
        if (!readerMap.containsKey(type)) {
            readerMap.put(type, ReaderFactroy.createInstance(type));
        }
        return readerMap.get(type);
    }
}

