/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform.grid;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridColumn;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import kd.bos.print.core.model.designer.common.AbstractElement;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.common.ITextSupport;
import kd.bos.print.core.model.designer.grid.AbstractCell;
import kd.bos.print.core.model.designer.grid.AbstractColumn;
import kd.bos.print.core.model.designer.grid.AbstractGrid;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.designer.grid.datagrid.DataGrid;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridDetailRow;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridGroupRow;
import kd.bos.print.core.model.designer.grid.datagrid.R1PrintGroup;
import kd.bos.print.core.model.designer.grid.layoutgrid.LayoutGrid;
import kd.bos.print.core.model.designer.grid.tabletail.ITableTailModel;
import kd.bos.print.core.model.designer.grid.tabletail.TableTail;
import kd.bos.print.service.transform.AbstractR1ControlReader;
import kd.bos.print.service.transform.ControlDto;
import kd.bos.print.service.transform.TextReader;

public class AbstractGridReader
extends AbstractR1ControlReader {
    @Override
    public IReportObject createObject() {
        return new LayoutGrid();
    }

    @Override
    public IReportObject parseObject(ControlDto controlDto) {
        AbstractGrid grid = (AbstractGrid)super.parseObject(controlDto);
        kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid dDataGrid = (kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid)controlDto.getControl();
        List<ControlDto> childs = controlDto.getChildren();
        for (ControlDto controlDto2 : childs) {
            Control control = controlDto2.getControl();
            if (control instanceof SubDataGrid) {
                IReportObject iReportObject = this.getReader(control.getType()).parseObject(controlDto2);
                DataGrid dataGrid = (DataGrid)grid;
                dataGrid.addSubDataGrid((DataGrid)iReportObject);
                continue;
            }
            if (control instanceof LayoutGridColumn) {
                this.loadColumn(grid, (LayoutGridColumn)control);
                continue;
            }
            if (!(control instanceof kd.bos.print.api.metedata.control.grid.tabletail.TableTail) || ((kd.bos.print.api.metedata.control.grid.tabletail.TableTail)control).isHidden()) continue;
            IReportObject tableTail = this.getReader(control.getType()).parseObject(controlDto2);
            ((ITableTailModel)grid).setTableTail((TableTail)tableTail);
        }
        boolean hasStatRow = this.hasStatRow(childs);
        for (ControlDto dto : childs) {
            Control control = dto.getControl();
            if (!(control instanceof LayoutGridRow)) continue;
            LayoutGridRow gridRow = (LayoutGridRow)control;
            String rowType = gridRow.getRowType();
            if ("Detail".equalsIgnoreCase(rowType) && !hasStatRow) {
                for (ControlDto cellDto : dto.getChildren()) {
                    LayoutGridCell cell = (LayoutGridCell)cellDto.getControl();
                    StyleAttributes sa = this.getStyleCache().getStyle(cell.getId());
                    sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                }
            }
            this.loadRow(grid, dto);
        }
        Map map = dDataGrid.getMergeConfig();
        if (!CollectionUtils.isEmpty((Map)map)) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Map config = (Map)entry.getValue();
                int rowStart = (Integer)config.get("rowStart");
                int columnStart = (Integer)config.get("columnStart");
                int rowLength = (Integer)config.get("rowLength");
                int columnLength = (Integer)config.get("columnLength");
                MergeBlock block = MergeBlock.create((int)columnStart, (int)(columnStart + columnLength - 1), (int)rowStart, (int)(rowStart + rowLength - 1));
                grid.getMergeBlocks().put(key, block);
            }
        }
        return grid;
    }

    protected void loadColumn(AbstractGrid grid, LayoutGridColumn cColumn) {
        String type = "Normal";
        AbstractColumn column = grid.addColumn();
        column.setColumnType(type);
        this.loadCommon((AbstractElement)column, (Control)cColumn);
        column.setWidthLom(this.parseToInt(cColumn.getColumnWidth()));
    }

    protected void loadCommon(AbstractElement element, Control control) {
        element.setId(control.getId());
        element.setHide(false);
        StyleAttributes sa = this.getStyleCache().getStyle(control.getId());
        if (sa != null) {
            element.setStyleAttribute(sa);
        }
    }

    protected void loadRow(AbstractGrid grid, ControlDto dto) {
        Control control = dto.getControl();
        LayoutGridRow cRow = (LayoutGridRow)control;
        AbstractRow row = this.createRow(grid, cRow.getRowType());
        if (row instanceof DataGridGroupRow) {
            R1PrintGroup group = new R1PrintGroup(cRow.getBindField());
            group.setAccordingType(1);
            group.setDividePageWhenDifferGroup(((DataGridRow)control).isPageByGroup());
            ((DataGridGroupRow)row).setGroup((R1DataGridGroup)group);
        }
        if (row instanceof DataGridDetailRow) {
            ((DataGridDetailRow)row).setMergeByField(((DataGridRow)control).getMergeByField());
            ((DataGridDetailRow)row).setMergeSummaryField(((DataGridRow)control).getMergeSummaryField());
        }
        this.loadCommon((AbstractElement)row, (Control)cRow);
        row.setHeightLom(this.parseToInt(cRow.getRowHeight()));
        List<ControlDto> cells = dto.getChildren();
        Map<String, ControlDto> cellMap = cells.stream().collect(Collectors.toMap(item -> ((LayoutGridCell)item.getControl()).getColumnId(), item -> item));
        List columns = grid.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            AbstractColumn column = (AbstractColumn)columns.get(i);
            ControlDto controlDto = cellMap.get(column.getId());
            LayoutGridCell designCell = (LayoutGridCell)controlDto.getControl();
            String textOverFlow = designCell.getTextOverFlow();
            AbstractCell cell = row.getCell(i);
            if ("WrapLine".equals(textOverFlow)) {
                cell.setAdjustHeight(true);
            }
            cell.setLineWrapRule(designCell.getLineWrapRule());
            cell.setWordFlex(designCell.isWordFlex());
            this.loadCell(cell, designCell);
            List<ControlDto> children = controlDto.getChildren();
            if (children == null || children.size() <= 0) continue;
            this.loadCellChildren(cell, children);
        }
    }

    protected AbstractRow createRow(AbstractGrid grid, String rowType) {
        AbstractRow row = grid.addRow(1);
        return row;
    }

    protected void loadCell(AbstractCell cell, LayoutGridCell designCell) {
        this.loadCommon((AbstractElement)cell, (Control)designCell);
        this.loadCellValue(designCell, cell);
        TextReader.loadTextProp((ITextSupport)cell, (Text)designCell, this.getStyleCache());
    }

    protected void loadCellChildren(AbstractCell cell, List<ControlDto> childs) {
        for (ControlDto dto : childs) {
            Control control = dto.getControl();
            IReportObject iReportObject = this.getReader(control.getType()).parseObject(dto);
            cell.addChild(iReportObject);
        }
    }

    void loadCellValue(LayoutGridCell designCell, AbstractCell cell) {
        String dataSource = designCell.getDataSource();
        cell.setDatasource(dataSource);
        if (StringUtils.isNotBlank((CharSequence)dataSource)) {
            cell.setBindField(designCell.getBindField());
        } else {
            cell.setBindField((String)designCell.getBindText().getLocaleValue());
        }
    }

    private boolean hasStatRow(List<ControlDto> childs) {
        boolean flag = false;
        for (ControlDto dto : childs) {
            LayoutGridRow gridRow;
            String rowType;
            Control control = dto.getControl();
            if (!(control instanceof LayoutGridRow) || !"Statistic".equalsIgnoreCase(rowType = (gridRow = (LayoutGridRow)control).getRowType())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected void changeGridAllCellAdjustFalse(AbstractGrid grid) {
        for (int index = 0; index < grid.getRowsCount(); ++index) {
            AbstractRow row = grid.getRow(index);
            if (row == null) continue;
            for (int i = 0; i < row.getCellCount(); ++i) {
                AbstractCell cell = row.getCell(i);
                this.setCellAdjustFalse(cell);
            }
        }
    }

    protected void setCellAdjustFalse(AbstractCell cell) {
        if (cell == null) {
            return;
        }
        cell.setAdjustHeight(false);
    }
}

