/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform.grid;

import java.util.Collection;
import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.grid.AbstractCell;
import kd.bos.print.core.model.designer.grid.AbstractGrid;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridCell;
import kd.bos.print.service.transform.ControlDto;
import kd.bos.print.service.transform.grid.AbstractGridReader;

public class DataGridReader
extends AbstractGridReader {
    @Override
    public IReportObject createObject() {
        return new kd.bos.print.core.model.designer.grid.datagrid.DataGrid();
    }

    @Override
    public IReportObject parseObject(ControlDto controlDto) {
        kd.bos.print.core.model.designer.grid.datagrid.DataGrid grid = (kd.bos.print.core.model.designer.grid.datagrid.DataGrid)super.parseObject(controlDto);
        DataGrid dDataGrid = (DataGrid)controlDto.getControl();
        grid.setFixedRowAtPage(dDataGrid.isFixedRowAtPage());
        grid.setFixedRowCount(dDataGrid.getFixedRowCount());
        List subDataGrids = grid.getSubDataGrids();
        if (!CollectionUtils.isEmpty((Collection)subDataGrids)) {
            boolean hasHGrid = false;
            for (kd.bos.print.core.model.designer.grid.datagrid.DataGrid subDataGrid : subDataGrids) {
                if (!"right".equals(subDataGrid.getSubGridDirection())) continue;
                hasHGrid = true;
                break;
            }
            if (!hasHGrid) {
                grid.setNotBlankRow(dDataGrid.isNotBlankRow());
                for (kd.bos.print.core.model.designer.grid.datagrid.DataGrid subDataGrid : subDataGrids) {
                    subDataGrid.setNotBlankRow(dDataGrid.isNotBlankRow());
                }
            }
        } else {
            grid.setNotBlankRow(dDataGrid.isNotBlankRow());
        }
        grid.setNormalRowEveryPage(dDataGrid.isNormalRowEveryPage());
        grid.setStatRowEveryPage(dDataGrid.isStatRowEveryPage());
        grid.setDatasource(dDataGrid.getDataSource());
        grid.setBorderType(dDataGrid.getBorderType());
        grid.setWholeRowPage(dDataGrid.isWholeRowPage());
        grid.setWholeGridPage(dDataGrid.isWholeGridPage());
        grid.setStatWithData(dDataGrid.isStatWithData());
        grid.setHideEmptyMove(dDataGrid.isHideEmptyMove());
        grid.setMergePrint(dDataGrid.isMergePrint());
        if (grid.isFixedRowAtPage()) {
            grid.setAutoAdjustHeight(false);
            this.changeGridAllCellAdjustFalse((AbstractGrid)grid);
        } else {
            grid.setAutoAdjustHeight(dDataGrid.isAutoAdjustHeight());
        }
        return grid;
    }

    @Override
    protected AbstractRow createRow(AbstractGrid grid, String rowType) {
        AbstractRow row = null;
        if ("Detail".equalsIgnoreCase(rowType)) {
            row = grid.addRow(2);
        } else if ("Statistic".equalsIgnoreCase(rowType)) {
            row = grid.addRow(6);
        } else if ("extend".equals(rowType)) {
            row = grid.addRow(5);
            row.setExtRow(true);
        } else if ("Normal".equals(rowType)) {
            row = grid.addRow(1);
        } else if ("Group".equals(rowType)) {
            row = grid.addRow(3);
        }
        return row;
    }

    @Override
    protected void loadCell(AbstractCell cell, LayoutGridCell designCell) {
        super.loadCell(cell, designCell);
        String cellType = designCell.getCellType();
        DataGridCell gridCell = (DataGridCell)cell;
        kd.bos.print.api.metedata.control.grid.datagrid.DataGridCell dataGridCell = (kd.bos.print.api.metedata.control.grid.datagrid.DataGridCell)designCell;
        if ("Statistic".equalsIgnoreCase(cellType)) {
            String statType = dataGridCell.getStatType();
            gridCell.setStatType(statType);
            this.setCellAdjustFalse((AbstractCell)gridCell);
        }
        gridCell.setMergeSummary(dataGridCell.isMergeSummary());
    }
}

