/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform.style;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideModel;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.service.transform.style.StyleParser;

public class StyleCache {
    private HashMap styleCache;
    private HashMap styleCache2;
    private int styleID;

    public HashMap getCache() {
        if (this.styleCache == null) {
            this.styleCache = new HashMap();
        }
        return this.styleCache;
    }

    private HashMap getCache2() {
        if (this.styleCache2 == null) {
            this.styleCache2 = new HashMap();
        }
        return this.styleCache2;
    }

    private String getStyleID() {
        return String.valueOf(this.styleID++);
    }

    public void cacheStyleFromMeta(PrintMetadata meta) {
        List pages = meta.getPages();
        DivideModel model = new DivideModel();
        this.getCache().put("divideLineId", model.getSSA());
        for (List page : pages) {
            this.cacheStyleFromPage(page);
        }
    }

    public void cacheStyleFromPage(List<Control> page) {
        for (Control ctrl : page) {
            this.getCache().put(ctrl.getId(), StyleParser.parseSA(ctrl));
        }
    }

    public String cacheStyle(StyleAttributes sa) {
        String key = (String)this.getCache2().get(sa);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = this.getStyleID();
            this.getCache().put(key, sa);
            this.getCache2().put(sa, key);
        }
        return key;
    }

    public StyleAttributes getStyle(String key) {
        return (StyleAttributes)this.getCache().get(key);
    }
}

