/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform.style;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.RichText;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.prop.Border;
import kd.bos.print.api.metedata.control.prop.BorderProp;
import kd.bos.print.api.metedata.control.prop.Padding;
import kd.bos.print.api.metedata.control.support.IBorderSupport;
import kd.bos.print.business.utils.PrintColorUtil;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;

public class StyleParser {
    private StyleParser() {
    }

    public static String colorToHex(Color color) {
        return PrintColorUtil.colorToHex((Color)color);
    }

    public static StyleAttributes parseSA(Control control) {
        StyleAttributes sa = Styles.getEmptySA();
        if (control instanceof Paper) {
            return StyleParser.parseSA(sa, (Paper)control);
        }
        if (control instanceof IBorderSupport) {
            StyleParser.parseBorderStyle(sa, (IBorderSupport)control);
        }
        if (control instanceof Text) {
            StyleParser.parseTextStyle(sa, (Text)control);
        }
        if (control instanceof RichText) {
            StyleParser.parseRichTextStyle(sa, (RichText)control);
        }
        if (control instanceof Image) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
            if (((Image)control).getHorAlignment() != null && null != ((Image)control).getHorAlignment().getLocaleValue()) {
                sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)((String)((Image)control).getHorAlignment().getLocaleValue())));
            }
            if (((Image)control).getVerAlignment() != null && null != ((Image)control).getVerAlignment().getLocaleValue()) {
                sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((String)((String)((Image)control).getVerAlignment().getLocaleValue())));
            }
        }
        return sa;
    }

    private static StyleAttributes parseSA(StyleAttributes sa, Paper ctrl) {
        return sa;
    }

    private static void parseRichTextStyle(StyleAttributes sa, RichText ctrl) {
        String textOverFlow = ctrl.getTextOverFlow();
        if ("WrapLine".equals(textOverFlow)) {
            sa.setWrapText(true);
        } else if ("ShrinkWrap".equals(textOverFlow)) {
            sa.setShrinkText(true);
            sa.setWrapText(true);
        } else if ("Truncate".equals(textOverFlow)) {
            sa.setWrapText(true);
            sa.setClip(true);
        } else if ("OverFlow".equals(textOverFlow)) {
            sa.setWrapText(false);
            sa.setClip(false);
        }
        if (ctrl.getFontName() != null) {
            sa.setFontName((String)ctrl.getFontName().getLocaleValue());
        }
    }

    private static void parseTextStyle(StyleAttributes sa, Text ctrl) {
        Padding padding;
        String textOverFlow = ctrl.getTextOverFlow();
        int lineWrapRule = ctrl.getLineWrapRule();
        if ("WrapLine".equals(textOverFlow)) {
            sa.setWrapText(true);
        } else if ("ShrinkWrap".equals(textOverFlow)) {
            sa.setShrinkText(true);
        } else if ("Truncate".equals(textOverFlow)) {
            if (lineWrapRule != 3) {
                sa.setWrapText(true);
            }
            sa.setClip(true);
        } else if ("OverFlow".equals(textOverFlow)) {
            sa.setWrapText(false);
            sa.setClip(false);
        }
        if (ctrl.getPadding() != null && (padding = (Padding)ctrl.getPadding().getLocaleValue()) != null) {
            sa.setPadding(new Rect(padding.getLeft().intValue(), padding.getTop().intValue(), padding.getRight().intValue(), padding.getBottom().intValue()));
        }
        if (ctrl.getVerAlignment() != null) {
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((String)((String)ctrl.getVerAlignment().getLocaleValue())));
        }
        if (ctrl.getHorAlignment() != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)((String)ctrl.getHorAlignment().getLocaleValue())));
        }
        if (ctrl.getFontSizeF() != null && ctrl.getFontSizeF().getLocaleValue() != null) {
            Object value = ctrl.getFontSizeF().getLocaleValue();
            Float fontSize = Float.valueOf(12.0f);
            if (value instanceof Integer || value instanceof String || value instanceof Float) {
                fontSize = Float.valueOf(Float.parseFloat(value.toString()));
                sa.setFontSize(fontSize.floatValue());
            } else if (value instanceof BigDecimal) {
                fontSize = Float.valueOf(Float.parseFloat(value.toString()));
                sa.setFontSize(fontSize.floatValue());
            }
            if (ctrl.getLineSpace() != null && ctrl.getLineSpace().getLocaleValue() != null) {
                double lineSpace = ((Number)ctrl.getLineSpace().getLocaleValue()).doubleValue();
                sa.setLinespacing((float)lineSpace);
                sa.setLinespacingType(1);
            }
        }
        if (ctrl.getFontName() != null) {
            sa.setFontName((String)ctrl.getFontName().getLocaleValue());
        }
        if (ctrl.getForeColor() != null) {
            sa.setFontColor(StyleParser.stringToColor((String)ctrl.getForeColor().getLocaleValue()));
        }
        if (ctrl.getBackColor() != null) {
            sa.setBackground(StyleParser.stringToColor((String)ctrl.getBackColor().getLocaleValue()));
        }
        if (ctrl.getBold() != null) {
            sa.setBold(Optional.ofNullable(ctrl.getBold().getLocaleValue()).orElseGet(() -> false).booleanValue());
        }
        if (ctrl.getItalic() != null) {
            sa.setItalic(Optional.ofNullable(ctrl.getItalic().getLocaleValue()).orElseGet(() -> false).booleanValue());
        }
        if (ctrl.getUnderLine() != null) {
            sa.setUnderline(Optional.ofNullable(ctrl.getUnderLine().getLocaleValue()).orElseGet(() -> false).booleanValue());
        }
        if (!CollectionUtils.isEmpty((Map)ctrl.getStrike()) && ctrl.getStrike().getLocaleValue() != null) {
            sa.setStrikeThrough(Optional.ofNullable(ctrl.getStrike().getLocaleValue()).orElseGet(() -> false).booleanValue());
        }
    }

    private static void parseBorderStyle(StyleAttributes sa, IBorderSupport ctrl) {
        if (ctrl.getBorder() != null) {
            BorderProp style;
            BorderProp width;
            BorderProp color;
            Border border = (Border)ctrl.getBorder().getLocaleValue();
            if (border == null) {
                border = (Border)ctrl.getBorder().getDefaultValue();
            }
            if ((color = border.getColor()) != null) {
                sa.setBorderColor(Styles.Position.LEFT, StyleParser.stringToColor((String)color.getLeft()));
                sa.setBorderColor(Styles.Position.RIGHT, StyleParser.stringToColor((String)color.getRight()));
                sa.setBorderColor(Styles.Position.TOP, StyleParser.stringToColor((String)color.getTop()));
                sa.setBorderColor(Styles.Position.BOTTOM, StyleParser.stringToColor((String)color.getBottom()));
            }
            if ((width = border.getWidth()) != null) {
                sa.setBorderLineStyle(Styles.Position.LEFT, StyleParser.getLineStyle((Number)width.getLeft()));
                sa.setBorderLineStyle(Styles.Position.RIGHT, StyleParser.getLineStyle((Number)width.getRight()));
                sa.setBorderLineStyle(Styles.Position.TOP, StyleParser.getLineStyle((Number)width.getTop()));
                sa.setBorderLineStyle(Styles.Position.BOTTOM, StyleParser.getLineStyle((Number)width.getBottom()));
            }
            if ((style = border.getStyle()) != null) {
                sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.getPenStyle((String)((String)style.getLeft())));
                sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.getPenStyle((String)((String)style.getRight())));
                sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.getPenStyle((String)((String)style.getTop())));
                sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.getPenStyle((String)((String)style.getBottom())));
            }
        }
    }

    public static LineStyle getLineStyle(Number width) {
        if (width == null) {
            return LineStyle.NULL_LINE;
        }
        float widthVal = width.floatValue();
        LineStyle lineStyle = StyleParser.floatEqual(widthVal, 0.5f) ? LineStyle.getLineStyle((String)"Single0.5") : (StyleParser.floatEqual(widthVal, 1.0f) ? LineStyle.getLineStyle((String)"Single") : (StyleParser.floatEqual(widthVal, 2.0f) ? LineStyle.getLineStyle((String)"DoubleB") : (StyleParser.floatEqual(widthVal, 3.0f) ? LineStyle.getLineStyle((String)"TrigramSolid") : (widthVal < 10.0f ? LineStyle.getLineStyle((String)("Width" + width)) : LineStyle.getLineStyle((String)"Width9")))));
        return lineStyle;
    }

    private static boolean floatEqual(float v1, float v2) {
        float abs = Math.abs(v1 - v2);
        return !(abs > 0.0f);
    }

    public static Color stringToColor(String str) {
        return PrintColorUtil.stringToColor((String)str);
    }
}

