/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.util;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StreamUtil;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.print.service.util.BMPReader;
import kd.bos.util.StringUtils;

public class ImageUtil {
    private static final Log log = LogFactory.getLog(ImageUtil.class);

    public static Image getImage(String str) {
        byte[] bytes = ImageUtil.getImageByteContent(str);
        if (bytes != null) {
            return ImageUtil.makeImage(bytes);
        }
        return null;
    }

    public static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap(data);
        }
        return new ImageIcon(data).getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageByteContent(String str) {
        if (!StringUtils.isBlank((String)str)) {
            String filePath = str;
            if (str.startsWith("file://")) {
                filePath = str.substring(7);
            }
            InputStream in = null;
            try {
                in = new FileInputStream(new File(filePath));
            }
            catch (FileNotFoundException e) {
                log.warn("The file below is not found: " + filePath, (Throwable)e);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn("Read Picture I/O error.", (Throwable)e);
                    }
                }
            }
            byte[] content = null;
            try {
                content = StreamUtil.readInputStream((InputStream)in);
                return content;
            }
            catch (IOException e1) {
                log.warn("Read Picture I/O error.", (Throwable)e1);
            }
        }
        return new byte[0];
    }

    public static byte[] getImageByUrl(String imageUrl) {
        return AttachmentServiceProvider.getProvider().getImage(imageUrl);
    }

    @Deprecated
    public static byte[] readImageFromNet(String fullUrl) throws IOException {
        return AttachmentServiceProvider.getProvider().getImage(fullUrl);
    }
}

