/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.util;

import java.util.Map;
import kd.bos.msgjet.MsgSendFactory;

public class PrintClientMsgUtil {
    public static void sendMsgToClient(String serviceN, String msg) {
        MsgSendFactory.getSender().send(serviceN, msg);
    }

    public static void sendMsgToClient(String serviceN, MsgType msgType) {
        if (msgType == MsgType.S_HEART_PONG) {
            PrintClientMsgUtil.sendMsgToClient(serviceN, "{\"type\":\"heartPong\"}");
        } else if (msgType == MsgType.S_CONNECT_PONG) {
            PrintClientMsgUtil.sendMsgToClient(serviceN, "{\"type\":\"connectedPong\"}");
        } else if (msgType == MsgType.S_PRINTER_CHANGE) {
            PrintClientMsgUtil.sendMsgToClient(serviceN, "{\"type\":\"printerChange\"}");
        }
    }

    public static MsgType getMsgType(Map<String, Object> message) {
        if (message == null) {
            return MsgType.UNKNOW;
        }
        String type = String.valueOf(message.get("type"));
        if ("heartPing".equals(type)) {
            return MsgType.R_HEART_PING;
        }
        if ("updateStatus".equals(type)) {
            return MsgType.R_UPDATES_TATUS;
        }
        if ("clearTask".equals(type)) {
            return MsgType.R_CLEAR_TASK;
        }
        if ("printerStatus".equals(type)) {
            return MsgType.R_PRINTER_STATUS;
        }
        return MsgType.UNKNOW;
    }

    public static enum MsgType {
        UNKNOW,
        S_HEART_PONG,
        S_CONNECT_PONG,
        S_PRINTER_CHANGE,
        R_HEART_PING,
        R_UPDATES_TATUS,
        R_CLEAR_TASK,
        R_PRINTER_STATUS;

    }
}

